package com.shoutcast.stm.radio_nome.rests;

import com.shoutcast.stm.radio_nome.callbacks.CallbackAlbumArt;
import com.shoutcast.stm.radio_nome.callbacks.CallbackConfig;

import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface ApiInterface {

    String CACHE = "Cache-Control: max-age=0";
    String AGENT = "Data-Agent: Pink Radio Live";
    @GET
    Call<CallbackConfig> getJsonUrl(
            @Url String url
    );

    @Headers({CACHE, AGENT})
    @GET("search")
    Call<CallbackAlbumArt> getAlbumArt(
            @Query("term") String term,
            @Query("media") String media,
            @Query("limit") int limit
    );

}
