var rk = "";
var WOWZA = WOWZA || {};
WOWZA.RestProxy = WOWZA.RestProxy || {};

WOWZA.RestProxy.push=function(val){rk += atob(val);}
WOWZA.RestProxy.pull=function(){return rk;}

WOWZA.RestProxy.request = function(appType, vhost, appName, dataPost, cb) {

	var payload = WOWZA.RestProxy.hide(dataPost, rk);

	//console.log('WOWZA.RestProxy.request data post: ' +payload);
	$.ajax( {
		type : "POST",
		url : "applications/" + appType + "/streamtarget/prop.json",
		data : "vhost=" + vhost + "&appName=" + appName + "&payload=" + payload + "&hidden=true",
		datatype : "application/json",
		contentType : "application/x-www-form-urlencoded;charset=UTF-8",
		timeout: 20000,
		success: function(respJSON) {
			// The call to the WSE REST API succeeded, but the must check whether the contained call to the WSC API succeeded and react accordingly
			var response;
			var resp = JSON.parse(respJSON);

			if (resp.success == true && resp.data)
			{
				var data = JSON.parse(resp.data);
				var internalResp = null;
	
				if (data.encrypted)
				{
					var split = data.apiResponse.split(":::");
					var input = forge.util.createBuffer(forge.util.hexToBytes(split[1]));
					var iv = forge.util.hexToBytes(split[0]);
					internalResp = WOWZA.RestProxy.show(input, rk, iv);
				}
				else
				{
					internalResp = data.apiResponse;
				}
				
				// The entire WSC apiResponse string is URI-encoded, so decode it first
				response = decodeURIComponent(internalResp);
				
				// Convert the escaped unicode characters (which are embedded in the EULA text) to the unicode char values
				var regex = /\\u([\d\w]{4})/gi;
				response = response.replace(regex, function (match, grp) {
					 return String.fromCharCode(parseInt(grp, 16)); 
				});
	
				// Replace double-escapes (double backslashes) with proper single-escapes so the response string
				// can be successfully parsed as json. The double-escapes are an artifact of quote-escaping done
				// by WSE to allow the WSC API response to be embedded in the WSE API response.
				response = response.replace(/\\\\/g,"\\");
	
				cb(true, response);
			}
			else
			{
				cb(false, null);
			}

		},
		error : function(respJSON) {
			cb(false, null);
		},
		complete : function(respJSON) {
			
		}
	});//end ajax call

	return;
}

WOWZA.RestProxy.hide = function(dataString, key) {
	var iv = forge.random.getBytesSync(16);
	var cipher = forge.cipher.createCipher('AES-CBC', key);
	cipher.start({iv: iv});
	cipher.update(forge.util.createBuffer(dataString));
	cipher.finish();
	var encrypted = forge.util.bytesToHex(iv) + ":::" + cipher.output.toHex();
	return encrypted;
};

WOWZA.RestProxy.show = function(encrypted, key, iv) {
	var decipher = forge.cipher.createDecipher('AES-CBC', key);
	decipher.start({iv: iv});
	decipher.update(encrypted);
	decipher.finish();
	var decrypted = decipher.output.toString();
	return decrypted;
};


var chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz*&-%/!?*+=()";
var rand = generateRandomString(50);
function generateRandomString(keyLength){
	var randomstring = '';
	for (var i=0; i < keyLength; i++) {
		var rnum = Math.floor(Math.random() * chars.length);
		randomstring += chars.substring(rnum,rnum+1);
	}
	return randomstring;
};

