<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="readonly" required="true" rtexprvalue="true" %>

<re:mark>Display all users table</re:mark>

<c:set var="obj" >
	users
</c:set>
<c:set var="currentUser">
	<sec:authentication property="principal" />
</c:set>
<c:if test="${fn:length(requestScope.formData[obj])>0}">
	<table class="table table-striped">
		<tr>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.userName"/></th>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.accessLevel"/></th>
			<th style="width:15px"><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
		</tr>
		<c:forEach items="${requestScope.formData[obj]}" var="item">
			<c:set var="advUser" value=""/>
			<c:set var="accessLevel" value=""/>
			<tr>
				<c:choose>
					<c:when test="${readonly}">
						<td class="breakall">${item}</td>
						<td></td>
					</c:when>
					<c:otherwise>
						<c:set var="accessLevel" value="Read-Only"/>
						<c:if test="${fn:contains(item['groups'],'admin')}">
							<c:set var="accessLevel" value="Admin"/>
						</c:if>
						<c:if test="${fn:contains(item['groups'],'advUser')}">
							<c:set var="advUser" value="(advanced)"/>
						</c:if>
						<td class="breakall"><a href='javascript:showUser("${item["userName"]}")' title='View'>${item["userName"]}</a></td>
						<td class="breakall">${accessLevel} ${advUser}</td>
						<td>
							<sec:authorize access="hasAnyRole('admin')">
							<a href='javascript:showEditUser("${item["userName"]}")' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this user'></i></a>
								<c:if test="${currentUser!= item['userName']}">
									<a href='javascript:removeUser("${item["userName"]}")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this user'></i></a>
								</c:if>
							</sec:authorize>
						</td>
					</c:otherwise>
				</c:choose>
			</tr>
		</c:forEach>
	</table>
</c:if>

<wmsdialog:deleteuser page="${page}"/>
<script>

var deleteUserName="";

function removeUser(name)
{
	deleteUserName=name;
	deleteUserShow();
}

function showUser(name)
{
	loadAjaxMainContent("server/user/view.htm", "userName="+name);
}

function showEditUser(name)
{
	loadAjaxMainContent("server/user/edit.htm", "userName="+name+"&action=quickEdit");
}

var tblDataUsers = new Array();

initTableDataUsers();

function initTableDataUsers()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.name = "${item['userName']}";
		tblDataUsers.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>
