<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="showCustom" required="false" rtexprvalue="true" %>

<re:mark>Display all advanced tables quick links</re:mark>
<c:set var="obj" >
	advancedTables
</c:set>
<wmsform:propertieswarningmsg page="adv"/>

<div class="row">
	<div class="col-md-10">
		<h4><wmsform:getlocalestring page="${page}" obj="quickLinks"/> 
		<small><wmsform:getlocalestring page="${page}" obj="quickLinks.help"/> </small></h4>
	</div>
	<div class="col-md-2">
	</div>
</div>

<ul class="nav nav-pills well well-sm">
	<c:forEach items="${requestScope.formDataAdv[obj]}" var="entry">
		<li>
			<a href="#${entry.key}Anchor" id="${entry.key}QuickLink" data-toggle="tooltip" title="<wmsform:getlocalestring page="${page}" obj="advancedTables.${entry.key}Help"/>" data-animation="true" data-placement="top" data-delay="150" >
				<wmsform:getlocalestring page="${page}" obj="advancedTables.${entry.key}"/>
			</a>
		</li>
		<script>  
			$(function ()  
				{ $("#${entry['key']}QuickLink").tooltip();  
			});  
		</script>
	</c:forEach>	
	<c:if test="${empty showCustom}">
		<li>
			<a href="#customTableAnchor" id="customQuickLink" data-toggle="tooltip" title="Custom properties added by you. Add custom properties to extend the functionality of Wowza Streaming Engine." data-animation="true" data-placement="right" data-delay="150" >
				<wmsform:getlocalestring page="${page}" obj="custom"/>
			</a>
		</li>
		<script>  
				$(function ()  
					{ $("#customQuickLink").tooltip();  
				});  
		</script>
	</c:if>	
</ul>

<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>