<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all server listeners tables</re:mark>

<c:set var="obj" >
	listenersList
</c:set>
<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/serversetup/edit_listeners.htm','','mainContent','defaultFormListenerns')"/>
<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/serversetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />

<div class="advanced-table-title">
	<h4 id="listeners"><wmsform:getlocalestring page="${page}.listeners" obj="listener"/>
	<small><wmsform:getlocalestring page="${page}.listeners" obj="listenerHelp"/></small></h4>
	<wmsform:button page="${page}.listeners" obj="addListener" onClick="javascript:addListenerShow()" icon="fa fa-plus" cssClass="btn btn-default"/>
</div>
<table class="table table-striped" id="listenersTable">
</table>

<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/serversetup/edit_listeners.htm','','mainContent','defaultFormListenerns')"/>
<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/serversetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />
<wmsdialog:addlistener page="${page}"/>


<c:set var="baseClassLabel">
	<wmsform:getlocalestring page="${page}.listeners" obj="baseClass"/>
</c:set>
<c:set var="actionLabel">
	<wmsform:getlocalestring page="${page}.listeners" obj="action"/>
</c:set>

<script>
var tblDataListeners = new Array();
var tblIdxListeners=0;

initTableDataListeners();
updateTableListeners();

function initTableDataListeners()
{
	<c:forEach items="${requestScope.formDataListeners[obj]}" var="item">
		var newItem = new Object();
		newItem.orgIdx = tblIdxListeners++;
		newItem.removed = "${item['removed']}"==="true";
		newItem.order = "${item['order']}";
		newItem.baseClass = "${item['baseClass']}";
		tblDataListeners.push(newItem);
	</c:forEach>
}

function updateTableListeners()
{
	var tbl = document.getElementById('listenersTable');
	if(tbl==null)
		return;
	while (tbl.firstChild) {
		tbl.removeChild(tbl.firstChild);
	}
	var tblString="";
	tblString+="<tr>";
	tblString+="<th>${baseClassLabel}</th>";
	tblString+="<th width='50px'>${actionLabel}</th>";
	tblString+="</tr>";
	
	var goodItems=0;
	for (tblItem in tblDataListeners) {
		if(!tblDataListeners[tblItem].removed)
		{
			goodItems++;
		}
	}
	var displayed=0;
	for (tblItem in tblDataListeners) {
		if(tblDataListeners[tblItem].removed)
		{
			tblString+="<tr style='display:none'><td>";
		}
		else {
			tblString+="<tr>";
		}
		
		tblString+="<input id='${obj}"+tblItem+".order' name='${obj}["+tblItem+"].order' type='hidden' value='"+tblDataListeners[tblItem].order+"'>";			
		tblString+="<input id='${obj}"+tblItem+".removed' name='${obj}["+tblItem+"].removed' type='hidden' value='"+tblDataListeners[tblItem].removed+"'>";			

		if(tblDataListeners[tblItem].removed)
		{
			tblString+="</td></tr>";
			tblString+="<tr style='display:none'></tr>";
		}
		else 
		{	
			tblString+="<td>";
			tblString+="<input id='${obj}"+tblItem+".baseClass' name='${obj}["+tblItem+"].baseClass' title='' type='text' value='"+tblDataListeners[tblItem].baseClass+"' class='form-control'>";						
			tblString+="</td>";

			if(displayed==0 && goodItems>1)
			{
				tblString+="<td class='action-icons'><div class='row'>";
				tblString+="<div class='col-md-6 sort-down'><a href='javascript:moveListenerDown("+ tblItem + ")'><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move listener down'></i></a></div>";
				tblString+="<div class='col-md-6 trash-icon'><a href='javascript:removeListener("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this listener'></i></a></div>";
				tblString+="</div></td>";
			}
			if(displayed!=0 && displayed==goodItems-1 )
			{
				tblString+="<td class='action-icons'><div class='row'>";
				tblString+="<div class='col-md-6'><a href='javascript:moveListenerUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move listener up'></i></a></div>";
				tblString+="<div class='col-md-6 trash-icon'><a href='javascript:removeListener("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this listener'></i></a></div>";				
				tblString+="</div></td>";			
			}
			if(displayed!=goodItems-1 && displayed!=0 && goodItems!=1)
			{
				tblString+="<td class='action-icons'><div class='row'>";
				tblString+="<div class='col-md-6'><a href='javascript:moveListenerUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move listener up'></i></a><br>";
				tblString+="<a href='javascript:moveListenerDown("+ tblItem + ")'><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move listener down'></i></a></div>";
				tblString+="<div class='col-md-6 trash-icon'><a href='javascript:removeListener("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this listener'></i></a></div>";				
				tblString+="</div></td>";	
			}
			if(goodItems==1)
			{
				tblString+="<td class='action-icons-single'><div class='row'>";
				tblString+="<a href='javascript:removeListener("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this listener'></i></a>";				
				tblString+="</div></td>";	
			}
			tblString+="</tr>";
			displayed++;
		}
	}

	$('#listenersTable').html(tblString);
}
	
function removeListener(orgIdx)
{
	tblDataListeners[orgIdx].removed=true;
	tblDataListeners[orgIdx].enabled=false;
	if(tblDataListeners[orgIdx].added) //value did not exsits before and was just added
	{
		tblDataListeners.splice(orgIdx,1); //remove it
	}
	updateTableListeners();
}
function moveListenerDown(idx)
{
	if(idx >= tblDataListeners.length-1) {
		return;
	}
	//move swap the .order of local var tablData
	var a = tblDataListeners[idx];
	var b= tblDataListeners[idx+1];
	tblDataListeners[idx]=b;
	tblDataListeners[idx+1]=a;
	a.order=idx+1;
	b.order=idx;
	updateTableListeners();
	//swap the data in the hidden form inputs
	/*
	var i1=tblDataListeners[idx].orgIdx;
	var i2=tblDataListeners[idx+1].orgIdx;
	obj1 = document.getElementById('${obj}'+i1+'.order'); 
	obj2 = document.getElementById('${obj}'+i2+'.order'); 
	tmp = obj1.value;
	obj1.value=obj2.value;
	obj2.value=tmp;
	*/
}
function moveListenerUp(idx)
{
	if(idx <=0) {
		return;
	}
	var a = tblDataListeners[idx];
	var b= tblDataListeners[idx-1];
	tblDataListeners[idx]=b;
	tblDataListeners[idx-1]=a;
	a.order=idx-1;
	b.order=idx;
	updateTableListeners();
	//swap the data in the hidden form inputs
	/*
	var i1=tblDataListeners[idx].orgIdx;
	var i2=tblDataListeners[idx-1].orgIdx;
	obj1 = document.getElementById('${obj}'+i1+'.order'); 
	obj2 = document.getElementById('${obj}'+i2+'.order'); 
	tmp = obj1.value;
	obj1.value=obj2.value;
	obj2.value=tmp;
	*/
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>