<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="pick" required="true" rtexprvalue="true" %>
<%@ attribute name="cssClass" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>
<%@ attribute name="readonly" required="false" rtexprvalue="true" %>
<%@ attribute name="required" required="false" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="bind" required="false" rtexprvalue="true" %>

<re:mark>Display a text box</re:mark>

<re:mark>Get the tooltip based on page and obj</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
</c:set>
<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>

<c:if test="${ empty readonly}">
	<c:set var="readonly" value="false"/>
</c:if>
<c:if test="${ empty bind}">
	<c:set var="bind" value="true"/>
</c:if>
<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<re:mark>Title</re:mark>
		<c:if test="${ empty showTitle}">
			<label class="control-label" for="${obj}">
			<wmsform:getlocalestring page="${page}" obj="${obj}"/>	
			<c:if test="${! empty required}">
				*
			</c:if>
			</label>
		</c:if>
	
	<div class="controls">
		<re:mark>Text box</re:mark>
		<c:choose>
			<c:when test="${bind=='true'}">
	
				<div class="radio">
					<c:choose>	
			     		<c:when test="${requestScope.formData[pick] == 1}">
						 	<input type="radio" name="${pick}" id="${pick}" value="1" checked>
			     		</c:when>
			     		<c:otherwise>
							<input type="radio" name="${pick}" id="${pick}" value="1">
			     		</c:otherwise>
					</c:choose>
					<wmsform:getlocalestring page="appconfig" obj="storageDirOption.default"/><br>
					<div class="help-block">
						\${com.wowza.wms.context.VHostConfigHome}/content
					</div>
				</div>
				<div class="radio">
					<c:choose>	
			     		<c:when test="${requestScope.formData[pick] == 2}">
							<input type="radio" name="${pick}" id="${pick}" value="2" checked>
			     		</c:when>
			     		<c:otherwise>
							<input type="radio" name="${pick}" id="${pick}" value="2">
			     		</c:otherwise>
					</c:choose>
					<wmsform:getlocalestring page="appconfig" obj="storageDirOption.application"/><br>
					<div class="help-block">
						\${com.wowza.wms.context.VHostConfigHome}/content/${appName}
					</div>
				</div>
				<div class="radio">
					<c:choose>	
			     		<c:when test="${requestScope.formData[pick] == 3}">
							<input type="radio" name="${pick}" id="${pick}" value="3" checked>
			     		</c:when>
			     		<c:otherwise>
							<input type="radio" name="${pick}" id="${pick}" value="3">
			     		</c:otherwise>
					</c:choose>
					<wmsform:getlocalestring page="appconfig" obj="storageDirOption.custom"/><br>
				</div>

			    <div class="indent1">
			    	<form:input path="${obj}" title="${tooltip_msg}" class="${cssClass}" readonly="${readonly}"/>
			    </div>
			</c:when>
			<c:otherwise>
			<!-- TODO add unbound directory options -->
			</c:otherwise>
		</c:choose>

		<c:set var="objunits">
			<wmsform:getlocalestring page="${page}" obj="${obj}.units"/>
		</c:set>
		<c:choose>
			<c:when test='${ not (fn:endsWith(objunits,"units"))}'>
				<div class="help-block">
					${fn:trim(objunits)}
				</div>
			</c:when>
		</c:choose>
		
		<re:mark>Errors and warnings</re:mark>
		<c:if test="${bind=='true'}">
			<wmsform:errors path="${obj}"/>
			<wmsform:warnings path="${obj}"/>
		</c:if>
		<c:set var="objhelp">
			<wmsform:getlocalestring page="${page}" obj="${obj}.help"/>
		</c:set>
		<c:choose>
			<c:when test='${ not (fn:endsWith(objhelp,"help"))}'>
				<span class="help-block">${fn:trim(objhelp)}</span>
			</c:when>
		</c:choose>
	</div>
</div>

<script>
setStorageDirOptionDisabled();

var radios = document.getElementsByName('${pick}');
for(var i=0; i< radios.length; i++) {
    radios[i].onclick = setStorageDirOptionDisabled;
}

function setStorageDirOptionDisabled()
{
	var radios = document.getElementsByName('${pick}');
	if(radios.length>0)
	{
		if(radios[0].checked || radios[1].checked)
		{
			$('#${obj}').prop('disabled', true);
			$('#${obj}').val("");
		}
		else {
			$('#${obj}').prop('disabled', false);
			if($('#${obj}').val()=="")
			{
				$('#${obj}').val("\${com.wowza.wms.context.VHostConfigHome}/content");
			}
		}
	}
}
</script>
