<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="removeStreamGroupModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="removeStreamGroupModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:removeStreamGroupClose()">x</button>
					<h4 id="removeStreamGroupModalLabel" class="modal-title"><wmsform:getlocalestring page="removeStreamGroupDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="removeStreamGroupDialog" obj="message"/> <b><span id="removeGroupName"></span></b>?</p>
						<p class="text-warning"><wmsform:getlocalestring page="removeStreamGroupDialog" obj="warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:removeStreamGroupClose()"/>
					<wmsform:buttonok  onClick="javascript:doRemoveStreamGroup()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentInstance="";
var currentGroup="";
var currentApp;

function removeStreamGroupShow(app, appInstance, streamGroup) {
	$('#removeGroupName').text(streamGroup);
	currentApp=app;
	currentInstance=appInstance;
	currentGroup=streamGroup;
	$('#removeStreamGroupModal').on("shown.bs.modal", function() {});
	$('#removeStreamGroupModal').modal('show');	
}

function removeStreamGroupClose() {
	$('#removeStreamGroupModal').modal('hide');
}

function doRemoveStreamGroup() {
	$('#removeStreamGroupModal').on('hidden.bs.modal', function() {
		postAJAXForm('groups/${page}/removeGroup.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&instanceName='+encodeURIComponent(currentInstance)+'&group='+encodeURIComponent(currentGroup)+'&returnPage=${page}');
	});
	removeStreamGroupClose();
}

</script>