<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<c:set var="filenameInvalid">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="streamNameInvalid">
	<wmsform:getlocalestring page="common" obj="invalidStreamName"/>
</c:set>
<c:set var="fieldEmpty">
	<wmsform:getlocalestring page="common" obj="emptyField"/>
</c:set>
<c:set var="appInstanceOptionLabel">
	<wmsform:getlocalestring page="connectStreamFileDialog" obj="appInstanceOption.label"/>
</c:set>
<c:set var="appInstanceOptionDefault">
	<wmsform:getlocalestring page="connectStreamFileDialog" obj="appInstanceOption.default"/>
</c:set>
<c:set var="appInstanceOptionCustom">
	<wmsform:getlocalestring page="connectStreamFileDialog" obj="appInstanceOption.custom"/>
</c:set>

<div id="connectStreamFileModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="connectStreamModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<fieldset>
				<div class="modal-header">
					<button type="button" class="close" onClick="javascript:connectStreamFileClose()">x</button>
					<h4 id="connectStreamFileModalLabel" class="modal-title">
						<span id='connectStreamTitle'>
							<wmsform:getlocalestring page="connectStreamFileDialog" obj="connectStreamTitle"/>
						</span>
						<span id='connectSMILTitle'>
							<wmsform:getlocalestring page="connectStreamFileDialog" obj="connectSMILTitle"/>
						</span>
						<span id='addToStartupStreams'>
							<wmsform:getlocalestring page="connectStreamFileDialog" obj="addToStartupStreams"/>
						</span>
					</h4>
				</div>
				<div class="modal-body">
					<wmsform:editproperty page="connectStreamFileDialog" obj="streamName" bind="false" cssClass="form-control"/>
					<wmsform:viewproperty page="connectStreamFileDialog" obj="streamNameView" bind="false"/>

					<wmsform:editpropertydropdown page="connectStreamFileDialog" obj="applicationName" bind="false"  cssClass="form-control" options="-Select an existing application-"/>
					<!-- wmsform:editproperty page="connectStreamFileDialog" obj="applicationName" bind="false" cssClass="form-control"/-->
					<wmsform:viewproperty page="connectStreamFileDialog" obj="applicationNameView" bind="false"/>
					<div class="form-group" id="appInstanceOptionCtrlGroup">
						<label class="control-label">${appInstanceOptionLabel}</label>
						<div class="radio">
							<input type="radio" name="appInstanceOption" id="appInstanceOption" value="${appInstanceOptionDefault}">
							${appInstanceOptionDefault}
						</div>
						<div class="radio">
							<input type="radio" name="appInstanceOption" id="appInstanceOption" value="${appInstanceOptionCustom}">
							${appInstanceOptionCustom}
						</div>
					</div>

				  	<div class=indent1>
						<wmsform:editproperty page="connectStreamFileDialog" obj="instanceName" bind="false" cssClass="form-control" showTitle="no"/>
					</div>
					<wmsform:editpropertydropdown page="connectStreamFileDialog" obj="mediaCasterType"  bind="false" options="rtp,rtp-record,shoutcast,shoutcast-record,liverepeater,applehls,mpegtstcp,srt"/>

				</div>
				<div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:connectStreamFileClose()"/>
					<wmsform:buttonok  onClick="javascript:doConnectStreamFile()"/>
				</div>
			</fieldset>
		</div>
	</div>
</div>
<script>
var currentDialogType="";
var currentAppName="";
var currentStreamFile="";
var currentAppInstance="";
var currentMediaCasterType="";
var currentAppInstanceOption="";

$(document).ready(function() {
	for(var i=0;i < liveApplications.length;i++) {
		var app = liveApplications[i];
		var appName=app.name;
		$('#applicationName').append( new Option(appName,appName) );
	}
	loadData();
	$('input[name="appInstanceOption"]').click(function() {
		appInstanceOptionChanged();
	});
});

function connectStreamFileShow(appName, streamFile) {
	currentDialogType="stream";
	$('#connectStreamTitle').show();
	$('#connectSMILTitle').hide();
	$('#addToStartupStreams').hide();
	$('#streamName').val(streamFile);
	$('#streamNameViewValue').text(streamFile);
	showConnectDialog(appName, streamFile);
}

function connectSMILFileShow(appName, streamFile) {
	currentDialogType="smil";
	$('#connectStreamTitle').hide();
	$('#connectSMILTitle').show();
	$('#addToStartupStreams').hide();
	$('#streamName').val(streamFile);
	$('#streamNameViewValue').text(streamFile);
	showConnectDialog(appName, streamFile);
}

function addStartupStreamShow() {
	currentDialogType="startup";
	$('#connectStreamTitle').hide();
	$('#connectSMILTitle').hide();
	$('#addToStartupStreams').show();
	showConnectDialog('', '');
}

function addStreamToStartupStreamsShow(appName,streamFile) {
	currentDialogType="startupStream";
	$('#connectStreamTitle').hide();
	$('#connectSMILTitle').hide();
	$('#addToStartupStreams').show();
	$('#streamName').val(streamFile);
	$('#streamNameViewValue').text(streamFile);
	showConnectDialog(appName, streamFile);
}

function addSMILToStartupStreamsShow(appName,streamFile) {
	currentDialogType="startupSMIL";
	$('#connectStreamTitle').hide();
	$('#connectSMILTitle').hide();
	$('#addToStartupStreams').show();
	$('#streamName').val(streamFile);
	$('#streamNameViewValue').text(streamFile);
	showConnectDialog(appName, streamFile);
}

function showConnectDialog(appName, streamFile) {
	$('#applicationName').val(appName);
	$('#applicationNameViewValue').text(appName);
	currentAppName = appName;
	currentStreamFile=streamFile;
	if (appName == "")
	{
		$('#applicationNameViewCtrlGroup').hide();
		//$('#applicationName option:first').attr("selected", true);
		document.getElementById("applicationName").options[0].selected = true;
	}
	else
	{
		$('#applicationNameCtrlGroup').hide();
	}
	if (streamFile == "")
	{
		$('#streamNameViewCtrlGroup').hide();
	}
	else
	{
		$('#streamNameCtrlGroup').hide();
	}

	$('#instanceName').attr('disabled', 'disabled');

	var $radioAppInstance = $('input:radio[name="appInstanceOption"]');
	$radioAppInstance.filter('[value="'+currentAppInstanceOption+'"]').prop('checked', true);

	// clear warning messages
	$('#applicationNameCtrlGroup').attr('class', 'form-group');
	$('#applicationNameErrorMsg').text("");
	$('#applicationNameErrorMsg').hide();
	$('#instanceNameCtrlGroup').attr('class', 'form-group');
	$('#instanceNameErrorMsg').text("");
	$('#instanceNameErrorMsg').hide();


	$('#connectStreamFileModal').on("shown.bs.modal", function() {});
	$('#connectStreamFileModal').modal('show');
}

function connectStreamFileClose() {
	$('#connectStreamFileModal').modal('hide');
}

function doConnectStreamFile() {
	if (validData())
	{
		$('#connectStreamFileModal').on('hidden.bs.modal', function() {
			if(currentDialogType=="stream")
			{
				if("${appType}" == "")
				{
					postAJAXForm('server/vhost/streamfile/connect.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&connectAppName='+encodeURIComponent(currentAppName)+'&connectAppInstance='+encodeURIComponent(currentAppInstance)+'&streamFile='+encodeURIComponent(currentStreamFile)+'&mediaCasterType='+currentMediaCasterType);
				}
				else
				{
					postAJAXForm('applications/${appType}/streamfile/connect.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&appInstance=${appInstance}&connectAppName='+encodeURIComponent(currentAppName)+'&connectAppInstance='+encodeURIComponent(currentAppInstance)+'&streamFile='+encodeURIComponent(currentStreamFile)+'&mediaCasterType='+currentMediaCasterType);
				}
			}
			else if(currentDialogType=="smil")
			{
				if("${appType}" == "")
				{
					postAJAXForm('server/vhost/smilfile/connect.htm','vhost=${wmsutil:urlEncode(vhost)}&connectAppName='+encodeURIComponent(currentAppName)+'&connectAppInstance='+encodeURIComponent(currentAppInstance)+'&smilfile='+encodeURIComponent(currentStreamFile)+'&mediaCasterType='+currentMediaCasterType);
				}
				else
				{
					postAJAXForm('applications/${appType}/smilfile/connect.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&connectAppName='+encodeURIComponent(currentAppName)+'&connectAppInstance='+encodeURIComponent(currentAppInstance)+'&smilfile='+encodeURIComponent(currentStreamFile)+'&mediaCasterType='+currentMediaCasterType);
				}
			}
			else if(currentDialogType=="startup")
			{
				postAJAXForm('server/vhost/startupstream/new.htm','vhost=${wmsutil:urlEncode(vhost)}&applicationName=' + encodeURIComponent(currentAppName) + '&streamName='+ encodeURIComponent(currentStreamFile)+'&applicationInstance='+encodeURIComponent(currentAppInstance)+'&mediaCasterType='+currentMediaCasterType);
			}
			else if(currentDialogType=="startupStream")
			{
				if("${appType}" == "")
				{
					postAJAXForm('server/vhost/streamfile/addtostartupstreams.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamAppName='+encodeURIComponent(currentAppName)+'&appInstance='+encodeURIComponent(currentAppInstance)+'&streamFile='+encodeURIComponent(currentStreamFile)+'&mediaCasterType='+currentMediaCasterType);
				}
				else
				{
					postAJAXForm('applications/${appType}/streamfile/addtostartupstreams.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamAppName='+encodeURIComponent(currentAppName)+'&appInstance='+encodeURIComponent(currentAppInstance)+'&streamFile='+encodeURIComponent(currentStreamFile)+'&mediaCasterType='+currentMediaCasterType);
				}
			}
			else if(currentDialogType=="startupSMIL")
			{
				if("${appType}" == "")
				{
					postAJAXForm('server/vhost/smilfile/addtostartupstreams.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamAppName='+encodeURIComponent(currentAppName)+'&appInstance='+encodeURIComponent(currentAppInstance)+'&smilFile='+encodeURIComponent(currentStreamFile)+'&mediaCasterType='+currentMediaCasterType);
				}
				else
				{
					postAJAXForm('applications/${appType}/smilfile/addtostartupstreams.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamAppName='+encodeURIComponent(currentAppName)+'&appInstance='+encodeURIComponent(currentAppInstance)+'&smilFile='+encodeURIComponent(currentStreamFile)+'&mediaCasterType='+currentMediaCasterType);
				}
			}
		});
		connectStreamFileClose();
	}
}

function loadData()
{
	currentMediaCasterType = "rtp";
	currentAppInstanceOption="${appInstanceOptionDefault}";
}

function appInstanceOptionChanged()
{
	var elem=$('input[name="appInstanceOption"]:checked');
	var selected = elem.val();

	$('#instanceNameCtrlGroup').attr('class', 'form-group');
	$('#instanceNameErrorMsg').text("");
	$('#instanceNameErrorMsg').hide();

	if (selected == "${appInstanceOptionDefault}")
	{
		$('#instanceName').attr('disabled', 'disabled');
	}
	else
	{
		$('#instanceName').removeAttr('disabled');
	}
}

function validData()
{
	var ok=true;
	var elem=$('input[name="appInstanceOption"]:checked');
	var selected = elem.val();

	// clear old warning messages
	$('#applicationNameCtrlGroup').attr('class', 'form-group');
	$('#applicationNameErrorMsg').text("");
	$('#applicationNameErrorMsg').hide();
	$('#instanceNameCtrlGroup').attr('class', 'form-group');
	$('#instanceNameErrorMsg').text("");
	$('#instanceNameErrorMsg').hide();

	if ($('#applicationName').is(":visible"))
	{
		currentAppName=$('#applicationName').val();
		if (currentAppName == "" || document.getElementById("applicationName").selectedIndex==0 )
		{
			$('#applicationNameCtrlGroup').attr('class', 'form-group has-error');
			$('#applicationNameErrorMsg').html("${fieldEmpty}");
			$('#applicationNameErrorMsg').show();
			ok=false;
		}
		if (!isValidFileName(currentAppName))
		{
			$('#applicationNameCtrlGroup').attr('class', 'form-group has-error');
			$('#applicationNameErrorMsg').html("${filenameInvalid}");
			$('#applicationNameErrorMsg').show();
			ok=false;
		}
	}
	if ($('#streamName').is(":visible"))
	{
		currentStreamFile=$('#streamName').val();
		if (currentStreamFile == "")
		{
			$('#streamNameCtrlGroup').attr('class', 'form-group has-error');
			$('#streamNameErrorMsg').html("${fieldEmpty}");
			$('#streamNameErrorMsg').show();
			ok=false;
		}
		if (!isValidStreamName(currentStreamFile))
		{
			$('#streamNameCtrlGroup').attr('class', 'form-group has-error');
			$('#streamNameErrorMsg').html("${streamNameInvalid}");
			$('#streamNameErrorMsg').show();
			ok=false;
		}
	}
	if (selected == "${appInstanceOptionDefault}")
	{
		currentAppInstance="_definst_";
	}
	else
	{
		currentAppInstance=$('#instanceName').val();
		if (currentAppInstance === "")
		{
			$('#instanceNameCtrlGroup').attr('class', 'form-group has-error');
			$('#instanceNameErrorMsg').html("${fieldEmpty}");
			$('#instanceNameErrorMsg').show();
			ok=false;
		}
		if (!isValidFileName(currentAppInstance))
		{
			$('#instanceNameCtrlGroup').attr('class', 'form-group has-error');
			$('#instanceNameErrorMsg').html("${filenameInvalid}");
			$('#instanceNameErrorMsg').show();
			ok=false;
		}
	}

	currentMediaCasterType = $('#mediaCasterType').val();

	return ok;
}

</script>