<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="addListenerModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="addListenerModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="addListenerForm" class="form-modal"> 
				<fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:addListenerClose()">x</button>
					<h4 id="addListenerModalLabel" class="modal-title"><wmsform:getlocalestring page="newListener" obj="header"/></h4>
				  </div>
				  <div class="modal-body">
							<wmsform:editproperty page="newListener" obj="listenerBaseClass" cssClass='form-control' cssClassTitle="control-label" required="yes" bind="false"/>
				  </div>
				  <div class="modal-footer">
					<div class="row">
						<div class="col-md-8">
							<div id="newListenerError" class="alert alert-danger" style="display:none"></div>
						</div>
						<div class="col-md-4">
							<wmsform:buttoncancel  onClick="javascript:addListenerClose()"/>
							<wmsform:buttonadd  onClick="javascript:doaddListener()"/>
						</div>
					</div>
				  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<c:set var="ModBaseClassError">
	<wmsform:getlocalestring page="newListener" obj="listenerBaseClass.empty"/>
</c:set>
<script>
function addListenerShow() {
	$("#newListenerError").html(""); 
	$("#newListenerError").hide();
	$("#listenerBaseClass").val("");
	$("#listenerBaseClassCtrlGroup").attr('class', 'form-group');
	$("#listenerBaseClassErrorMsg").html("");
	$("#listenerBaseClassErrorMsg").hide();

	$('#addListenerModal').on("shown.bs.modal", function() {
	});
	$('#addListenerModal').modal('show');	
}

function addListenerClose() {
	$('#addListenerModal').modal('hide');
}

function doaddListener() {
	//need to check values
	var ok=true;
	$("#listenerBaseClassCtrlGroup").attr('class', 'form-group');
	$("#listenerBaseClassErrorMsg").html("");
	$("#listenerBaseClassErrorMsg").hide();

	if($("#listenerBaseClass").val() =="")
	{
		$("#listenerBaseClassCtrlGroup").attr('class', 'form-group has-error');
		$("#listenerBaseClassErrorMsg").html("${ModBaseClassError}");
		$("#listenerBaseClassErrorMsg").show();
		ok=false;
	}
	if(!ok)
	{
		return;	
	}
	var newItem = new Object();
	newItem.orgIdx = tblIdxListeners++;
	newItem.order = tblIdxListeners;
	newItem.removed=false;
	newItem.baseClass=$("#listenerBaseClass").val();
	tblDataListeners.push(newItem);
	addListenerClose();
	updateTableListeners();
}

</script>