<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="newApplicationModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="newApplicationModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form:form method="post" commandName="formData" id="defaultForm" class="form-modal">
				<fieldset>
					<div class="modal-header">
					  <button type="button" class="close" onClick="javascript:newApplicationClose()">x</button>
					  <h4 id="newApplicationModalLabel" class="modal-title"><wmsform:getlocalestring page="newApplicationModal" obj="header"/></h4>
					</div>
					<div class="modal-body">
						<p>* = required field</p>
						<wmsform:editproperty page="newApplicationModal" obj="uiAppName" required="true" tooltip="Enter Application Name"/>
						<wmsform:editproperty page="newApplicationModal" obj="primaryURL" bind="false" required="true"/>
					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="uiAppNameWarnings" class="alert alert-danger"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel  onClick="javascript:newApplicationClose()"/>
						  		<wmsform:buttonadd  onClick="javascript:doNew()"/>
							</div>
						</div>
					  <input type="submit" style="display:none"/>
					</div>
					<form:hidden path="ignoreWarnings" />
				</fieldset>
			</form:form>
		</div>
	</div>
</div>
<c:set var="emptyName">
	<wmsform:getlocalestring page="appconfig.main" obj="uiAppName.empty"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="common" obj="invalidFileNameLength"/>
</c:set>
<c:set var="blankPrimaryURL">
	<wmsform:getlocalestring page="appconfig.mediaCache" obj="primaryOriginURL.empty"/>
</c:set>

<script>
$(document).ready(function() {		
	$("#defaultForm").bind("keypress", function(e) {
         if (e.keyCode == 13) {   
        	 doNew();
             return false;
        }
     });
});

var newAppType="";
function newApplicationShow(appType) {
	newAppType = appType;
	$("#uiAppNameWarnings").text("");
	$("#uiAppNameWarnings").hide();
	$('#uiAppName').val("");
	$('#primaryURL').val("");
	$('#primaryURLCtrlGroup').hide();
	$('#primaryURLErrorMsg').hide();
	$('#uiAppNameErrorMsg').hide();
	/*
	if(newAppType=='LiveEdge')
	{
		$('#primaryURLCtrlGroup').show();
	}
	*/
	$('#newApplicationModal').on('shown.bs.modal', function() {
		$('#uiAppName').focus();
	});
	$('#newApplicationModal').modal('show');
}

function newApplicationClose() {
	$('#newApplicationModal').modal('hide');
}


function doNew() {
	var ok=true;
	var nApp=$('#uiAppName').val().trim();
	$('#uiAppName').val(nApp);
	$('#uiAppNameWarnings').hide();
	$('#primaryURLErrorMsg').hide();
	$('#uiAppNameErrorMsg').hide();
	if(nApp.length==0)
	{
		$('#uiAppNameErrorMsg').html("${emptyName}");
		$('#uiAppNameErrorMsg').show();
		ok=false;
	}
	if(!isValidFileName(nApp))
	{
		$('#uiAppNameErrorMsg').html("${invalidNameError}");
		$('#uiAppNameErrorMsg').show();
		ok=false;
	}
	if(!isValidFileNameLength(nApp))
	{
		$('#uiAppNameErrorMsg').html("${invalidNameLengthError}");
		$('#uiAppNameErrorMsg').show();
		ok=false;		
	}
	/*
	if(newAppType=='LiveEdge' && $('#primaryURL').val().trim()=="")
	{
		$('#primaryURLErrorMsg').html("${blankPrimaryURL}");
		$('#primaryURLErrorMsg').show();
		ok=false;				
	}
	*/
	if(ok)
	{
		$.ajax({
			url : "NewAppName.jsdata",
			data : "vhost="+encodeURIComponent(currentVhost) + "&appName="+encodeURIComponent(nApp),
			cache : false,
			success : function(data) {
				if(data.substring(0, redirectLoginString.length)==redirectLoginString) {
					document.location = "login.htm" + location.hash;
				}
				else {	
					var json_parsed = $.parseJSON(data);
					if(json_parsed.status=="valid")
					{
						createNew(newAppType);
					}
					else {
						$('#uiAppNameErrorMsg').html(json_parsed.message);
						$('#uiAppNameErrorMsg').show();
					}
				}
			},
			error : function (jqXHR, textStatus, thrownError) {
				console.log("Error: (" + this.url +") " + thrownError);
			}
		});
	}
}

function createNew(appType) {

	lastApplication=$('#uiAppName').val().trim();
	lastApplicationType=appType.toLowerCase();
	lastApplicationSection="main";
	lastTab='Basic';
	reloadLastApplication=false;
	
	$('#newApplicationModal').on('hidden.bs.modal', function() {
		postAJAXForm('applications/new.htm','vhost='+encodeURIComponent(currentVhost)+'&appType='+appType+'&primaryURL='+$('#primaryURL').val());
	});
	newApplicationClose();
}
</script>