<h4>About Stream Files</h4>
<p>Stream files provide a method to replace (alias) complex stream names that are published to a Wowza Streaming Engine server from sources such as MPEG-TS encoders and IP cameras. For example, if your complex stream name on the origin server is <strong>udp&#58;&#47;&#47;0.0.0.0:10000</strong>, you can create a stream file named <strong>mycoolevent.stream</strong> and set the contents to the complex stream name. Players can then use <strong>mycoolevent.stream</strong> in playback URLs in place of the more complex stream name. Stream files are stored in an application's streaming file directory and have a <strong>.stream</strong> file name extension.</p>

<p>To add a stream file, click <strong>Add Stream File</strong>. In the <strong>Add Stream File</strong> dialog box, do the following:</p>
<ol>
	<li>Enter a name for the stream file. The name value can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.</li>
	<li>Enter the source stream URI in the <strong>Stream URI</strong> box. The following list shows example URI values for various stream types:
	<ul>
		<li>MPEG-TS stream (MPEG-TS encoder): udp&#58;&#47;&#47;&#91;source-ip-address&#93;&#58;&#91;port&#93;</li>
		<li>RTSP stream (IP camera): rtsp&#58;&#47;&#47;&#91;camera-ip-address&#93;&#58;&#91;port&#93;</li>
		<li>Live Stream Repeater stream: rtmp&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;&#91;port&#93; (or rtmps&#58;&#47;&#47;&#91;wowza-ip-address&#93;&#58;&#91;port&#93;) or wowz&#58;//&#91;source-ip-address&#93;&#58;&#91;port&#93; (or wowzs&#58;//&#91;source-ip-address&#93;&#58;&#91;port&#93;)</li>
		<li>SHOUTcast/Icecast stream: http&#58;&#47;&#47;&#91;source-ip-address&#93;&#58;&#91;port&#93;</li>
		<li>Apple HLS: http&#58;&#47;&#47;&#91;source-ip-address&#93;&#58;&#91;port&#93; (or https&#58;&#47;&#47;&#91;source-ip-address&#93;&#58;&#91;port&#93;)</li>
		<li>SRT: srt&#58;&#47;&#47;&#91;source-ip-address&#93;&#58;&#91;port&#93;</li>
	</ul></li>
</ol>

<p>You can also add a stream file by copying an existing stream file and adjusting its settings. To copy an existing stream file for further modification, click <strong>Copy Stream File</strong>. In the <strong>Copy Stream File</strong> dialog box, select the stream file to copy and specify a unique name for the copied file.</p>

<p>To edit stream file properties, click the <strong>Edit</strong> icon for the stream file.</p>

<p>To delete a stream file, click the <strong>Delete</strong> icon for the stream file.<p>

<h5>Adding Stream Files to Startup Streams</h5>
<p>Live streams referenced in a stream file can be started automatically when Wowza Streaming Engine starts so that they're immediately available for streaming to all player technologies supported by the server. To add the stream file to the list of streams that are started automatically, click the <strong>Add to Startup Streams</strong> icon for the stream file. For instructions about how to configure startup streams, go to the <a href="javascript:lastServerMC='vhostStartupStreams';loadAjaxSideBar('SB_Server.html','')">Startup Streams page</a>.</p>

<h5>Re-streaming Stream File Streams</h5>
<p>Wowza Streaming Engine includes a system for re-streaming live streams called <em>MediaCaster</em>. The MediaCaster system is used for re-streaming IP camera streams (RTSP/RTP streams), SHOUTcast/Icecast streams, streams from native RTP or MPEG-TS encoders, and RTMP streams from other Wowza media servers. The MediaCaster system can pull the streams that are referenced in a stream file and make them available for streaming to all player technologies supported by the server.</p>

<p>The MediaCaster system works on-demand. When the first request is received from a player for the stream file, the source stream referenced in the file is made available to the player. When the last player stops viewing the stream, the MediaCaster system waits for a timeout period. If no other players request the file, the stream is stopped and isn't available for streaming until another request is made.</p>

<p>To enable re-streaming of stream file streams, click the <strong>Connect</strong> icon for the stream file, and configure the following options in the <strong>Connect a Stream File</strong> dialog box:<p>
<ul>
	<li><strong>Application Name</strong>. Select the name of a live application that's configured in the Wowza Streaming Engine server.

	<li><strong>Application Instance</strong>. Select the default application instance (<strong>_definst_</strong>) or specify an alternate application instance to use for re-streaming. The application instance is created if it doesn't exist.

	<li><strong>MediaCaster Type</strong>. Select the MediaCaster type in the list that corresponds to the stream type:	<br /><br />
	<p>Select <strong>rtp</strong> for IP camera streams (RTSP/RTP streams) and for streams from native RTP and MPEG-TS encoders.</p>
	<p>Select <strong>shoutcast</strong> for SHOUTcast/Icecast streams.</p>
	<p>Select <strong>liverepeater</strong> if the stream is an RTMP stream pulled from another Wowza media server.</p>
	<p>Select <strong>applehls</strong> for Apple HLS streams pulled from a live source.</p>
	<p>Select <strong>mpegtstcp</strong> for MPEG-TS streams pulled from a live source over TCP.</p>
	<p>Select <strong>srt</strong> to accept Secure Reliable Transport (SRT) connections.</p>
</ul>

<blockquote><strong>Note:</strong> The <strong>rtp-record</strong> and <strong>shoutcast-record</strong> MediaCaster types are used for re-streaming but also record the stream to a single file in the application's streaming file directory. If the source starts and stops, the file is versioned with a version number and a new file is started. You can control the container format used (MP4 or FLV) by specifying a stream name prefix in the source. If you specify the <strong>mp4:</strong> prefix, the stream is recorded to an MP4 (QuickTime) container. An MP4 container can only record H.264, AAC, and MP3 media data. If you specify the <strong>flv:</strong> prefix, the stream is recorded to an FLV container. The FLV container is the only option if you're recording with Flash Player. To apply advanced recording capabilities to these streams, you can use the <strong>Incoming Streams</strong> feature in Wowza Streaming Engine instead.</blockquote>