<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<wmsform:setpagetitle page="smilFiles.smilFile"/>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<c:choose>
			<c:when test="${empty appType}">
				<div class="col-md-12">
					<happ><wmsform:getlocalestring page="smilFiles" obj="head"/> > ${wmsutil:escapeHtml(smilName)}.smil</happ><br>
					<small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
				</div>
			</c:when>
			<c:otherwise>
				<div class="col-md-5">
					<happ> ${wmsutil:escapeHtml(appName)} > ${wmsutil:escapeHtml(smilName)}.smil</happ><br>
					<small class="text-muted">${uiAppType}</small>
				</div>
				<wmsform:applicationbuttons page="${page}" streamName="${wmsutil:escapeHtml(smilName)}" appendSMIL="true"/>
			</c:otherwise>
		</c:choose>
	</div>
	<p><a href="javascript:returnSMILFiles()"><i class="fa fa-arrow-left"></i> Return to SMIL Files</a></p>
	<hr>
	<div class="row">
		<div class="col-md-12">
			<div id="ViewMode" class="row">
				<div id="TabBasic">
					<jsp:include page="ViewBasic.jsp" flush="true" />
				</div>
			</div>
			<div id="EditMode" class="row">
				<div id="TabEditBasic" >
					<div class="col-md-8 main-content">
						<form:form method="post" commandName="formData" id="defaultForm" onsubmit="return false;">
							<wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
							<wmsform:rightrailhideshow/>
							<jsp:include page="EditBasic.jsp" flush="true" />
							<form:hidden path="ignoreWarnings" />
						</form:form>
					</div>
					<div id="HelpStores" class="col-md-4 right-rail well-help pull-right">
						<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
function returnSMILFiles()
{
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/smilfiles/view.htm", "vhost=${wmsutil:urlEncode(vhost)}");
	}
	else
	{
		loadAjaxMainContent("applications/${appType}/smilfiles/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}");
	}
}

$(document).ready(function() {
	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();
		$('#EditMode').show();
		$('#AppButtons').hide();
	}
	else
	{
		$('#ViewMode').show();
		$('#EditMode').hide();
		$('#AppButtons').show();
	}
});
</script>

