<h4>About Wowza Transcoder</h4>
<p>Wowza Transcoder provides the ability to ingest a live stream, decode the video and audio, and then re-encode the stream to suit desired playback devices. Transcoder is a real-time video transcoding and transrating solution. It can decode and re-encode audio and video in multiple formats with aligned keyframes for adaptive bitrate delivery over any protocol supported by Wowza Streaming Engine. For more information, see our documentation on how to <a href="https://www.wowza.com/docs/wowza-transcoder" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Use Wowza Transcoder</a>.</p>

<blockquote><strong>Notes:</strong><br />You must enable Wowza Transcoder for each live application that uses it. Go to the <strong>Transcoder</strong> page for your live application to enable it.<br /><br />If you purchased a license for Wowza media server software before January&nbsp;1,&nbsp;2015, contact <a href="mailto:sales@wowza.com">sales@wowza.com</a> to learn more about how to license Wowza Transcoder.</blockquote>

<h5>Transcoder Usage</h5>
<p>A <em>channel</em> is a single incoming stream ingested by Wowza Transcoder. For billing purposes, the maximum number of concurrent streams ingested by the Transcoder at any given time during the billing period is counted. The total number of streams ingested during the billing period isn't counted.</p>

<h5>Transcoder Templates</h5>
<p>Transcoder templates enable you to customize the video and audio encoding parameters to target multiple playback devices. You can apply different encoding settings to an application or stream using one or more templates. The following default templates are included:</p>
<ul>
	<li><strong>Audio Only</strong>. Used to ingest an H.264 video/Speex audio source stream from Adobe Flash Player. The Speex audio format is converted to AAC, Vorbis, or Opus to make the stream compatible with additional player technologies.

	<li><strong>Transcode</strong>. Used to ingest a source stream that isn't encoded with H.264 video and/or AAC or MP3 audio. The transcoded output has multiple bitrates, each encoded with H.264 video and AAC or MP3 audio, that are keyframe-aligned for adaptive streaming.

	<li><strong>Transcode H.265</strong>. Used to transcode source streams into H.265 video and AAC audio. The transcoded output has multiple bitrates that are keyframe-aligned for adaptive streaming. Note that the H.265/HEVC codec isn't widely supported by playback protocols and players.

	<li><strong>Transrate</strong>. Used to ingest a source stream that's encoded with H.264 video and AAC or MP3 audio. The transrated output has multiple bitrates that are keyframe-aligned for adaptive streaming. The highest output bitrate is the original source stream.
</ul>

<p>To create a new template based on another template's settings, click <strong>Copy Template</strong>, select a template to copy in the <strong>Copy Transcoder Template</strong> dialog box, and give it a new name. To create a new template that has no defined settings, click <strong>Add Template</strong> and specify the name of the new template in the <strong>Add Transcoder Template</strong> dialog box. The template name value must be unique and can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), tilde (&#126;), and comma (&#44;) characters.</p>

<p>To manage the encoding parameters in a template, click the template name in the list.</p>

<p>To delete a template, click the <strong>Delete</strong> icon for the template. The default templates can't be deleted.</p>
