<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About Media Cache Tuning</h4>
<p>Wowza Streaming Engine is automatically tuned to get the best performance from the Media Cache system and any configured Media Cache stores when the server starts. The server allocates threads for the caching system based on the number of CPU cores and allocates memory for the content blocks that are cached based on available memory. You can adjust the following settings from the default values that are calculated by the server:
<ul>
	<li><strong>Writer Thread Pool</strong>. The number of threads in the writer thread pool that are used to persist items to the cache store.

	<li><strong>Readahead Thread Pool</strong>. The number of threads in the readahead thread pool that are used to read blocks of data from the cache source before they're requested. The readahead system maintains a steady flow of bytes from the source to the cache to avoid stuttering during playback.

	<li><strong>Maximum Pending Write Request Size</strong>. The amount of memory (in megabytes) that can be occupied by content blocks waiting to be written to the caching system. Think of it as a temporary memory-based cache.

	<li><strong>Maximum Pending Readahead Request Size</strong>. The amount of memory (in megabytes) that can be occupied by content blocks waiting to be written to the cache store.
</ul>

<p>For details, see <a href="https://www.wowza.com/docs/how-to-do-performance-tuning#tune_Media_Cache" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Tune Media Cache</a>.</p>

<h5>Media Cache Tuning Settings</h5>
<p>To use the default setting that's calculated by the server when it starts, select <strong>Set automatically</strong>. Otherwise, select the alternate option button and enter a specific value in the box. Valid thread values are from <strong>1</strong> to <strong>1024</strong> threads. Valid request size values are from <strong>1</strong> to <strong>65536</strong> megabytes.</p>