<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>

<c:set var="destApplicationLabel"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="destApplication"/></c:set>
<c:set var="destAppInstanceLabel"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="destAppInstance"/></c:set>
<c:set var="usernameLabel"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="username"/></c:set>
<c:set var="passwordLabel"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="password"/></c:set>

<script>
function showConfigs (type, mode)
{
	if (type == "basic" || type == "advanced")
	{
		var destName = $("#destinationName").val();
		var protocol = $("#protocol").val();

		//console.log("Destname is "+destName);
		//console.log("Protocol is "+protocol);

		// selectively show the configs appropriate for the selected destination/protocol
		$("["+type+"Common"+mode+"]").show();

		switch(destName)
		{
			case "alibaba":
				$("["+type+"SourceStreamName"+mode+"]").show();
				$("["+type+"RTMPAlibabaAppName"+mode+"]").show();
				$("["+type+"RTMPAlibaba"+mode+"]").show();
				$("["+type+"RTMPGeneric"+mode+"]").show();
				break;

			case "limelight":
			case "mirrorimage":
			case "rtmp":
			case "tata":
			case "wowzastreamingengine":
			case "youtube":
				$("["+type+"SourceStreamName"+mode+"]").show();
				$("["+type+"RTMPAppName"+mode+"]").show();
				$("["+type+"RTMPCommon"+mode+"]").show();
				$("["+type+"RTMPGeneric"+mode+"]").show();
				// Hide SSL for now
				//$("["+type+"SSL"+mode+"]").show();
				break;

			case "akamai":
				$("["+type+"SourceStreamName"+mode+"]").show();
				// only show the protocol radio buttons if we are editing
				$("["+type+"AkamaiProtocol"+mode+"]").show();
				// Hide SSL for now
				//$("["+type+"SSL"+mode+"]").show();
				break;

			case "facebook":
				$("["+type+"SourceStreamName"+mode+"]").show();
				$("["+type+"Facebook"+mode+"]").show();
				if (type == "basic")
				{
					if (mode == "Edit")
					{
						$("#facebookLoginTextEditTab").show();
						$("#facebookCurrentConfig").show();
						$("#facebookCurrentConfigHelp").show();
					}

					if ($("#facebookDestType").val() == "timeline")
					{
						$("#facebookPrivacyOption").show();
						$("#facebookPrivacyConfigHelp").show();
					}
				}
				// Hide SSL for now
				//$("["+type+"SSL"+mode+"]").show();
				break;

			case "icecast2":
				$("["+type+"SourceStreamName"+mode+"]").show();
				$("["+type+"ShoutcastGeneric"+mode+"]").show();
				$("["+type+"ShoutcastUser"+mode+"]").show();
				$("["+type+"ShoutcastPassword"+mode+"]").show();
				$("["+type+"ShoutcastDestination"+mode+"]").show();
				$("["+type+"ShoutcastDescription"+mode+"]").show();
				$("["+type+"ShoutcastServer"+mode+"]").show();
				break;

			case "mpegts":
				$("["+type+"SourceStreamName"+mode+"]").show();
				$("["+type+"MPEGTS"+mode+"]").show();
				break;

			case "rtp":
				$("["+type+"SourceStreamName"+mode+"]").show();
				$("["+type+"RTP"+mode+"]").show();
				break;

			case "shoutcast":
				$("["+type+"SourceStreamName"+mode+"]").show();
				// common to both shoutcast 1 and 2 protocols
				$("["+type+"ShoutcastProtocol"+mode+"]").show();
				$("["+type+"ShoutcastGeneric"+mode+"]").show();
				$("["+type+"ShoutcastPassword"+mode+"]").show();
				$("["+type+"ShoutcastServer"+mode+"]").show();

				if (protocol == "shoutcast2")
				{
					$('input[name=protocolShoutcast][value="shoutcast1"]').prop("checked",false);
					$('input[name=protocolShoutcast][value="shoutcast2"]').prop("checked",true);

					$("["+type+"ShoutcastUser"+mode+"]").show();
					$("["+type+"ShoutcastDestination"+mode+"]").show();
				}
				else
				{
					$('input[name=protocolShoutcast][value="shoutcast1"]').prop("checked",true);
					$('input[name=protocolShoutcast][value="shoutcast2"]').prop("checked",false);
				}
				break;
				
			case "srt":
				$("["+type+"SourceStreamName"+mode+"]").show();
				$("["+type+"SRT"+mode+"]").show();
				//If there is a passphrase, show it, and check the secureSRT option when loading.
				if($("#srtPassPhrase").val() && mode=='Edit')
				{
					$("["+type+"SRTSecure"+mode+"]").show();
					$("#secureSRT").prop("checked", true);
				}
				//If there is a passphrase when viewing a stream target, show it and the key length.
				else if($("#srtPassPhraseValue").text().trim() && mode=='View')
				{
					$("["+type+"SRTSecure"+mode+"]").show();
				}
				break;

			case "wowzastreamingcloud":
				//connection code of 1xxx is destType="streamTarget" and 0xxx is "transcoder"
				//if connection code is "", default case is executed
				var destType = $("#wowzaCloudDestinationType").val();
				$("["+type+"WowzaStreamingCloud"+mode+destType+"]").show();
				$("["+type+"WowzaStreamingCloud"+mode+"]").show();
				$("["+type+"WowzaCloudAdaptiveStreaming"+mode+"]").show();
				
				switch (destType)
				{
				case "streamTarget":
					$("["+type+"SourceStreamName"+mode+"]").show();
					$("["+type+"WowzaCloudABRQuestion"+mode+"]").show();
					$("["+type+"WowzaCloudDestinationServer"+mode+"]").show();

					$("["+type+"WowzaStreamingCloud"+mode+"transcoder]").hide();

					var adaptiveStreaming = $("#wowzaCloudAdaptiveStreaming").val() == "true";
					$('input[name=wowzaCloudABRRadio][value=multiple]').prop("checked",adaptiveStreaming);
					$('input[name=wowzaCloudABRRadio][value=single]').prop("checked",!adaptiveStreaming);
					if (adaptiveStreaming == true)
					{
						$("["+type+"SourceStreamNamePrefix"+mode+"]").show();
						$("["+type+"SourceStreamName"+mode+"]").hide();
					}
					else
					{
						$("["+type+"SourceStreamName"+mode+"]").show();
						$("["+type+"SourceStreamNamePrefix"+mode+"]").hide();
					}
					break;

				case "transcoder":
					$("["+type+"WowzaStreamingCloud"+mode+"streamtarget]").hide();
					$("["+type+"WowzaCloudABRQuestion"+mode+"]").hide();
					$("["+type+"WowzaCloudDestinationServer"+mode+"]").hide();
					$("["+type+"SourceStreamNamePrefix"+mode+"]").hide();
					$("["+type+"SourceStreamName"+mode+"]").show();
					break;

				default:
					$("["+type+"WowzaStreamingCloud"+mode+"transcoder]").hide();
					$("["+type+"WowzaStreamingCloud"+mode+"streamtarget]").hide();
					break;
				}
				break;

			case "wowzacdn":
				var adaptiveStreaming = $("#wowzaCloudAdaptiveStreaming").val() == "true";

				$("["+type+"WowzaCDN"+mode+"]").show();
				$("["+type+"WowzaCloudABRQuestion"+mode+"]").show();
				$("["+type+"WowzaCloudDestinationServer"+mode+"]").show();
				$("["+type+"WowzaCdnViewAccountInfo"+mode+"]").show();
				$("["+type+"WowzaCloudAdaptiveStreaming"+mode+"]").show();

				$('input[name=wowzaCloudABRRadio][value=multiple]').prop("checked",adaptiveStreaming);
				$('input[name=wowzaCloudABRRadio][value=single]').prop("checked",!adaptiveStreaming);
				
				if (adaptiveStreaming == true)
				{
					$("["+type+"SourceStreamNamePrefix"+mode+"]").show();
					$("["+type+"SourceStreamName"+mode+"]").hide();
				}
				else
				{
					$("["+type+"SourceStreamName"+mode+"]").show();
					$("["+type+"SourceStreamNamePrefix"+mode+"]").hide();
				}
				
				if (!inWizard)
				{
					$("["+type+"WowzaCdnViewAccountInfo"+mode+"]").show();
				}
				else
				{
					$("["+type+"WowzaCdnViewAccountInfo"+mode+"]").hide();
				}
				break;

			default:
				break;
		}
		updateCommonFields(protocol, destName, type, mode);
	}
}


function updateCommonFields(selectedProtocol, selectedDestinationName, type, mode)
{
	// a bit hacky here.  some properties are conditionally "required" based on destination/protocol
	username = $("[for='username']");
	password = $("[for='password']");

	// akamai is the Ugly one, so we'll pull it out specifically because it supports 3 protocols, the
	// reset well leave it like it was before (removing the akamai bits)
	if (selectedDestinationName=="akamai")
	{
		// akamai supports 4 protocols, RTMP, HLS, HDS, and MPEG-DASH so as the user picks between the protocols, we have
		// to enable/disable various fields

		if (selectedProtocol == "" || selectedProtocol == null)
		{
			// default protocol to RTMP
			selectedProtocol = "RTMP";
		}

		if (selectedProtocol=="RTMP")
		{
			username.html("${usernameLabel}" + " *");
			$("#usernameRequired").val("true");
			password.html("${passwordLabel}" + " *");
			$("#passwordRequired").val("true");

			$("["+type+"RTMPAkamai"+mode+"]").show();
			$("["+type+"RTMPCommon"+mode+"]").show();

			// This is a special exception for the HTTP stuff
			// if the user goes from one protocol to one of the http
			// protocols, we end up turning it on then off (say HLS->HDS)
			// so, makes it easier to do it here since we want it on for
			// either HTTP protocol but off for RTMP
			$("["+type+"AkamaiHttpCommon"+mode+"]").hide();
			$("["+type+"AkamaiHttpDestinationServer"+mode+"]").hide();

			$('input[name=protocolAkamai][value=RTMP]').prop("checked",true);
		}
		else
		{
			$("["+type+"RTMPAkamai"+mode+"]").hide();
			$("["+type+"RTMPCommon"+mode+"]").hide();
		}

		if (selectedProtocol == "HLS")
		{
			$("["+type+"AkamaiHttpCommon"+mode+"]").show();
			$("["+type+"AkamaiHttpDestinationServer"+mode+"]").show();
			$("["+type+"AkamaiHttpHLS"+mode+"]").show();

			$('input[name=protocolAkamai][value=HLS]').prop("checked",true);
		}
		else
		{
			$("["+type+"AkamaiHttpHLS"+mode+"]").hide();
		}

		if (selectedProtocol == "HDS")
		{
			$("["+type+"AkamaiHttpCommon"+mode+"]").show();
			$("["+type+"AkamaiHttpDestinationServer"+mode+"]").show();
			$("["+type+"AkamaiHttpHDS"+mode+"]").show();

			$('input[name=protocolAkamai][value=HDS]').prop("checked",true);
		}
		else
		{
			$("["+type+"AkamaiHttpHDS"+mode+"]").hide();
		}

		if (selectedProtocol == "DASH")
		{
			$("["+type+"AkamaiHttpCommon"+mode+"]").show();
			$("["+type+"AkamaiHttpDestinationServer"+mode+"]").show();
			$("["+type+"AkamaiHttpDASH"+mode+"]").show();

			$('input[name=protocolAkamai][value=DASH]').prop("checked",true);
		}
		else
		{
			$("["+type+"AkamaiHttpDASH"+mode+"]").hide();
		}
	}
	else //everything but Akamai
	{
		if (selectedProtocol=="RTMP")
		{
			$("[for='destApplication']").html("${destApplicationLabel}" + " *");
			$("#destApplicationRequired").val("true");
		}

		if (selectedProtocol=="RTMP" && (selectedDestinationName=="mirrorimage" || selectedDestinationName=="tata"))
		{
			$("[for='destAppInstance']").html("${destAppInstanceLabel}" + " *");
			$("#destAppInstanceRequired").val("true");
		}

		if (selectedProtocol=="RTMP" && selectedDestinationName=="limelight")
		{
			username.html("${usernameLabel}" + " *");
			$("#usernameRequired").val("true");
			password.html("${passwordLabel}" + " *");
			$("#passwordRequired").val("true");
		}
	}
}

function updateSecureSRTHelper(show)
{
	var $srtPassPhrase = $("#srtPassPhrase");
    var $srtKeyLength = $("#srtKeyLength");
	var $srtPassPhraseHelp = $("#passphraseSRTHelp")
    var $srtKeyLengthHelp = $("#srtKeyLengthHelp");
	if(show === true)
	{
		$srtPassPhrase.prop("disabled", false);
		$srtKeyLength.prop("disabled", false);
		$srtPassPhraseHelp.show();
		$srtKeyLengthHelp.show();
	}
	else
	{
		$srtPassPhrase.prop("disabled", true);
		$srtKeyLength.prop("disabled", true);
		$srtPassPhraseHelp.hide();
		$srtKeyLengthHelp.hide();
	}
}

function returnToStreamTargets()
{
	loadAjaxMainContent("applications/${appType}/streamtargets/view.htm","vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}");
}

</script>