<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<div id="select-destination-help">
	<h4>Selecting Destinations</h4>
	<p>Stream target destinations re-distribute your incoming live source streams to users, allowing you to scale and add redundancy to your live streaming workflow. You can send your source streams to destinations such as Wowza Streaming Cloud&#8482;, content delivery networks (CDNs), and even to other Wowza Streaming Engine&#8482; instances.</p>

	<p>Click the icon for the stream target destination to which you want to send your source stream.</p>

	<blockquote><strong>Notes:</strong><br />You may need to create an account with the provider for your selected stream target destination and configure the destination to ingest your source stream. Click the <strong>Learn more</strong> link underneath each icon to get detailed configuration instructions.
	<br /><br />You can send the same source stream to different stream target destinations. After you finish configuring a stream target, return to the <strong>Stream Targets</strong> page to add another stream target.</blockquote>
</div>

<div id="configure-target-help">
	<re:mark>We have to include HelpBasic_xx.jsp directly as text using "%@ include" since the file(s) are included in multiple places, and including a jsp file multiple times using the normal "jsp:include" syntax causes issues.
	         Add includes for help files for other languages as required.</re:mark>
	<c:choose>
		<c:when test="${formData.currentLocale=='en'}">
			<%@ include file="HelpBasic_en.jsp" %>
		</c:when>
		<c:otherwise>
			<%@ include file="HelpBasic_en.jsp" %>
		</c:otherwise>
	</c:choose>
</div>



