<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<c:set var="streamNameInvalid">
	<wmsform:getlocalestring page="common" obj="invalidStreamName"/>
</c:set>
<c:set var="fieldEmpty">
	<wmsform:getlocalestring page="common" obj="emptyField"/>
</c:set>
<c:set var="invalidPortRangeError">
	<wmsform:getlocalestring page="common" obj="port.error"/>
</c:set>
<c:set var="invalidNumber">
	<wmsform:getlocalestring page="common" obj="invalidNumber"/>
</c:set>
<c:set var="noCupertinoRenditions">
	<wmsform:getlocalestring page="appconfig.streamTarget.entry" obj="noCupertinoRendition"/>
</c:set>
<c:set var="destApplicationRequired">
	${requestScope.formData['destApplicationRequired']} 
</c:set>
<c:set var="destAppInstanceRequired">
	${requestScope.formData['destAppInstanceRequired']}
</c:set>
<c:set var="usernameRequired">
	${requestScope.formData['usernameRequired']}
</c:set>
<c:set var="passwordRequired">
	${requestScope.formData['passwordRequired']}
</c:set>
<c:set var="wowzaCloudDestType">
	${requestScope.formData['wowzaCloudDestinationType']}
</c:set>
<c:set var="facebookUserName">${requestScope.formData['facebookUserName']}</c:set>
<c:set var="fbChangeUserText"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookChangeUser"/></c:set>
<c:set var="fbMyTimelineText"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookDestType.timeline"/></c:set>
<c:set var="fbLoginTextWizard"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookLoginTextWizard"/></c:set>
<c:set var="fbLoginTextEditTab"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookLoginTextEditTab"/></c:set>
<c:set var="fbDestType">${requestScope.formData['facebookDestType']}</c:set>
<c:set var="fbDestName">${requestScope.formData['facebookDestName']}</c:set>
<c:set var="fbContinuousLive">${requestScope.formData['facebookContinuousLive']}</c:set>
<c:set var="fbPrivacy"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget.facebookPrivacy" obj="${requestScope.formData['facebookPrivacy']}"/></c:set>

<c:set var="srtIncorrectKeyLength"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="srtIncorrectKeyLength"/></c:set>
<c:set var="srtInvalidRecoveryBuffer"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="srtInvalidRecoveryBuffer"/></c:set>
<c:set var="srtInvalidRecoveryBufferSize"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="srtInvalidRecoveryBufferSize"/></c:set>

<c:set var="wowzaCdnCloudVerified"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudVerified"/></c:set>

<re:mark>NOTE!! Any fields defined below below that are *Required* for ANY of the profiles/destinations must have validation code added in validateBasicConfigOptions()</re:mark>

<re:mark> --------- Akamai profiles part 1 --------- </re:mark>

<div basicAkamaiProtocolEdit style="display:none">
	<label class="control-label"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destination.options" obj="destProtocol"/></label>
	<div class="radio">
		<input type="radio" name="protocolAkamai" id="protocolAkamaiRTMP" value="RTMP" onclick="updateAkamaiSettings()" checked/>
		<wmsform:getlocalestring page="appconfig" obj="adobeRTMP"/>
	</div>
	<div class="radio">
		<input type="radio" name="protocolAkamai" id="protocolAkamaiHLS" value="HLS" onclick="updateAkamaiSettings()"/>
		<wmsform:getlocalestring page="appconfig" obj="appleHLS"/>
	</div>
	<div class="radio">
		<input type="radio" name="protocolAkamai" id="protocolAkamaiHDS" value="HDS" onclick="updateAkamaiSettings()"/>
		<wmsform:getlocalestring page="appconfig" obj="adobeHDS"/>
	</div>
	<div class="radio">
		<input type="radio" name="protocolAkamai" id="protocolAkamaiDASH" value="DASH" onclick="updateAkamaiSettings()"/>
		<wmsform:getlocalestring page="appconfig" obj="mpegDash"/>
	</div>
</div>

<re:mark> --------- Shoutcast profiles part 1 --------- </re:mark>

<div basicShoutcastProtocolEdit style="display:none">
	<label class="control-label"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.destination.options" obj="destShoutcast"/></label>
	<div class="radio">
		<input type="radio" name="protocolShoutcast" id="protocolShoutcast1" value="shoutcast1" onclick="updateShoutCastSettings()"/>
		<wmsform:getlocalestring page="appconfig" obj="protocolShoutcast1"/>
	</div>
	<div class="radio">
		<input type="radio" name="protocolShoutcast" id="protocolShoutcast2" value="shoutcast2" onclick="updateShoutCastSettings()" checked/>
		<wmsform:getlocalestring page="appconfig" obj="protocolShoutcast2"/>
	</div>
</div>

<re:mark> --------- Wizard only --------- </re:mark>

<re:mark> "streamTargetName" is only displayed on the wizard Configure Target page.</re:mark>
<div basicWizardOnlyConfigEdit style="display:none;margin-top:+15px">
	<div id="streamTargetNameEdit">
		<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="streamTargetName" cssClass="form-control" cssSize="col-md-12" required="true"/>
	</div>
</div>

<re:mark> --------- Wowza Streaming Cloud --------- </re:mark>

<div basicWowzaStreamingCloudEdit style="display:none;">
	<div style="display:inline-block;">
		<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="connectionCode" cssClass="form-control" cssSize="col-md-12" required="true"/>
	</div>
	<div style="display:inline-block;vertical-align:top; margin-top:25px;">
		<a id="checkConnectionBtn" class="btn btn-default" name="checkConnection" onClick="checkConnectionCode()">
	   		<i class="fa fa-refresh"></i> <fmt:message key="appconfig.streamTargets.wizard.configureTarget.wowzaCloudCheckCode"/>
		</a>
	</div>
</div>

<re:mark> --------- Wowza Cloud ABR question --------- </re:mark>

<div basicWowzaCloudABRQuestionEdit style="display:none;margin-top:+5px;margin-bottom:+15px">
	<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnAbr"/>
	<div class="radio">
		<label><input type="radio" id="wowzaCloudABRRadioMulti" name="wowzaCloudABRRadio" value="multiple" onclick="handleWowzaCloudABR()" checked> <wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnMultiple" /></label>
	</div>
	<div class="radio">
		<label><input type="radio" id="wowzaCloudABRRadioSingle" name="wowzaCloudABRRadio" value="single" onclick="handleWowzaCloudABR()" > <wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnSingle" /></label>
	</div>
</div>

<re:mark> --------- Source Stream --------- </re:mark>

<div basicSourceStreamNameEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="sourceStreamName" cssClass="form-control" cssSize="col-md-12" required="true"/>
</div>

<re:mark> --------- Source Stream Prefix ----------- </re:mark>

<div basicSourceStreamNamePrefixEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="sourceStreamNamePrefix" cssClass="form-control" cssSize="col-md-12" required="true"/>
</div>

<re:mark> --------- Shoutcast profiles part 2 --------- </re:mark>

<div basicShoutcastGenericEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastHost" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastPort" cssClass="form-control" cssSize="col-md-12" inputFilter='integer'/>
</div>

<div basicShoutcastUserEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastUsername" cssClass="form-control" cssSize="col-md-12" required="true"/>
</div>

<div basicShoutcastPasswordEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastPassword" cssClass="form-control" cssSize="col-md-12" required="true"/>
</div>

<div basicShoutcastDestinationEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastDestination" cssClass="form-control" cssSize="col-md-12" required="true"/>
</div>

<div basicShoutcastDescriptionEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastDescription" cssClass="form-control" cssSize="col-md-12" required="true"/>
</div>

<div basicShoutcastServerEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastName" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastGenre" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastMetaFormat" cssClass="form-control" cssSize="col-md-12" required="false"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastURL" cssClass="form-control" cssSize="col-md-12" required="false"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastAIM" cssClass="form-control" cssSize="col-md-12" required="false"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastICQ" cssClass="form-control" cssSize="col-md-12" required="false"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastIRC" cssClass="form-control" cssSize="col-md-12" required="false"/>
	<wmsform:editpropertycheckbox page="appconfig.streamTargets.wizard.configureTarget" obj="shoutcastPublic" />
</div>

<re:mark> --------- RTMP profiles --------- </re:mark>

<re:mark>RTMP Generic - Includes all RTMP destinations/profiles except rtmp-akamai</re:mark>
<re:mark>        Note - This DOES include 'rtmp-limelight' and the other destinations that use the 'rtmp' profile (Tata, Limelight, MirrorImage, YouTube, Alibaba)</re:mark>

<div basicRTMPAppNameEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destApplication" cssClass="form-control" cssSize="col-md-12"/>
</div>

<div basicRTMPAlibabaAppNameEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="alibabaDestApplication" cssClass="form-control" cssSize="col-md-12" required="true"/>
</div>

<div basicRTMPGenericEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destAppInstance" cssClass="form-control" cssSize="col-md-12"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destHostRTMP" cssClass="form-control" cssSize="col-md-12" required="true"/>
</div>

<re:mark> --------- RTMP Common - Includes all RTMP destinations, including Akamai --------- </re:mark>

<div basicRTMPCommonEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destPortRTMP" cssClass="form-control" cssSize="col-md-12" inputFilter='integer' required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destStreamNameRTMP" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="username" cssClass="form-control" cssSize="col-md-12"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="password" cssClass="form-control" cssSize="col-md-12"/>
</div>

<div basicRTMPAlibabaEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="alibabaDestPortRTMP" cssClass="form-control" cssSize="col-md-12" inputFilter='integer' required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="alibabaDestStreamNameRTMP" cssClass="form-control" cssSize="col-md-12" required="true"/>
</div>

<re:mark> --------- RTMP Akamai - Includes only the RTMP Akamai destination-profile --------- </re:mark>

<div basicRTMPAkamaiEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="akamaiStreamIdRTMP" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<label class="control-label"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="SendTargetToBackupServer"/></label>
	<wmsform:editpropertycheckbox page="appconfig.streamTargets.wizard.configureTarget" obj="akamaiSendToBackupServer" />
</div>

<re:mark>RTP - Includes only the RTP destination/profile</re:mark>

<div basicRTPEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destStreamNameRTP" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destHostRTP" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="videoPort" cssClass="form-control" cssSize="col-md-12" required="true" inputFilter='integer'/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="audioPort" cssClass="form-control" cssSize="col-md-12" required="true" inputFilter='integer'/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="streamWaitTimeout" cssClass="form-control" cssSize="col-md-12" inputFilter='integer'/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="timeToLiveRTP" cssClass="form-control" cssSize="col-md-12" inputFilter='integer'/>
</div>

<re:mark> --------- SRT - Includes only the SRT destination/profile --------- </re:mark>

<div basicSRTEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="srtDestHost" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="srtDestPort" cssClass="form-control" cssSize="col-md-12" required="true" inputFilter='integer'/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="srtRecoveryBuffer" cssClass="form-control" cssSize="col-md-12" required="false" inputFilter='integer'/>
	<label class="control-label"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="srtSecureLabel"/></label>
	<div class="checkbox">
		<label>
			<input type="checkbox" class="checkbox-inline" id="secureSRT" onChange="updateSecureSRTHelper()"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="srtSecure"/></>
		</label>
	</div>
</div>

<div basicSRTSecureEdit style="display:none">
	<wmsform:editpropertydropdown page="appconfig.streamTargets.wizard.configureTarget" obj="srtKeyLength" cssClass="form-control" cssSize="col-md-12" required="true" options="AES-128,AES-256"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="srtPassPhrase" cssClass="form-control" cssSize="col-md-12" required="yes"/>
</div>

<re:mark> --------- MPEGTS - Includes only the MPEG-TS destination/profile --------- </re:mark>

<div basicMPEGTSEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destStreamNameMPEGTS" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destHostMPEGTS" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destPortMPEGTS" cssClass="form-control" cssSize="col-md-12" required="true" inputFilter='integer'/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="timeToLiveMPEGTS" cssClass="form-control" cssSize="col-md-12"  inputFilter='integer'/>
	<label class="control-label"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wrapMpegtsInRtp"/></label>
	<wmsform:editpropertycheckbox page="appconfig.streamTargets.wizard.configureTarget" obj="rtpWrap" />
</div>

<re:mark> --------- Akamai HTTP - Includes all of the Akamai HTTP destinations/profiles --------- </re:mark>

<div basicAkamaiHttpCommonEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destStreamNameHTTP" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="destHostHTTPAkamai" cssClass="form-control" cssSize="col-md-12"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="playbackHost" cssClass="form-control" cssSize="col-md-12"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="akamaiStreamIdHTTP" cssClass="form-control" cssSize="col-md-12" required="true"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="akamaiHostId" cssClass="form-control" cssSize="col-md-12"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="httpPlaylistCount" cssClass="form-control" cssSize="col-md-12" inputFilter='integer'/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="akamaiEventName" cssClass="form-control" cssSize="col-md-12"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="adaptiveGroup" cssClass="form-control" cssSize="col-md-12"/>
</div>
<div basicAkamaiHttpDestinationServerEdit style="display:none">
	<wmsform:editpropertydropdown page="appconfig.streamTargets.wizard.configureTarget" obj="akamaiDestinationServer" cssClassTitle="control-label" required="yes" options="primary,backup,redundant" cssSize="col-md-2"/>
</div>

<re:mark> --------- Akamai HTTP HLS - Includes the Akamai HTTP HLS destination-profile --------- </re:mark>

<div id="akamaiHttpHLSConfigs" basicAkamaiHttpHLSEdit style="display:none">
	<label class="control-label"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="AppleHLSStreamRenditions"/></label>
	<fieldset id="checkCupertinoRenditionsArray">
		<wmsform:editpropertycheckbox page="appconfig.streamTargets.wizard.configureTarget" obj="cupertinoRenditionAudioVideo"/>
		<wmsform:editpropertycheckbox page="appconfig.streamTargets.wizard.configureTarget" obj="cupertinoRenditionAudioOnly"/>
	</fieldset>
	<span class="help-block-has-error" id="cupertinoRenditionsErrorMsg" style="display:none">${noCupertinoRenditions}</span>
</div>

<re:mark> --------- Akamai HTTP HDS - Includes the Akamai HTTP HDS destinations-profile --------- </re:mark>

<div basicAkamaiHttpHDSEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="sanjoseRepresentationId" cssClass="form-control" cssSize="col-md-12"/>
</div>

<re:mark> --------- Akamai HTTP MPEG DASH - Includes the Akamai HTTP MPEG DASH destinations-profile --------- </re:mark>

<div basicAkamaiHttpDASHEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="mpegdashVideoRepresentationId" cssClass="form-control" cssSize="col-md-12"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="mpegdashAudioRepresentationId" cssClass="form-control" cssSize="col-md-12"/>
</div>



<re:mark> --------- Wowza Streaming Cloud - Includes the Wowza Streaming Cloud destinations-profile --------- </re:mark>

<div basicWowzaStreamingCloudEdittranscoder style="display:none">
	<wmsform:editpropertycheckbox page="appconfig.streamTargets.wizard.configureTarget" obj="autoStart"/>
</div>


<re:mark> --------- Wowza Cloud Destination Server --------- </re:mark>

<div basicWowzaCloudDestinationServerEdit style="display:none">
	<wmsform:editpropertydropdown page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCloudDestinationServer" cssClassTitle="control-label" required="yes" options="primary,backup,redundant" cssSize="col-md-2"/>
</div>


<re:mark> --------- Cloud CDN ----------- </re:mark>

<div basicWowzaCdnLoginMessageSuccessEdit style="display:none;margin-top:+35px">
		<label id="wowzaCdnCloudVerifiedEdit"  class="control-label"></label>
</div>

<div basicWowzaCdnCloudEulaVerifiedEdit style="display:none;margin-top:+35px">
	<div id="wowzaCdnCloudEulaVerifiedEdit">
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudEulaVerified"/>
	</div>
</div>

<div basicWowzaCdnLoginMessageFailureEdit style="display:none;margin-top:+35px">
	<div id="wowzaCdnCloudFailureEdit">
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudFailure"/>
	</div>
</div>

<div basicWowzaCdnLoginMessageFailureCredentialsEdit style="display:none;margin-top:+35px">
	<div id="wowzaCdnCloudFailureCredentialsEdit">
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudFailureCredentials"/>
	</div>
</div>

<div basicWowzaCdnLoginMessageFailureEulaEdit style="display:none;margin-top:+35px">
	<div id="wowzaCdnCloudFailureEulaEdit">
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudFailureEula"/>
	</div>
</div>

<div basicWowzaCdnLoginMessageFailureEulaApiEdit style="display:none;margin-top:+35px">
	<div id="wowzaCdnCloudFailureEulaApiEdit">
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudFailureEulaApi"/>
	</div>
</div>

<div basicWowzaCdnLoginMessageFailureInternalEdit style="display:none;margin-top:+35px">
	<div id="wowzaCdnCloudFailureInternalEdit">
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudFailureInternal"/>
	</div>
</div>

<div basicWowzaCdnCloudFailureNoAccountsEdit style="display:none;margin-top:+35px">
	<div id="wowzaCdnCloudFailureNoAccountsEdit">
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudFailureNoAccounts"/>
	</div>
</div>

<div basicWowzaCdnCloudFailureNoValidAccountsEdit style="display:none;margin-top:+35px">
	<div id="wowzaCdnCloudFailureNoValidAccountsEdit">
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudFailureNoValidAccounts"/>
	</div>
</div>

<div basicWowzaCdnCloudSignInTextEdit style="display:none;margin-top:+35px">
	<div id="wowzaCdnCloudSignInTextEdit" >
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudSignInText"/>
	</div>
</div>

<div basicWowzaCdnLoginEdit style="display:none;margin-top:+25px;margin-bottom:+25px">
	<div id="wowzaCdnCloudEmailEdit">
		<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudEmail" cssClass="form-control" cssSize="col-md-12" required="true"/>
	</div>
	<div id="wowzaCdnCloudPasswordEdit">
		<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudPassword" cssClass="form-control" cssSize="col-md-12" required="true" inputType="password"/>
	</div>
	<div id="wowzaCdnCloudSignInEdit">
		<wmsform:buttonprimary page="common" obj="signIn" onClick="javascript:cdnCloudSignIn()" icon="fa fa-sign-in" btnType="btn btn-orange" />
	</div>
</div>

<div basicWowzaCdnAccountSelectionEdit style="display:none;margin-top:+25px">
	<wmsform:editpropertydropdown page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnAccountSelection" cssClassTitle="control-label" required="yes" getLocalString="true" bind="false" cssSize="col-md-5"/>
</div>

<div basicWowzaCdnViewAccountInfoEdit class="well" style="display:none">
	<div class="form-group">
		<label class="control-label">
			<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudAccountName"/>
		</label>
		<div class="controls">
			<div id="wowzaCdnCloudAccountNameEdit" class="value">
				${requestScope.formData['wowzaCdnCloudAccountName']}
			</div>
		</div>

		<label class="control-label">
			<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="wowzaCdnCloudPlaybackUrl"/>
		</label>
		<div class="controls">
			<div id="wowzaCdnCloudPlaybackUrlEdit" class="value">
				${requestScope.formData['wowzaCdnCloudPlaybackUrl']}
			</div>
		</div>
	</div>
</div>


<re:mark> --------- Facebook profile --------- </re:mark>

<div basicFacebookEdit style="display:none">
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="facebookTitle" cssClass="form-control" cssSize="col-md-12"/>
	<wmsform:editproperty page="appconfig.streamTargets.wizard.configureTarget" obj="facebookDescription" cssClass="form-control" cssSize="col-md-12"/>
	<label class="control-label" style="margin-bottom:2px"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookContinuousLiveLabel"/></label>
	<wmsform:editpropertycheckbox page="appconfig.streamTargets.wizard.configureTarget" obj="facebookContinuousLive"/>
	<wmsform:editpropertydropdown page="appconfig.streamTargets.wizard.configureTarget" obj="facebook360Projection" cssClassTitle="control-label" getLocalString="true" options="none,equirectangular,cubemap,singlefisheye" cssSize="col-md-2"/>
	<div id="facebookCurrentConfig" class="well" style="display:none">
		<%--<c:out value="DT: ${fbDestType} DN:${fbDestName} :${fbPrivacy}"/>--%>
		<wmsform:facebookconfig destType="${fbDestType}" destName="${fbDestName}" privacy="${fbPrivacy}"/>
	</div>
	<div id="facebookLogin">
		<label id="facebookLoginTextWizard" class="control-label" style="display:none">${fbLoginTextWizard}</label>
		<label id="facebookLoginTextEditTab" class="control-label" style="display:none">${fbLoginTextEditTab}</label>
		<wmsform:buttonimage onClick="javascript:doFBLogin()" btnClass="fb-login-button img-responsive" name="FbLogin"/>
	</div>
	<div id="facebookChangeUser" style="display:none">
		<label id="facebookChangeUserLabel"  class="control-label"></label>
		<wmsform:buttonimage onClick="javascript:doFBChangeUser()" btnClass="fb-change-user-button img-responsive" name="FbChangeUser"/>
	</div>
	<div id="facebookCancel" style="display:none">
		<label class="control-label"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookPleaseWait"/></label>
		<wmsform:buttonimage onClick="javascript:doFBCancel()" btnClass="fb-cancel-button img-responsive" name="FbCancel"/>
	</div>
	<br>
	<div id="facebookDestOptions" style="display:none">
		<wmsform:editpropertydropdown page="appconfig.streamTargets.wizard.configureTarget" obj="facebookDestType" cssClassTitle="control-label" required="yes" getLocalString="true" options="timeline,page,group" cssSize="col-md-5"/>
		<div id="facebookPagesDropdown" style="display:none">
			<wmsform:editpropertydropdown page="appconfig.streamTargets.wizard.configureTarget" obj="facebookPages" bind="false" cssClassTitle="control-label" required="yes" cssSize="col-md-5"/>
			<div id="noPagesWarn" class="alert alert-warning" style="display:none;margin-top:-15px">
				<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookNoPages"></wmsform:getlocalestring>
			</div>
		</div>
		<div id="facebookGroupsDropdown" style="display:none">
			<wmsform:editpropertydropdown page="appconfig.streamTargets.wizard.configureTarget" obj="facebookGroups" bind="false" cssClassTitle="control-label" required="yes" cssSize="col-md-5"/>
			<div id="noGroupsWarn" class="alert alert-warning" style="display:none;margin-top:-15px">
				<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookNoGroups"></wmsform:getlocalestring>
			</div>
		</div>
		<div id="facebookPrivacyOption" style="display:none">
			<wmsform:editpropertydropdown page="appconfig.streamTargets.wizard.configureTarget" obj="facebookPrivacy" cssClassTitle="control-label" required="yes" getLocalString="true" options="onlyMe,friends,friendsOfFriends,public" cssSize="col-md-3"/>
		</div>
	</div>

</div>

<script>

var userData = null;
var defaultVideoDest = "timeline";

function validateCdnLogin()
{
	var ok = true;
	if ($('#wowzaCdnCloudEmail').is(":visible"))
	{
		var value = $('#wowzaCdnCloudEmail').val().trim();
		if (!value || (value.length == 0))
		{
			$('#wowzaCdnCloudEmailCtrlGroup').attr('class', 'form-group has-error');
			$('#wowzaCdnCloudEmailErrorMsg').html("${fieldEmpty}");
			$('#wowzaCdnCloudEmailErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#wowzaCdnCloudEmailCtrlGroup').attr('class', 'form-group');
			$('#wowzaCdnCloudEmailErrorMsg').hide();
		}
	}

	if ($('#wowzaCdnCloudPassword').is(":visible"))
	{
		var value = $('#wowzaCdnCloudPassword').val().trim();
		if (!value || (value.length == 0))
		{
			$('#wowzaCdnCloudPasswordCtrlGroup').attr('class', 'form-group has-error');
			$('#wowzaCdnCloudPasswordErrorMsg').html("${fieldEmpty}");
			$('#wowzaCdnCloudPasswordErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#wowzaCdnCloudPasswordCtrlGroup').attr('class', 'form-group');
			$('#wowzaCdnCloudPasswordErrorMsg').hide();
		}
	}
	if (ok == false)
	{
		$('#pageErrorMessage').show();
	}
	else
	{
		$('#pageErrorMessage').hide();
	}
	return ok;
}

function validateBasicConfigOptions()
{
	var ok = true;
	var value= $('#streamTargetName').val().trim();

	if (!value || (value.length == 0))
	{
		$('#streamTargetNameCtrlGroup').attr('class', 'form-group has-error');
		$('#streamTargetNameErrorMsg').html("${fieldEmpty}");
		$('#streamTargetNameErrorMsg').show();
		ok=false;
	} else if(!isValidStreamName(value))
	{
		$('#streamTargetNameCtrlGroup').attr('class', 'form-group has-error');
		$('#streamTargetNameErrorMsg').html("${streamNameInvalid}");
		$('#streamTargetNameErrorMsg').show();
		ok=false;
	}
	else
	{
		$('#streamTargetNameCtrlGroup').attr('class', 'form-group');
		$('#streamTargetNameErrorMsg').hide();
	}

	if ($('#sourceStreamName').is(":visible"))
	{
		value = $('#sourceStreamName').val().trim();
		if (!value || (value.length == 0))
		{
			$('#sourceStreamNameCtrlGroup').attr('class', 'form-group has-error');
			$('#sourceStreamNameErrorMsg').html("${fieldEmpty}");
			$('#sourceStreamNameErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#sourceStreamNameCtrlGroup').attr('class', 'form-group');
			$('#sourceStreamNameErrorMsg').hide();
		}
	}

	if ($('#sourceStreamNamePrefix').is(":visible"))
	{
		value = $('#sourceStreamNamePrefix').val().trim();
		if (!value || (value.length == 0))
		{
			$('#sourceStreamNamePrefixCtrlGroup').attr('class', 'form-group has-error');
			$('#sourceStreamNamePrefixErrorMsg').html("${fieldEmpty}");
			$('#sourceStreamNamePrefixErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#sourceStreamNamePrefixCtrlGroup').attr('class', 'form-group');
			$('#sourceStreamNamePrefixErrorMsg').hide();
		}
	}

	if ($('#shoutcastHost').is(":visible"))
	{
		value = $('#shoutcastHost').val().trim();
		if (!value || (value.length == 0))
		{
			$('#shoutcastHostCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastHostErrorMsg').html("${fieldEmpty}");
			$('#shoutcastHostErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#shoutcastHostCtrlGroup').attr('class', 'form-group');
			$('#shoutcastHostErrorMsg').hide();
		}
	}

	if ($('#shoutcastPort').is(":visible"))
	{
		value = $('#shoutcastPort').val().trim();
		if (!value || (value.length == 0))
		{
			$('#shoutcastPortCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastPortErrorMsg').html("${fieldEmpty}");
			$('#shoutcastPortErrorMsg').show();
			ok&=false;
		}
		else if (isNaN(value))
		{
			$('#shoutcastPortCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastPortErrorMsg').html("${invalidNumber}");
			$('#shoutcastPortErrorMsg').show();
			ok&=false;
		}
		else if ( !isFinite(value) )
		{
			$('#shoutcastPortCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastPortErrorMsg').html("${invalidPortRangeError}");
			$('#shoutcastPortErrorMsg').show();
			ok&=false;
		}
		else if ((parseInt(value,10) < 1) || (parseInt(value,10) > 65535))
		{
			$('#shoutcastPortCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastPortErrorMsg').html("${invalidPortRangeError}");
			$('#shoutcastPortErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#shoutcastPortCtrlGroup').attr('class', 'form-group');
			$('#shoutcastPortErrorMsg').hide();
		}
	}

	if ($('#shoutcastUsername').is(":visible"))
	{
		value = $('#shoutcastUsername').val().trim();
		if (!value || (value.length == 0))
		{
			$('#shoutcastUsernameCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastUsernameErrorMsg').html("${fieldEmpty}");
			$('#shoutcastUsernameErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#shoutcastUsernameCtrlGroup').attr('class', 'form-group');
			$('#shoutcastUsernameErrorMsg').hide();
		}
	}

	if ($('#shoutcastPassword').is(":visible"))
	{
		value = $('#shoutcastPassword').val().trim();
		if (!value || (value.length == 0))
		{
			$('#shoutcastPasswordCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastPasswordErrorMsg').html("${fieldEmpty}");
			$('#shoutcastPasswordErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#shoutcastPasswordCtrlGroup').attr('class', 'form-group');
			$('#shoutcastPasswordErrorMsg').hide();
		}
	}

	if ($('#shoutcastDestination').is(":visible"))
	{
		value = $('#shoutcastDestination').val().trim();
		if (!value || (value.length == 0))
		{
			$('#shoutcastDestinationCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastDestinationErrorMsg').html("${fieldEmpty}");
			$('#shoutcastDestinationErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#shoutcastDestinationCtrlGroup').attr('class', 'form-group');
			$('#shoutcastDestinationErrorMsg').hide();
		}
	}

	if ($('#shoutcastDescription').is(":visible"))
	{
		value = $('#shoutcastDescription').val().trim();
		if (!value || (value.length == 0))
		{
			$('#shoutcastDescriptionCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastDescriptionErrorMsg').html("${fieldEmpty}");
			$('#shoutcastDescriptionErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#shoutcastDescriptionCtrlGroup').attr('class', 'form-group');
			$('#shoutcastDescriptionErrorMsg').hide();
		}
	}

	if ($('#shoutcastName').is(":visible"))
	{
		value = $('#shoutcastName').val().trim();
		if (!value || (value.length == 0))
		{
			$('#shoutcastNameCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastNameErrorMsg').html("${fieldEmpty}");
			$('#shoutcastNameErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#shoutcastNameCtrlGroup').attr('class', 'form-group');
			$('#shoutcastNameErrorMsg').hide();
		}
	}

	if ($('#shoutcastGenre').is(":visible"))
	{
		value = $('#shoutcastGenre').val().trim();
		if (!value || (value.length == 0))
		{
			$('#shoutcastGenreCtrlGroup').attr('class', 'form-group has-error');
			$('#shoutcastGenreErrorMsg').html("${fieldEmpty}");
			$('#shoutcastGenreErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#shoutcastGenreCtrlGroup').attr('class', 'form-group');
			$('#shoutcastGenreErrorMsg').hide();
		}
	}

/*
shoutcastMetaFormat
shoutcastURL
shoutcastAIM
shoutcastICQ
shoutcastIRC
*/

	if ($('#destHostRTMP').is(":visible"))
	{
		value = $('#destHostRTMP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#destHostRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#destHostRTMPErrorMsg').html("${fieldEmpty}");
			$('#destHostRTMPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destHostRTMPCtrlGroup').attr('class', 'form-group');
			$('#destHostRTMPErrorMsg').hide();
		}
	}

	if ($('#destStreamNameRTMP').is(":visible"))
	{
		value = $('#destStreamNameRTMP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#destStreamNameRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#destStreamNameRTMPErrorMsg').html("${fieldEmpty}");
			$('#destStreamNameRTMPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destStreamNameRTMPCtrlGroup').attr('class', 'form-group');
			$('#destStreamNameRTMPErrorMsg').hide();
		}
	}

	if ($('#destApplication').is(":visible"))
	{
		value = $('#destApplication').val().trim();
		if ($("#destApplicationRequired").val()=="true" && (!value || (value.length == 0)))
		{
			$('#destApplicationCtrlGroup').attr('class', 'form-group has-error');
			$('#destApplicationErrorMsg').html("${fieldEmpty}");
			$('#destApplicationErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destApplicationCtrlGroup').attr('class', 'form-group');
			$('#destApplicationErrorMsg').hide();
		}
	}

	if ($('#alibabaDestApplication').is(":visible"))
	{
		value = $('#alibabaDestApplication').val().trim();
		if (!value || (value.length == 0))
		{
			$('#alibabaDestApplicationCtrlGroup').attr('class', 'form-group has-error');
			$('#alibabaDestApplicationErrorMsg').html("${fieldEmpty}");
			$('#alibabaDestApplicationErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#alibabaDestApplicationCtrlGroup').attr('class', 'form-group');
			$('#alibabaDestApplicationErrorMsg').hide();
		}
	}

	<%-- The port isn't really required but we use it by default in the engine code --%>
	if ($('#alibabaDestPortRTMP').is(":visible"))
	{
		value = $('#alibabaDestPortRTMP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#alibabaDestPortRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#alibabaDestPortRTMPErrorMsg').html("${fieldEmpty}");
			$('#alibabaDestPortRTMPErrorMsg').show();
			ok&=false;
		}
		else if (isNaN(value))
		{
			$('#alibabaDestPortRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#alibabaDestPortRTMPErrorMsg').html("${invalidNumber}");
			$('#alibabaDestPortRTMPErrorMsg').show();
			ok&=false;
		}
		else if ( !isFinite(value) )
		{
			$('#alibabaDestPortRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#alibabaDestPortRTMPErrorMsg').html("${invalidPortRangeError}");
			$('#alibabaDestPortRTMPErrorMsg').show();
			ok&=false;
		}
		else if ((parseInt(value,10) < 1) || (parseInt(value,10) > 65535))
		{
			$('#alibabaDestPortRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#alibabaDestPortRTMPErrorMsg').html("${invalidPortRangeError}");
			$('#alibabaDestPortRTMPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#alibabaDestPortRTMPCtrlGroup').attr('class', 'form-group');
			$('#alibabaDestPortRTMPErrorMsg').hide();
		}
	}

	if ($('#alibabaDestStreamNameRTMP').is(":visible"))
	{
		value = $('#alibabaDestStreamNameRTMP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#alibabaDestStreamNameRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#alibabaDestStreamNameRTMPErrorMsg').html("${fieldEmpty}");
			$('#alibabaDestStreamNameRTMPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#alibabaDestStreamNameRTMPCtrlGroup').attr('class', 'form-group');
			$('#alibabaDestStreamNameRTMPErrorMsg').hide();
		}
	}

	if ($('#destAppInstance').is(":visible"))
	{
		value = $('#destAppInstance').val().trim();
		if ($("#destAppInstanceRequired").val()=="true" && (!value || (value.length == 0)))
		{
			$('#destAppInstanceCtrlGroup').attr('class', 'form-group has-error');
			$('#destAppInstanceErrorMsg').html("${fieldEmpty}");
			$('#destAppInstanceErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destAppInstanceCtrlGroup').attr('class', 'form-group');
			$('#destAppInstanceErrorMsg').hide();
		}
	}

	<%-- The port isn't really required but we use it by default in the engine code --%>
	if ($('#destPortRTMP').is(":visible"))
	{
		value = $('#destPortRTMP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#destPortRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#destPortRTMPErrorMsg').html("${fieldEmpty}");
			$('#destPortRTMPErrorMsg').show();
			ok&=false;
		}
		else if (isNaN(value))
		{
			$('#destPortRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#destPortRTMPErrorMsg').html("${invalidNumber}");
			$('#destPortRTMPErrorMsg').show();
			ok&=false;
		}
		else if ( !isFinite(value) )
		{
			$('#destPortRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#destPortRTMPErrorMsg').html("${invalidPortRangeError}");
			$('#destPortRTMPErrorMsg').show();
			ok&=false;
		}
		else if ((parseInt(value,10) < 1) || (parseInt(value,10) > 65535))
		{
			$('#destPortRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#destPortRTMPErrorMsg').html("${invalidPortRangeError}");
			$('#destPortRTMPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destPortRTMPCtrlGroup').attr('class', 'form-group');
			$('#destPortRTMPErrorMsg').hide();
		}
	}

	if ($('#username').is(":visible"))
	{
		value = $('#username').val().trim();
		if ($("#usernameRequired").val()=="true" && (!value || (value.length == 0)))
		{
			$('#usernameCtrlGroup').attr('class', 'form-group has-error');
			$('#usernameErrorMsg').html("${fieldEmpty}");
			$('#usernameErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#usernameCtrlGroup').attr('class', 'form-group');
			$('#usernameErrorMsg').hide();
		}
	}

	if ($('#password').is(":visible"))
	{
		value = $('#password').val().trim();
		if ($("#passwordRequired").val()=="true" && (!value || (value.length == 0)))
		{
			$('#passwordCtrlGroup').attr('class', 'form-group has-error');
			$('#passwordErrorMsg').html("${fieldEmpty}");
			$('#passwordErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#passwordCtrlGroup').attr('class', 'form-group');
			$('#passwordErrorMsg').hide();
		}
	}

	if ($('#akamaiStreamIdRTMP').is(":visible"))
	{
		value = $('#akamaiStreamIdRTMP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#akamaiStreamIdRTMPCtrlGroup').attr('class', 'form-group has-error');
			$('#akamaiStreamIdRTMPErrorMsg').html("${fieldEmpty}");
			$('#akamaiStreamIdRTMPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#akamaiStreamIdRTMPCtrlGroup').attr('class', 'form-group');
			$('#akamaiStreamIdRTMPErrorMsg').hide();
		}
	}

	if ($('#destStreamNameRTP').is(":visible"))
	{
		value = $('#destStreamNameRTP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#destStreamNameRTPCtrlGroup').attr('class', 'form-group has-error');
			$('#destStreamNameRTPErrorMsg').html("${fieldEmpty}");
			$('#destStreamNameRTPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destStreamNameRTPCtrlGroup').attr('class', 'form-group');
			$('#destStreamNameRTPErrorMsg').hide();
		}
	}

	if ($('#destHostRTP').is(":visible"))
	{
		value = $('#destHostRTP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#destHostRTPCtrlGroup').attr('class', 'form-group has-error');
			$('#destHostRTPErrorMsg').html("${fieldEmpty}");
			$('#destHostRTPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destHostRTPCtrlGroup').attr('class', 'form-group');
			$('#destHostRTPErrorMsg').hide();
		}
	}

	if ($('#videoPort').is(":visible"))
	{
		value = $('#videoPort').val().trim();
		if (!value || (value.length == 0))
		{
			$('#videoPortCtrlGroup').attr('class', 'form-group has-error');
			$('#videoPortErrorMsg').html("${fieldEmpty}");
			$('#videoPortErrorMsg').show();
			ok&=false;
		}
		else if (isNaN(value))
		{
			$('#videoPortCtrlGroup').attr('class', 'form-group has-error');
			$('#videoPortErrorMsg').html("${invalidNumber}");
			$('#videoPortErrorMsg').show();
			ok&=false;
		}
		else if ( !isFinite(value) )
		{
			$('#videoPortCtrlGroup').attr('class', 'form-group has-error');
			$('#videoPortErrorMsg').html("${invalidPortRangeError}");
			$('#videoPortErrorMsg').show();
			ok&=false;
		}
		else if ((parseInt(value,10) < 1) || (parseInt(value,10) > 65535))
		{
			$('#videoPortCtrlGroup').attr('class', 'form-group has-error');
			$('#videoPortErrorMsg').html("${invalidPortRangeError}");
			$('#videoPortErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#videoPortCtrlGroup').attr('class', 'form-group');
			$('#videoPortErrorMsg').hide();
		}
	}

	if ($('#audioPort').is(":visible"))
	{
		value = $('#audioPort').val().trim();
		if (!value || (value.length == 0))
		{
			$('#audioPortCtrlGroup').attr('class', 'form-group has-error');
			$('#audioPortErrorMsg').html("${fieldEmpty}");
			$('#audioPortErrorMsg').show();
			ok&=false;
		}
		else if (isNaN(value))
		{
			$('#audioPortCtrlGroup').attr('class', 'form-group has-error');
			$('#audioPortErrorMsg').html("${invalidNumber}");
			$('#audioPortErrorMsg').show();
			ok&=false;
		}
		else if ( !isFinite(value) )
		{
			$('#audioPortCtrlGroup').attr('class', 'form-group has-error');
			$('#audioPortErrorMsg').html("${invalidPortRangeError}");
			$('#audioPortErrorMsg').show();
			ok&=false;
		}
		else if ((parseInt(value,10) < 1) || (parseInt(value,10) > 65535))
		{
			$('#audioPortCtrlGroup').attr('class', 'form-group has-error');
			$('#audioPortErrorMsg').html("${invalidPortRangeError}");
			$('#audioPortErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#audioPortCtrlGroup').attr('class', 'form-group');
			$('#audioPortErrorMsg').hide();
		}
	}

	if ($('#destStreamNameMPEGTS').is(":visible"))
	{
		value = $('#destStreamNameMPEGTS').val().trim();
		if (!value || (value.length == 0))
		{
			$('#destStreamNameMPEGTSCtrlGroup').attr('class', 'form-group has-error');
			$('#destStreamNameMPEGTSErrorMsg').html("${fieldEmpty}");
			$('#destStreamNameMPEGTSErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destStreamNameMPEGTSCtrlGroup').attr('class', 'form-group');
			$('#destStreamNameMPEGTSErrorMsg').hide();
		}
	}

	if ($('#destHostMPEGTS').is(":visible"))
	{
		value = $('#destHostMPEGTS').val().trim();
		if (!value || (value.length == 0))
		{
			$('#destHostMPEGTSCtrlGroup').attr('class', 'form-group has-error');
			$('#destHostMPEGTSErrorMsg').html("${fieldEmpty}");
			$('#destHostMPEGTSErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destHostMPEGTSCtrlGroup').attr('class', 'form-group');
			$('#destHostMPEGTSErrorMsg').hide();
		}
	}

	if ($('#destPortMPEGTS').is(":visible"))
	{
		value = $('#destPortMPEGTS').val().trim();
		if (!value || (value.length == 0))
		{
			$('#destPortMPEGTSCtrlGroup').attr('class', 'form-group has-error');
			$('#destPortMPEGTSErrorMsg').html("${fieldEmpty}");
			$('#destPortMPEGTSErrorMsg').show();
			ok&=false;
		}
		else if (isNaN(value))
		{
			$('#destPortMPEGTSCtrlGroup').attr('class', 'form-group has-error');
			$('#destPortMPEGTSErrorMsg').html("${invalidNumber}");
			$('#destPortMPEGTSErrorMsg').show();
			ok&=false;
		}
		else if ( !isFinite(value) )
		{
			$('#destPortMPEGTSCtrlGroup').attr('class', 'form-group has-error');
			$('#destPortMPEGTSErrorMsg').html("${invalidPortRangeError}");
			$('#destPortMPEGTSErrorMsg').show();
			ok&=false;
		}
		else if ((parseInt(value,10) < 1) || (parseInt(value,10) > 65535))
		{
			$('#destPortMPEGTSCtrlGroup').attr('class', 'form-group has-error');
			$('#destPortMPEGTSErrorMsg').html("${invalidPortRangeError}");
			$('#destPortMPEGTSErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destPortMPEGTSCtrlGroup').attr('class', 'form-group');
			$('#destPortMPEGTSErrorMsg').hide();
		}
	}

	if ($('#srtDestHost').is(":visible"))
	{
		value = $('#srtDestHost').val().trim();
		if (!value || (value.length == 0))
		{
			$('#srtDestHostCtrlGroup').attr('class', 'form-group has-error');
			$('#srtDestHostErrorMsg').html("${fieldEmpty}");
			$('#srtDestHostErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#srtDestHostCtrlGroup').attr('class', 'form-group');
			$('#srtDestHostErrorMsg').hide();
		}
	}

	if ($('#srtDestPort').is(":visible"))
	{
		value = $('#srtDestPort').val().trim();
		if (!value || (value.length == 0))
		{
			$('#srtDestPortCtrlGroup').attr('class', 'form-group has-error');
			$('#srtDestPortErrorMsg').html("${fieldEmpty}");
			$('#srtDestPortErrorMsg').show();
			ok&=false;
		}
		else if (isNaN(value))
		{
			$('#srtDestPortCtrlGroup').attr('class', 'form-group has-error');
			$('#srtDestPortErrorMsg').html("${invalidNumber}");
			$('#srtDestPortErrorMsg').show();
			ok&=false;
		}
		else if ( !isFinite(value) )
		{
			$('#srtDestPortCtrlGroup').attr('class', 'form-group has-error');
			$('#srtDestPortErrorMsg').html("${invalidPortRangeError}");
			$('#srtDestPortErrorMsg').show();
			ok&=false;
		}
		else if ((parseInt(value,10) < 1) || (parseInt(value,10) > 65535))
		{
			$('#srtDestPortCtrlGroup').attr('class', 'form-group has-error');
			$('#srtDestPortErrorMsg').html("${invalidPortRangeError}");
			$('#srtDestPortErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#srtDestPortCtrlGroup').attr('class', 'form-group');
			$('#srtDestPortErrorMsg').hide();
		}
	}

    if ($('#secureSRT').is(":visible"))
    {
		if ($('#secureSRT').is(":checked"))
		{
        	keyLength = $('#srtKeyLength').val().trim();

        	value = $('#srtPassPhrase').val();
            if (!value || (value.length == 0))
            {
                $('#srtPassPhraseCtrlGroup').attr('class', 'form-group has-error');
                $('#srtPassPhraseErrorMsg').html("${fieldEmpty}");
                $('#srtPassPhraseErrorMsg').show();
                ok&=false;
            }
            else if ((value.length != 16 && keyLength === "AES-128") || (value.length != 32 && keyLength == "AES-256"))
            {
                $('#srtPassPhraseCtrlGroup').attr('class', 'form-group has-error');
                $('#srtPassPhraseErrorMsg').html("${srtIncorrectKeyLength}");
                $('#srtPassPhraseErrorMsg').show();
    			ok&=false;
			}
            else
            {
                $('#srtPassPhraseCtrlGroup').attr('class', 'form-group');
                $('#srtPassPhraseErrorMsg').hide();
            }
		}
    }

    if ($('#srtRecoveryBuffer').is(':visible'))
    {
    	value = $('#srtRecoveryBuffer').val();
        if (value && isNaN(value))
        {
        	  $('#srtRecoveryBufferCtrlGroup').attr('class', 'form-group has-error');
              $('#srtRecoveryBufferErrorMsg').html("${srtInvalidRecoveryBuffer}");
              $('#srtRecoveryBufferErrorMsg').show();
	  		  ok&=false;
        }
        else if(value && (value<1 || value>2000))
        {
      		$('#srtRecoveryBufferCtrlGroup').attr('class', 'form-group has-error');
      		$('#srtRecoveryBufferErrorMsg').html("${srtInvalidRecoveryBufferSize}");
        	$('#srtRecoveryBufferErrorMsg').show();
  			ok&=false;
        }
        else
        {
       		$('#srtRecoveryBufferCtrlGroup').attr('class', 'form-group');
       	 	$('#srtRecoveryBufferErrorMsg').hide();
        }
    }

	if ($('#destStreamNameHTTP').is(":visible"))
	{
		value = $('#destStreamNameHTTP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#destStreamNameHTTPCtrlGroup').attr('class', 'form-group has-error');
			$('#destStreamNameHTTPErrorMsg').html("${fieldEmpty}");
			$('#destStreamNameHTTPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#destStreamNameHTTPCtrlGroup').attr('class', 'form-group');
			$('#destStreamNameHTTPErrorMsg').hide();
		}
	}

	if ($('#akamaiStreamIdHTTP').is(":visible"))
	{
		value = $('#akamaiStreamIdHTTP').val().trim();
		if (!value || (value.length == 0))
		{
			$('#akamaiStreamIdHTTPCtrlGroup').attr('class', 'form-group has-error');
			$('#akamaiStreamIdHTTPErrorMsg').html("${fieldEmpty}");
			$('#akamaiStreamIdHTTPErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#akamaiStreamIdHTTPCtrlGroup').attr('class', 'form-group');
			$('#akamaiStreamIdHTTPErrorMsg').hide();
		}
	}

	if ($('#akamaiHttpHLSConfigs').is(":visible"))
	{
		var atLeastOneIsChecked = $('#checkCupertinoRenditionsArray :checkbox:checked').length;
		if (atLeastOneIsChecked == 0)
		{
			$('#cupertinoRenditionsCtrlGroup').attr('class', 'form-group has-error');
			$('#cupertinoRenditionsErrorMsg').show();
			ok&=false;
		}
		else
		{
			$('#cupertinoRenditionsCtrlGroup').attr('class', 'form-group');
			$('#cupertinoRenditionsErrorMsg').hide();
		}
	}

	ok &= connectionCodeVerify();

	if (ok == false)
	{
		$('#pageErrorMessage').show();
	}
	else
	{
		$('#pageErrorMessage').hide();
	}
	return ok;
}

function checkConnectionCode()
{
	var ok = true;
	ok &= connectionCodeVerify();

	if (ok == false)
	{
		$('#pageErrorMessage').show();
	}
	else
	{
		$('#pageErrorMessage').hide();
		showConfigs("basic","Edit");
	}
}

function connectionCodeVerify ()
{
	var ok = true;
	if ($('#connectionCode').is(":visible"))
	{
		var value = $('#connectionCode').val().trim();

		if (value == "already used")
		{
			var stType = $("#wowzaCloudDestinationType").val();
			if (stType != "transcoder" && stType != "streamTarget")
			{
				$("#wowzaCloudDestinationType").val("transcoder");
			}
		}
		else
		{
			var stType = value.charAt(0);
			var stInt = parseInt(stType,10);
			if (!value || (value.length == 0))
			{
				$('#connectionCodeCtrlGroup').attr('class', 'form-group has-error');
				$('#connectionCodeErrorMsg').html("${fieldEmpty}");
				$('#connectionCodeErrorMsg').show();
				ok&=false;
			}
			else if (isNaN(stType))
			{
				$('#connectionCodeCtrlGroup').attr('class', 'form-group has-error');
				$('#connectionCodeErrorMsg').html("${invalidConnectionCode}");
				$('#connectionCodeErrorMsg').show();
				ok&=false;
			}
			else if ((stInt < 0) || (stInt > 1))
			{
				$('#connectionCodeErrorMsg').html("${invalidConnectionCode}");
				$('#connectionCodeErrorMsg').show();
				ok&=false;
			}
			else
			{
				$('#connectionCodeCtrlGroup').attr('class', 'form-group');
				$('#connectionCodeErrorMsg').hide();
			}

			if (ok == true)
			{
				if (stInt == 0) // transcoder
				{
					if ($("#wowzaCloudDestinationType").val() == "streamTarget")
					{
						// reset stream_target params when switching
						$('#sourceStreamName').val("");
						$('input[name=autoStart]').prop("checked",false);
						$("#wowzaCloudAdaptiveStreaming").val("true"); // ignored for wowzaCloudDestinationType == transcoder but makes map entry cleaner
						$("#wowzaCloudDestinationServer").val("primary"); // ignored for wowzaCloudDestinationType == transcoder but makes map entry cleaner
					}

					$("#wowzaCloudDestinationType").val("transcoder");
				}
				if (stInt == 1) // streamTarget
				{
					if ($("#wowzaCloudDestinationType").val() == "transcoder")
					{
						// reset stream_target params when switching
						$('#sourceStreamNamePrefix').val("");
						$("#wowzaCloudAdaptiveStreaming").val("true");
						$('input[name=wowzaCloudABRRadio][value=multiple]').prop("checked",true);
						$("#wowzaCloudDestinationServer").val("primary");
						$('input[name=autoStart]').prop("checked",false); // ignored for wowzaCloudDestinationType == streamTarget but makes map entry cleaner
					}

					$("#wowzaCloudDestinationType").val("streamTarget");
				}
			}
		}
	}
	return ok;
}

function updateAkamaiSettings()
{
	var selectedProtocol = $('input[name=protocolAkamai]:checked').val();
	// set the hidden protocol field
	$("#protocol").val(selectedProtocol);

	updateCommonFields(selectedProtocol, "akamai", "basic", "Edit");
}

function updateShoutCastSettings()
{
	var selectedProtocol = $('input[name=protocolShoutcast]:checked').val();
	// set the hidden protocol field
	$("#protocol").val(selectedProtocol);

	if (selectedProtocol=="shoutcast1")
	{
		$("[basicShoutcastUserEdit]").hide();
		$("[basicShoutcastDestinationEdit]").hide();
	}
	else // Shoutcast2
	{
		$("[basicShoutcastUserEdit]").show();
		$("[basicShoutcastDestinationEdit]").show();
	}
}

function doFBLogin ()
{
	$("#facebookFailPermissions").hide();
	$("#facebookFailAPI").hide();
	$("#facebookFailLogin").hide();

	var rtn = WOWZA.Facebook.login(function(response) {
		// {result: "success", reason: "logged-in"}
		// {result: "fail", reason: "canceled by user"}
		// {result: "fail", reason: "closed unexpectedly"}
		// {result: "fail", reason: "insufficient permissions"}
		// {result: "fail", reason: "token request timeout"}
		// {result: "fail", reason: "facebook api error"}
		// {result: "fail", reason: "unknown"}
		if (response.result == "success") {
			$("#facebookAccessToken").val(WOWZA.Facebook.getAccessToken());
			getFBUserDetails();
		}
		else { // response.result == "fail"

			$("#facebookCancel").hide();
			if (response.reason == "canceled by user" || response.reason == "closed unexpectedly") {
				$("#facebookLogin").show();
				if (!inWizard) {
					$("#facebookCurrentConfig").show();
					$("#facebookCurrentConfigHelp").show();
				}
				$("#facebookEditConfigHelp").hide();
			}
			else if (response.reason == "insufficient permissions") {
				$("#facebookFailPermissions").show();
				$("#facebookLogin").show();
				if (!inWizard) {
					$("#facebookCurrentConfig").show();
					$("#facebookCurrentConfigHelp").show();
				}
				$("#facebookEditConfigHelp").hide();
			}
			else if (response.reason == "facebook api error" || response.reason == "token request timeout") {
				$("#facebookFailAPI").show();
				$("#facebookLogin").show();
				if (!inWizard) {
					$("#facebookCurrentConfig").show();
					$("#facebookCurrentConfigHelp").show();
				}
				$("#facebookEditConfigHelp").hide();
			}
			else { // response.reason == "facebook api error" || "unknown"
				$("#facebookFailLogin").show();
				$("#facebookLogin").show();
				if (!inWizard) {
					$("#facebookCurrentConfig").show();
					$("#facebookCurrentConfigHelp").show();
				}
				$("#facebookEditConfigHelp").hide();
			}
		}
		console.log("doFBLogin: " + JSON.stringify(response));
	});

	if (rtn == "pending") {
		$("#facebookLogin").hide();
		$("#facebookCancel").show();
	}
	else if (rtn == "done") {
		$("#facebookLogin").hide();
		$("#facebookChangeUser").show();
	}
	else {
		alert("Internal error logging into Facebook");
	}
}

function doFBChangeUser ()
{
	FBResetOptions("all");

	var rtn = WOWZA.Facebook.logout(function(response) {
		// {result: "success", reason: "logged-out"}
		// {result: "fail", reason: "canceled by user"}
		// {result: "fail", reason: "unknown"}
		if (response.result == "success") {
			$("#facebookAccessToken").val(null);
			$("#facebookCancel").hide();
			$("#facebookLogin").show();
			if (!inWizard) {
				$("#facebookCurrentConfig").show();
				$("#facebookCurrentConfigHelp").show();
			}
			$("#facebookEditConfigHelp").hide();
		}
		else {
			$("#facebookCancel").hide();
			$("#facebookChangeUser").show();
		}
		console.log("doFBChangeUser: " + JSON.stringify(response));
	});

	if (rtn == "pending") {
		$("#facebookChangeUser").hide();
		$("#facebookCancel").show();
	}
	else if (rtn == "done") {
		$("#facebookChangeUser").hide();
		$("#facebookLogin").show();
		if (!inWizard) {
			$("#facebookCurrentConfig").show();
			$("#facebookCurrentConfigHelp").show();
		}
		$("#facebookEditConfigHelp").hide();
	}
	else {
		alert("Internal error changing Facebook user");
	}
}

function doFBCancel ()
{
	WOWZA.Facebook.cancel();
}

function sortArrayByName (a, b)
{
	return a.name.localeCompare(b.name);
}

function renderUserDetailsWidgets ()
{
	$("#facebookUserName").val(userData.name);

	$("#facebookChangeUserLabel").html("<i class=\"fa fa-check text-success\"><strong> " + userData.name + " ${fbChangeUserText}</strong></i>");
	$("#facebookCurrentConfig").hide();
	$("#facebookCurrentConfigHelp").hide();
	$("#facebookCancel").hide();
	$("#facebookChangeUser").show();
	$("#facebookDestOptions").show();
	$("#facebookEditConfigHelp").show();

	doFBOnSelectVideoDest();

	// register for onChange events on the video dest
	$("#facebookDestType").change(doFBOnSelectVideoDest);
}

function renderUserDetailsError ()
{
	console.log("getFBUserDetails: error: " + response.reason);
	$("#facebookCancel").hide();
	$("#facebookFailAPI").show();
	$("#facebookLogin").show();
	if (!inWizard) {
		$("#facebookCurrentConfig").show();
		$("#facebookCurrentConfigHelp").show();
	}
	$("#facebookEditConfigHelp").hide();
}

function sortUserData ()
{
	if (userData.accounts != undefined)
	{
		userData.accounts.data.sort(sortArrayByName);
	}

	if (userData.groups != undefined)
	{
		userData.groups.data.sort(sortArrayByName);
	}
}

function getFBUserDetails ()
{
	var fields = "id,name,accounts{id,name},groups{id,name}";
	var rtn = WOWZA.Facebook.query("/"+facebookApiVer+"/me", fields, function(response) {
		// if there's an issue getting a valid username, just say "An unknown user ..."
		if (response.result == "success" && response.fbResponse.name && response.fbResponse.id) {
			//console.log('getFBUserDetails: fbResponse:\n' + JSON.stringify(response.fbResponse, null, 3));

			userData = response.fbResponse;
			sortUserData();
			renderUserDetailsWidgets();
		}
		else {
			renderUserDetailsError();
		}
	});

	if (rtn == "fail") {
		renderUserDetailsError();
	}
}

function doFBOnSelectVideoDest ()
{
	//console.log("Selected Video Destination: " + $("#facebookDestType").val());

	FBResetOptions("videoDest");

	switch($("#facebookDestType").val()) {

	case "timeline":
		//cleanup
		$("#facebookPagesDropdown").hide();
		$("#facebookGroupsDropdown").hide();
		
		// show Privacy
		$("#facebookPrivacyOption").show();
		$("#facebookPrivacyConfigHelp").show();

		//set user timeline as dest
		FBSetDestInfo("timeline", "${fbMyTimelineText}", userData.id, null, null);
		break;

	case "page":
		//cleanup
		$("#facebookGroupsDropdown").hide();
        $("#facebookPrivacyOption").hide();
        $("#facebookPrivacyConfigHelp").hide();
        // Reset
        $("#facebookGroupsDropdown").val(""); 
		$("#facebookPrivacyOption").val("private");

		$("#facebookPages").empty();

		if (userData.accounts && userData.accounts.data) {
		    // Create select.
            FBCreateSelectForElement("${fbDestName}", $("#facebookPages"), userData.accounts.data);

			// initialize dest info to the default selected option (should be the first one)
			var name = $("#facebookPages").val();
			var id = FBGetIdForName(name, userData.accounts.data);
			FBSetDestInfo("page", name, id, null, null);

			// initialize dest info to the default selected option (should be the first one)
			var name = $("#facebookPages").val();
			var id = FBGetIdForName(name, userData.accounts.data);
			FBSetDestInfo("page", name, id, null, null);

			//show the Pages dropdown
			$("#facebookPagesDropdown").show();

			// register for onChange events on the selected Page
			$("#facebookPages").change(doFBOnSelectPage);
		}
		else {
			// display "You have no pages"
			$("#facebookPages").hide();
			$("#noPagesWarn").show();
			$("#facebookPagesDropdown").show();
			console.log("User has no Pages");
		}

		break;

	case "group":
		// Layout
		$("#facebookPagesDropdown").hide();
        $("#facebookPrivacyOption").hide();
        $("#facebookPrivacyConfigHelp").hide();
		// Reset
        $("#facebookPrivacyOption").val("private");

		$("#facebookGroups").empty();

		if (userData.groups && userData.groups.data) {
			FBCreateSelectForElement("${fbDestName}", $("#facebookGroups"), userData.groups.data);

			// initialize dest info to the default selected option (should be the first one)
			var name = $("#facebookGroups").val();
			var id = FBGetIdForName(name, userData.groups.data);
			FBSetDestInfo("group", name, id, null, null);

			// initialize dest info to the default selected option (should be the first one)
			var name = $("#facebookGroups").val();
			var id = FBGetIdForName(name, userData.groups.data);
			FBSetDestInfo("group", name, id, null, null);

			//show the Groups dropdown
			$("#facebookGroupsDropdown").show();

			// register for onChange events on the selected Group
			$("#facebookGroups").change(doFBOnSelectGroup);
		}
		else {
			// display "You manage no Groups"
			$("#facebookGroups").hide();
			$("#noGroupsWarn").show();
			$("#facebookGroupsDropdown").show();
			console.log("User has no Groups");
		}
		break;
	}
}

function doFBOnSelectPage ()
{
	//console.log("Selected Page: " + $("#facebookPages").val());

	var data = userData.accounts.data;
	// set dest info based on default selected option (should be the first one)
	var name = $("#facebookPages").val();
	var id = FBGetIdForName(name, data);
	FBSetDestInfo("page", name, id, null, null);
}

function doFBOnSelectGroup ()
{
	//console.log("Selected Group: " + $("#facebookGroups").val());

	var data = userData.groups.data;
	// set dest info based on default selected option (should be the first one)
	var name = $("#facebookGroups").val();
	var id = FBGetIdForName(name, data);
	FBSetDestInfo("group", name, id, null, null);
}

function FBSetDestInfo(type, name, id) {
	$("#facebookDestType").val(type);
	$("#facebookDestName").val(name);
	$("#facebookDestId").val(id);

	if (name) {
		disableSave(false);
		console.log('Selected ' + type + ': \"' + name + '\", id: ' + id );
	}
}

function FBResetOptions (event) {

	switch(event) {

	case "all":
		$("#facebookDestOptions").hide();
		userData = null;
		// fall through
	}
}

function FBGetEntryForName(name, data)
{
	for (var entry in data) {
		if (data[entry].name == name)
			return data[entry];
	}
	return null
}

function FBGetIdForName(name, data)
{
	for (var entry in data) {
		if (data[entry].name == name)
			return data[entry].id;
	}
	return null
}

function FBGetNameForId(id, data)
{
	for (var entry in data) {
		if (data[entry].id == id)
			return data[entry].name;
	}
	return null
}

function FBCreateSelectForElement(currentSelection, selectElement, data)
{
    $(selectElement).empty();

    for (var obj in data) {
        if (data[obj].name == currentSelection) {
            $(selectElement).append('<option value="' + data[obj].name + '" selected="selected">' + data[obj].name + '</option>');
        } else {
            $(selectElement).append('<option value="' + data[obj].name + '">' + data[obj].name + '</option>');
        }
    }
}

function disableSave(disable) {
    if (disable) {
        if (inWizard)
            $("#addtargetbtn").addClass("disabled");
        else
            $("[id=savebtn]").addClass("disabled");
    } else {
        if (inWizard)
            $("#addtargetbtn").removeClass("disabled");
        else
            $("[id=savebtn]").removeClass("disabled");
    }
}

function cdnCloudSignIn()
{
	$('#wowzaCdnCloudEmailErrorMsg').hide();
	$('#wowzaCdnCloudEmailCtrlGroup').attr('class', 'form-group none');
	$('#wowzaCdnCloudPasswordErrorMsg').hide();
	$('#wowzaCdnCloudPasswordCtrlGroup').attr('class', 'form-group none');
	$("[basicWowzaCdnLoginMessageFailureEdit]").hide();
	$("[basicWowzaCdnLoginMessageFailureInternalEdit]").hide();
	$("[basicWowzaCdnCloudSignInTextEdit]").hide();
	$("[basicWowzaCdnLoginMessageFailureEulaApiEdit]").hide();
	$("[basicWowzaCdnLoginMessageFailureEulaEdit]").hide();
	$("[basicWowzaCdnLoginMessageFailureCredentialsEdit]").hide();

	var thisEmail=$("#wowzaCdnCloudEmail").val().trim();
	var thisPassword=$("#wowzaCdnCloudPassword").val().trim();

	var request={};
	request.cmd = "auth";
	request.email = thisEmail;
	request.password = thisPassword;
	request.forceEulaPopup = forceEulaPopup;
	var dataPost =  JSON.stringify(request);

	if (validateCdnLogin())
	{
		WOWZA.RestProxy.request("${appType}", "${wmsutil:urlEncode(vhost)}", "${wmsutil:urlEncode(appName)}", dataPost, function(state, respData) {
		//WOWZA.RestProxy.request("live", "_default_vhost_", "live_st", dataPost, function(state, respData) {

			// if successful call to streamTargetsController
			if (state)
			{
				//console.log('successful AJAX call, parse response...');
				var responseJSON = JSON.parse(respData);

				if (responseJSON != null)
				{
					if (responseJSON.success === true)
					{
						//console.log(responseJSON.data);

						var responseDataString = null;

						if (responseJSON.data.indexOf("current_content") != -1)
						{
							// The responseJSON.data contains the entire authenticate response, which includes the EULA text.
							// The EULA text is encoded as an HTML page, which causes issues with the JSON parser, so manually
							// extract the EULA text (the "current_content" field) to make our lives much easier.

							// Extract the EULA into it's own variable
							var eulaTextStart = responseJSON.data.indexOf("current_content") + 'current_content":"'.length;
							var eulaTextEnd = responseJSON.data.indexOf("needs_to_accept") - 3;
							var eulaText = responseJSON.data.substr(eulaTextStart, eulaTextEnd-eulaTextStart);

							// Create a new string that has the EULA text removed
							var removeEulaStart = responseJSON.data.indexOf("current_content") - 1;
							var removeEulaEnd = responseJSON.data.indexOf("needs_to_accept") - 1;
							var responseDataString = responseJSON.data.substr(0, removeEulaStart) + responseJSON.data.substr(removeEulaEnd, responseJSON.data.length);
						}
						else
						{
							responseDataString = responseJSON.data;
						}

						// Woot now we can parse the thing!
						var responseData = JSON.parse(responseDataString);

						//console.log("Response without EULA string: " + JSON.stringify(responseData));

						// save off the keys for the stream target create call:
						cloudAccounts=responseData.user.cloud_accounts;

						// save Target ID to model
						$('#wowzaCdnCloudTargetId').val(responseData.user.id);

						// Show the Eula popup if the cloud API says the user needs to accept or check the global variable we can set on the page
						// before calling Sign In to force the pop-up.
						if (responseData.user.eula.needs_to_accept || forceEulaPopup)
						{
							//user needs to accept EULA. Show Eula modal.
							newEulaShow(eulaText, function(eulaModalResponse) {
								if (eulaModalResponse)
								{
									//console.log(" eula accepted so let cloud know");
									var eulaRequest={};
									eulaRequest.cmd = "eula-accept";
									eulaRequest.email = thisEmail;
									eulaRequest.eula_version = responseData.user.eula.accepted_version;
									var eulaData = JSON.stringify(eulaRequest);

									WOWZA.RestProxy.request("${appType}", "${wmsutil:urlEncode(vhost)}", "${wmsutil:urlEncode(appName)}", eulaData, function(state, data) {

										if (state)
										{
											// successful response from controller
											var responseJSON = null;
											var dataJSON = JSON.parse(data);

											if (dataJSON.success && (dataJSON.code=="204"))
											{
												//console.log("Eula accept sent to cloud successfully.")

												showCloudAccounts(responseData.user);
												$("[basicWowzaCdnCloudEulaVerifiedEdit]").show();
											}
											else
											{
												$("[basicWowzaCdnLoginMessageFailureEulaApiEdit]").show();
												$("[basicWowzaCdnCloudSignInTextEdit]").hide();

												console.log("Eula accept sent to cloud but an error was returned.")
												console.log(JSON.stringify(dataJSON));
											}
										}
										else
										{
											console.log("Eula accept sent to cloud with a failure")
											$("[basicWowzaCdnLoginMessageFailureInternalEdit]").show();
											$("[basicWowzaCdnCloudSignInTextEdit]").hide();
										}
									});

								}
								else
								{
									// user didn't accept EULA.
									$("[basicWowzaCdnLoginMessageFailureEdit]").hide();
									$("[basicWowzaCdnLoginMessageFailureInternalEdit]").hide();
									$("[basicWowzaCdnCloudSignInTextEdit]").hide();
									$("[basicWowzaCdnLoginMessageFailureEulaApiEdit]").hide();
									$("[basicWowzaCdnLoginMessageFailureCredentialsEdit]").hide();

									$("[basicWowzaCdnLoginMessageFailureEulaEdit]").show();
								}
							});
						}
						else
						{
							//console.log("user does not need to accept eula.");
							showCloudAccounts(responseData.user);
						}

					}
					else if (responseJSON.success === false)
					{
						// response from cloud was failure. look at error code/message
						console.log("failure: " + responseJSON.code + ", " + responseJSON.message);
						$("[basicWowzaCloudABRQuestionEdit]").show();
						$("#addtargetbtn").addClass("disabled");
						$("[basicWowzaCdnLoginEdit]").show();
						$("[basicWowzaCdnCloudSignInTextEdit]").hide();

						$("[basicWowzaCdnLoginMessageFailureInternalEdit]").hide();
						$("[basicWowzaCdnLoginMessageFailureEulaEdit]").hide();
						$("[basicWowzaCdnLoginMessageFailureEulaApiEdit]").hide();
						$("[basicWowzaCdnLoginMessageFailureCredentialsEdit]").hide();

						switch (responseJSON.code)
						{
						case 422:
							$('#wowzaCdnCloudEmailCtrlGroup').attr('class', 'form-group has-error');
							$('#wowzaCdnCloudEmailErrorMsg').show();
							$('#wowzaCdnCloudPasswordCtrlGroup').attr('class', 'form-group has-error');
							$('#wowzaCdnCloudPasswordErrorMsg').show();
							$("[basicWowzaCdnLoginMessageFailureCredentialsEdit]").show();
							break;

						case 401:
							if (responseJSON.message == "Unauthorized" || responseJSON.message == "Invalid credentials.")
							{
								$('#wowzaCdnCloudEmailCtrlGroup').attr('class', 'form-group has-error');
								$('#wowzaCdnCloudEmailErrorMsg').show();
								$('#wowzaCdnCloudPasswordCtrlGroup').attr('class', 'form-group has-error');
								$('#wowzaCdnCloudPasswordErrorMsg').show();
								$("[basicWowzaCdnLoginMessageFailureCredentialsEdit]").show();
							} else
							{
								//401 can also be Invalid Secret Key so don't highlight email pass fields and use generic message
								$("[basicWowzaCdnLoginMessageFailureEdit]").show();
							}
							break;

						case 403:
						case 501:
						case 503:
						default:
							$("[basicWowzaCdnLoginMessageFailureEdit]").show();
							break;
						}

					}
					else
					{
						console.log("Message isn't set right in engine. Should be true or false");
						$("[basicWowzaCdnLoginMessageFailureInternalEdit]").show();
					}
				}
				else
				{
					// response from engine was null. internal error (parsing the data from cloud or timeout etc)
					$("[basicWowzaCloudABRQuestionEdit]").show();
					$("#addtargetbtn").addClass("disabled");
					$("[basicWowzaCdnLoginEdit]").show();

					$("[basicWowzaCdnCloudSignInTextEdit]").hide();
					$("[basicWowzaCdnLoginMessageFailureEdit]").hide();
					$("[basicWowzaCdnLoginMessageFailureEulaEdit]").hide();
					$("[basicWowzaCdnLoginMessageFailureEulaApiEdit]").hide();
					$("[basicWowzaCdnLoginMessageFailureCredentialsEdit]").hide();

					$("[basicWowzaCdnLoginMessageFailureInternalEdit]").show();
				}
			}
			else
			{
				console.log('Failure with AJAX call to Stream Targets Controller. (timeout error?)');

				$("[basicWowzaCdnCloudSignInTextEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureEulaEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureEulaApiEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureCredentialsEdit]").hide();

				$("[basicWowzaCdnLoginMessageFailureInternalEdit]").show();
			}
		});
	}// validateBasicConfigOptions was false. errors showing

}

function showCloudAccounts(userResponseData)
{
	//parse account info and make sure a user exists
	var user = userResponseData;
	if (user)
	{
		// setup drop-down of cloud accounts.
		var data = user.cloud_accounts;

		if (data)
		{
			var validAccount=false;
			var activeCount=0;
			$("#wowzaCdnAccountSelection").empty();
			for (var dude in data) {
				//only grab accounts that are active
				if ((data[dude].status == "active") )
				{
					$("#wowzaCdnAccountSelection").append('<option value="' + data[dude].name + '">' + data[dude].name + '</option>');
					validAccount=true;
					activeCount++;
				}
			}
			//console.log ("activeCount: " +activeCount);

			if (validAccount && (data.length > 1)) //activeCount
			{
				//show the dropdown
				$("#wowzaCdnAccountSelection").show();

				$("#addtargetbtn").removeClass("disabled");
				$("[basicWowzaCdnLoginEdit]").hide();
				$("[basicWowzaCdnCloudSignInTextEdit]").hide();

				// and hide the error's if they exists
				$("[basicWowzaCdnLoginMessageFailureEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureEulaEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureInternalEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureEulaApiEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureCredentialsEdit]").hide();

				//show success message and account drop-down
				$("#wowzaCdnCloudVerifiedEdit").html("<i class=\"fa fa-check text-success\"><strong>${wowzaCdnCloudVerified} (" + user.email + ") </strong></i>");
				$("[basicWowzaCdnLoginMessageSuccessEdit]").show();

				$("[basicWowzaCdnAccountSelectionEdit]").show();
			}
			else if (validAccount && (data.length == 1))
			{
				$("#addtargetbtn").removeClass("disabled");
				$("[basicWowzaCdnLoginEdit]").hide();
				$("[basicWowzaCdnCloudSignInTextEdit]").hide();

				// and hide the error's if they exists
				$("[basicWowzaCdnLoginMessageFailureEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureEulaEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureInternalEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureEulaApiEdit]").hide();
				$("[basicWowzaCdnLoginMessageFailureCredentialsEdit]").hide();

				//show success message and account drop-down
				$("#wowzaCdnCloudVerifiedEdit").html("<i class=\"fa fa-check text-success\"><strong>${wowzaCdnCloudVerified} (" + user.email + ") </strong></i>");
				$("[basicWowzaCdnLoginMessageSuccessEdit]").show();
			}
			else
			{
				// no accounts in active or trial mode
				console.log("No valid cloud accounts exist.")
				$("[basicWowzaCdnCloudSignInTextEdit]").hide();
				$("#wowzaCdnCloudVerifiedEdit").html("<i class=\"fa fa-check text-success\"><strong>${wowzaCdnCloudVerified} (" + user.email + ") </strong></i>");
				$("[basicWowzaCdnLoginMessageSuccessEdit]").show();
				$("[basicWowzaCdnCloudFailureNoValidAccountsEdit]").show();
			}

		}
		else
		{
			//It is possible to get a null list if it's a new account or an account without a subscription.
			console.log("No cloud accounts exist.")
			$("[basicWowzaCdnCloudSignInTextEdit]").hide();
			$("#wowzaCdnCloudVerifiedEdit").html("<i class=\"fa fa-check text-success\"><strong>${wowzaCdnCloudVerified} (" + user.email + ") </strong></i>");
			$("[basicWowzaCdnLoginMessageSuccessEdit]").show();
			$("[basicWowzaCdnCloudFailureNoAccountsEdit]").show();
		}
	}
	else
	{
		// no user account, should never happen
		console.log("No User Account");
		$("[basicWowzaCdnCloudSignInTextEdit]").hide();
		$("[basicWowzaCdnLoginMessageFailureInternalEdit]").show();
	}
}

function handleWowzaCloudABR()
{
	var selectedRadio = $('input[name=wowzaCloudABRRadio]:checked').val();
	switch (selectedRadio)
	{
	case "single":
		$('#sourceStreamName').val("");
		$('input[name=autoStart]').prop("checked",false);
		$("[basicSourceStreamNameEdit]").show();
		$("[basicSourceStreamNamePrefixEdit]").hide();
		$("#wowzaCloudAdaptiveStreaming").val("false");
		break;

	case "multiple":
	default:
		$('#sourceStreamNamePrefix').val("");
		$("[basicSourceStreamNamePrefixEdit]").show();
		$("[basicSourceStreamNameEdit]").hide();
		$("#wowzaCloudAdaptiveStreaming").val("true");
		break;
	}
}

function updateSecureSRTHelper()
{
	var $srtPassPhrase = $("#srtPassPhrase");
    var $srtKeyLength = $("#srtKeyLength");
	var $srtPassPhraseHelp = $("#passphraseSRTHelp")
    var $srtKeyLengthHelp = $("#srtKeyLengthHelp");
	var $srtSecure = $('[basicsrtsecureedit]');

	if($('#secureSRT').prop("checked")===true)
	{
		$srtSecure.show();
		$srtPassPhrase.prop("disabled", false);
		$srtKeyLength.prop("disabled", false);
		$srtPassPhraseHelp.show();
		$srtKeyLengthHelp.show();
	}
	else
	{
		$srtSecure.hide();
		$srtPassPhrase.prop("disabled", true);
		$srtKeyLength.prop("disabled", true);
		$srtPassPhraseHelp.hide();
		$srtKeyLengthHelp.hide();
	}
}

</script>

