<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}
</c:set>
<wmsform:setpagetitle page="appconfig.incomingstreams" appName="${appName}"/>

<wmsdialog:pantiltzoom page="appconfig.incomingstreams"/>

<c:set var="pagename">
	<wmsform:getlocalestring page="appconfig.incomingstreams" obj="head"/>
</c:set>

<c:set var="instanceList" >
	instanceList
</c:set>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<div class="col-md-5">
			<happ>${wmsutil:escapeHtml(appName)} ${pagename}</happ><br>
			<small class="text-muted"><wmsform:objvalue page="appConfig" obj="uiAppType"/></small>
		</div>
		<wmsform:applicationbuttons page="incomingstreams"/>
		<wmsform:startrecording page="incomingstreams"/>
		<wmsdialog:stoprecording page="incomingstreams"/>
		<wmsdialog:splitrecording page="incomingstreams"/>
		<wmsdialog:resetstream page="incomingstreams"/>
		<wmsdialog:disconnectstream page="incomingstreams"/>
		<wmsdialog:resetstreamgroup page="incomingstreams"/>
		<wmsdialog:disconnectstreamgroup page="incomingstreams"/>
		<wmsdialog:removestreamgroup page="incomingstreams"/>
	</div>
	<div class="row col-md-12">
		<p id="pageText"></p>
	</div>
	<div class="notabs">
	<hr/>
	</div>
	<div class="row">
		<div class="col-md-8 main-content">
			<wmsform:rightrailhideshow/>
			<h4><wmsform:getlocalestring page="appconfig.incomingstreams" obj="activeStreams"/><small><wmsform:getlocalestring page="appconfig.incomingstreams" obj="header"/></small></h4>
			<p class="text-muted"></p>
			<div>
				<wmsform:button page="common" cssClass="btn btn-default btn-sm" onClick="javascript:loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','incomingstreams')" obj="refresh" icon="fa fa-repeat"/>
				<div class="btn-group" data-toggle="buttons-radio">
					<button type="button" class="btn btn-default btn-sm" id="buttonStream" onClick="javascript:showStreamView('true')"><wmsform:getlocalestring page="appconfig.incomingstreams" obj="viewStream"/></button>
					<button type="button" class="btn btn-default btn-sm" id="buttonGroup" onClick="javascript:showStreamView('false')"><wmsform:getlocalestring page="appconfig.incomingstreams" obj="viewGroup"/></button>
				</div>
			</div>
			<br/>
			<div>
				<c:if test="${fn:length(requestScope.formData[instanceList])<=0}">
					<wmsform:getlocalestring page="appconfig.incomingstreams" obj="nostreams"/>
				</c:if>
				<ul id="viewByStream" class="list-unstyled">
					<c:forEach var="instance" items="${requestScope.formData[instanceList]}">
						<li>
							<c:choose>
								<c:when test="${instance['instanceName']=='_definst_'}">
									<h5><wmsform:getlocalestring page="appconfig.incomingstreams" obj="defInst"/> (${wmsutil:escapeHtml(instance['instanceName'])})</h5>
								</c:when>
								<c:otherwise>
									<h5>${wmsutil:escapeHtml(instance['instanceName'])}</h5>
								</c:otherwise>
							</c:choose>
							<table class="table table-striped">
								<tbody>
									<tr>
										<th><wmsform:getlocalestring page="appconfig.incomingstreams" obj="tblStream"/></th>
										<th><wmsform:getlocalestring page="appconfig.incomingstreams" obj="tblStatus"/></th>
										<th><wmsform:getlocalestring page="appconfig.incomingstreams" obj="tblActions"/></th>
									</tr>
									<c:forEach var="stream" items="${instance['streamList']}">
										<c:set var="recorder" value="${stream['recorderConfig']}"/>
										<tr class="indent1">
											<td class="breakword">
												<c:choose>
													<c:when test="${stream['streamState']=='Recording in Progress'}">
														<span class="text-danger"><I class="fa fa-circle"></i></span>
													</c:when>
													<c:when test="${stream['streamState']=='Waiting for stream'}">
														<span><I class="fa fa-clock-o"></i></span>
													</c:when>
													<c:when test="${stream['streamState']=='Recorder error'}">
														<span><I class="text-danger fa fa-exclamation-circle"></i></span>
													</c:when>
													<c:otherwise>
														<i class="fa fa-arrow-right fa-fw"></i>
													</c:otherwise>
												</c:choose>
												<a onclick="javascript:loadIncomingStreamDetails('${wmsutil:escapeHtml(appName)}','${appType}', 'incomingstreams_details', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}', 'incomingstreams')">${wmsutil:escapeHtml(stream['streamName'])}</a>
												<br />
												<span class="muted indent1">${wmsutil:escapeHtml(stream['sourceIp'])}</span>
											</td>
											<td class="breakword">
												${stream['streamState']}
												<p class="recordinginfo">${stream['recorderInfo']}</p>
												<p class="recordinginfo">${recorder['currentFile']}</p>
											</td>
											<td>
												<sec:authorize access="hasAnyRole('admin')">
													<c:choose>
														<c:when test="${stream['ptzEnabled']=='true'}">
															<a onclick="javascript:showPTZ('${appName}', '${instance['instanceName']}', '${stream['streamName']}', '${stream['sourceControlImageRefreshRate']}', '${stream['sourceControlImageRefreshMinimumRate']}')" class="fa fa-arrows fa-2x icon-standalone-link" title"" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Pan Tilt Zoom"></a>
														</c:when>
														<c:otherwise>
															<a class="hide-icon fa fa-2x fa-arrows" data-original-title="Blank spot"></a>
														</c:otherwise>
													</c:choose>
													<c:choose>
														<c:when test="${stream['streamState']=='Recording in Progress'}">
															<a onclick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-stop fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Stop recording"></a>&nbsp;
															<a onclick="javascript:splitRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-code-fork fa-2x icon-standalone-link"  title="" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Split recording"></a>&nbsp;
														</c:when>
														<c:when test="${stream['streamState']=='Waiting for stream'}">
															<a onclick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-stop fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Stop recording"></a>&nbsp;
														</c:when>
														<c:when test="${stream['streamState']=='Recorder error'}">
															<a onclick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-stop fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Stop recording"></a>&nbsp;
														</c:when>
														<c:otherwise>
															<a onclick="javascript:startRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Record this stream"><span class="text-danger"><i class="fa fa-circle fa-2x"></i></span></a>&nbsp;
														</c:otherwise>
													</c:choose>
													<c:if test="${stream['streamConfig'].managedStream =='true'}">
														<a onclick="javascript:resetStreamShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-repeat fa-2x icon-standalone-link"  title="" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Reset stream"></a>&nbsp;
														<a onclick="javascript:disconnectStreamShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-times fa-2x icon-standalone-link"  title="" data-placement="bottom" data-toggle="tooltip" data-delay="250" data-original-title="Disconnect stream"></a>
													</c:if>
												</sec:authorize>
											</td>
										</tr>
									</c:forEach>
								</tbody>
							</table>
						</li>
					</c:forEach>
				</ul>

				<ul id="viewByGroup" class="list-unstyled">
					<c:forEach var="instance" items="${requestScope.formData[instanceList]}">
						<li>
							<c:choose>
								<c:when test="${instance['instanceName']=='_definst_'}">
									<h5><wmsform:getlocalestring page="appconfig.incomingstreams" obj="defInst"/> (${wmsutil:escapeHtml(instance['instanceName'])})</h5>
								</c:when>
								<c:otherwise>
									<h5>${wmsutil:escapeHtml(instance['instanceName'])}</h5>
								</c:otherwise>
							</c:choose>

							<c:forEach var="group" items="${instance['groupList']}">
								<table class="table table-striped">
									<tbody>
										<tr>
											<th>${group['groupName']}</th>
											<th></th>
											<sec:authorize access="hasAnyRole('admin')">
												<c:choose>
													<c:when test="${group['transcodeResult']=='true'}">
														<th>
															<a onclick="javascript:removeStreamGroupShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${group['groupName']}')" class="fa fa-times fa-2x icon-standalone-link"  title="" data-placement="bottom" data-toggle="tooltip" data-delay="250" data-original-title="Remove stream group"></a>
														</th>
													</c:when>
													<c:otherwise>
														<th>
															<a onclick="javascript:resetStreamGroupShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${group['groupName']}')" class="fa fa-repeat fa-2x icon-standalone-link"  title="" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Reset stream group"></a>&nbsp;
															<a onclick="javascript:disconnectStreamGroupShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${group['groupName']}')" class="fa fa-times fa-2x icon-standalone-link"  title="" data-placement="bottom" data-toggle="tooltip" data-delay="250" data-original-title="Disconnect stream group"></a>
														</th>
													</c:otherwise>
												</c:choose>
											</sec:authorize>
										</tr>
										<c:forEach var="stream" items="${group['streamList']}">
											<c:set var="recorder" value="${stream['recorderConfig']}"/>
											<tr class="indent1">
												<td>
													<sec:authorize access="hasAnyRole('admin')">
														<c:choose>
															<c:when test="${stream['streamState']=='Recording in Progress'}">
																<span class="text-danger"><I class="fa fa-circle"></i></span>
															</c:when>
															<c:when test="${stream['streamState']=='Waiting for stream'}">
																<span><I class="fa fa-clock-o"></i></span>
															</c:when>
															<c:when test="${stream['streamState']=='Recorder error'}">
																<span><I class="text-danger fa fa-exclamation-circle"></i></span>
															</c:when>
															<c:otherwise>
																<i class="fa fa-arrow-right fa-fw"></i>
															</c:otherwise>
														</c:choose>
													</sec:authorize>
													<a onclick="javascript:loadIncomingStreamDetails('${wmsutil:escapeHtml(appName)}','${appType}', 'incomingstreams_details', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')">${wmsutil:escapeHtml(stream['streamName'])}</a>
													<br />
													<span class="muted indent1">${wmsutil:escapeHtml(stream['sourceIp'])}</span>
												</td>
												<td>
													${stream['streamState']}
													<p class="recordinginfo">${stream['recorderInfo']}</p>
													<p class="recordinginfo">${recorder['currentFile']}</p>
												</td>
												<td>
													<sec:authorize access="hasAnyRole('admin')">
														<c:choose>
															<c:when test="${stream['ptzEnabled']=='true'}">
																<a onclick="javascript:showPTZ('${appName}', '${instance['instanceName']}', '${stream['streamName']}', '${stream['sourceControlImageRefreshRate']}', '${stream['sourceControlImageRefreshMinimumRate']}')" class="fa fa-arrows fa-2x icon-standalone-link" title"" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Pan Tilt Zoom"></a>
															</c:when>
															<c:otherwise>
																<a class="hide-icon fa fa-2x fa-arrows" data-original-title="Blank spot"></a>
															</c:otherwise>
														</c:choose>
														<c:choose>
															<c:when test="${stream['streamState']=='Recording in Progress'}">
																<a onclick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-stop fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Stop recording"></a>&nbsp;
																<a onclick="javascript:splitRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-code-fork fa-2x icon-standalone-link"  title="" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Split recording"></a>&nbsp;
															</c:when>
															<c:when test="${stream['streamState']=='Waiting for stream'}">
																<a onclick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-stop fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Stop recording"></a>&nbsp;
															</c:when>
															<c:when test="${stream['streamState']=='Recorder error'}">
																<a onclick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-stop fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Stop recording"></a>&nbsp;
															</c:when>
															<c:otherwise>
																<a onclick="javascript:startRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Record this stream"><span class="text-danger"><i class="fa fa-circle fa-2x"></i></span></a>&nbsp;
															</c:otherwise>
														</c:choose>
														<c:if test="${stream['streamConfig'].managedStream =='true'}">
															<a onclick="javascript:resetStreamShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-repeat fa-2x icon-standalone-link"  title="" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Reset stream"></a>&nbsp;
															<a onclick="javascript:disconnectStreamShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-times fa-2x icon-standalone-link"  title="" data-placement="bottom" data-toggle="tooltip" data-delay="250" data-original-title="Disconnect stream"></a>
														</c:if>
													</sec:authorize>
												</td>
											</tr>
										</c:forEach>
									</tbody>
								</table>
								<hr />
							</c:forEach>


							<c:if test="${fn:length(instance['ungroupedList'])>0}">

								<table class="table table-striped">
									<tbody>
										<tr>
											<th><wmsform:getlocalestring page="appconfig.incomingstreams" obj="tblUngroupedStream"/></th>
											<th><wmsform:getlocalestring page="appconfig.incomingstreams" obj="tblStatus"/></th>
											<th><wmsform:getlocalestring page="appconfig.incomingstreams" obj="tblActions"/></th>
										</tr>
										<c:forEach var="stream" items="${instance['ungroupedList']}">
											<c:set var="recorder" value="${stream['recorderConfig']}"/>
											<tr class="indent1">
												<td>
													<c:choose>
														<c:when test="${stream['streamState']=='Recording in Progress'}">
															<span class="text-danger"><I class="fa fa-circle"></i></span>
														</c:when>
														<c:when test="${stream['streamState']=='Waiting for stream'}">
															<span><I class="fa fa-clock-o"></i></span>
														</c:when>
														<c:when test="${stream['streamState']=='Recorder error'}">
															<span><I class="text-danger fa fa-exclamation-circle"></i></span>
														</c:when>
														<c:otherwise>
															<i class="fa fa-arrow-right fa-fw"></i>
														</c:otherwise>
													</c:choose>
													<a onclick="javascript:loadIncomingStreamDetails('${wmsutil:escapeHtml(appName)}','${appType}', 'incomingstreams_details', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')">${wmsutil:escapeHtml(stream['streamName'])}</a>
													<br />
													<span class="muted indent1">${wmsutil:escapeHtml(stream['sourceIp'])}</span>
												</td>
												<td>
													${stream['streamState']}
													<p class="recordinginfo">${stream['recorderInfo']}</p>
													<p class="recordinginfo">${recorder['currentFile']}</p>
												</td>
												<td>
													<sec:authorize access="hasAnyRole('admin')">
														<c:choose>
															<c:when test="${stream['ptzEnabled']=='true'}">
																<a onclick="javascript:showPTZ('${appName}', '${instance['instanceName']}', '${stream['streamName']}', '${stream['sourceControlImageRefreshRate']}', '${stream['sourceControlImageRefreshMinimumRate']}')" class="fa fa-arrows fa-2x icon-standalone-link" title"" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Pan Tilt Zoom"></a>
															</c:when>
															<c:otherwise>
																<a class="hide-icon fa fa-2x fa-arrows" data-original-title="Blank spot"></a>
															</c:otherwise>
														</c:choose>
														<c:choose>
															<c:when test="${stream['streamState']=='Recording in Progress'}">
																<a onclick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-stop fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Stop recording"></a>&nbsp;
																<a onclick="javascript:splitRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-code-fork fa-2x icon-standalone-link"  title="" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Split recording"></a>&nbsp;
															</c:when>
															<c:when test="${stream['streamState']=='Waiting for stream'}">
																<a onclick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-stop fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Stop recording"></a>&nbsp;
															</c:when>
															<c:when test="${stream['streamState']=='Recorder error'}">
																<a onclick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="icon-stop fa-2x icon-standalone-link"  title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Stop recording"></a>&nbsp;
															</c:when>
															<c:otherwise>
																<a onclick="javascript:startRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" title="" data-placement="left" data-toggle="tooltip" data-delay="250" data-original-title="Record this stream"><span class="text-danger"><i class="fa fa-circle fa-2x"></i></span></a>&nbsp;
															</c:otherwise>
														</c:choose>
														<c:if test="${stream['streamConfig'].managedStream =='true'}">
															<a onclick="javascript:resetStreamShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-repeat fa-2x icon-standalone-link"  title="" data-placement="top" data-toggle="tooltip" data-delay="250" data-original-title="Reset stream"></a>&nbsp;
															<a onclick="javascript:disconnectStreamShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instance['instanceName'])}', '${wmsutil:escapeHtml(stream['streamName'])}')" class="fa fa-times fa-2x icon-standalone-link"  title="" data-placement="bottom" data-toggle="tooltip" data-delay="250" data-original-title="Disconnect stream"></a>
														</c:if>
													</sec:authorize>
												</td>
											</tr>
										</c:forEach>
									</tbody>
								</table>
							</c:if>
						</li>
					</c:forEach>
				</ul>
			</div>
        </div>

		<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
			<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
		</div>
	</div>
</div>

<script>
showStreamView(incomingStreamViewByStream);
function showStreamView(viewByStream)
{
	incomingStreamDetailsParentPage="incomingstreams";
	incomingStreamViewByStream = viewByStream;
	createCookie("incomingStreamViewByStream", viewByStream);
	if (viewByStream=='true')
	{
		$('#buttonStream').addClass("active");
		$('#buttonGroup').removeClass("active");
		$('#viewByStream').show();
		$('#viewByGroup').hide();
	}
	else
	{
		$('#buttonStream').removeClass("active");
		$('#buttonGroup').addClass("active");
		$('#viewByStream').hide();
		$('#viewByGroup').show();
	}
}

function showPTZ(appName, instanceName, streamName, refreshRate, refreshMinimumRate)
{
	var streamName2 = streamName.substring(0,streamName.indexOf(".stream"));
	panTiltZoomShow(appName,instanceName, streamName2, refreshRate, refreshMinimumRate);
}

</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>






