<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About Applications</h4>
<p>An <em>application</em> is a set of configuration options in Wowza Streaming Engine that supports a specific use case for the delivery of streaming content. You can use these options and configurable properties to tune and modify an application's default streaming configuration. Application functionality can be extended by <em>modules</em>, which are Java classes that are loaded dynamically when an application instance is loaded. Many <a href="https://www.wowza.com/products/streaming-engine/addons" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Wowza Streaming Engine AddOns</a> provide additional functionality through the use of modules. For basic application configuration details, see <a href="https://www.wowza.com/docs/how-to-get-started-as-a-wowza-streaming-engine-manager-administrator#appConfig" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Create applications</a>.</p>

<p>You can add applications for six streaming use cases (described below) in Wowza Streaming Engine Manager. To add an application, click the <strong>Application Type</strong> in the page that corresponds to your use case, enter a name for the application in the <strong>New Application</strong> dialog box, and then click <strong>Add</strong>. The application name can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters). After the application is added, Wowza Streaming Engine Manager displays the new application configuration page so that you can modify it.</p>

<blockquote><strong>Note:</strong> By default, Wowza Streaming Engine includes an application named <strong>vod</strong> for the video-on-demand streaming and an application named <strong>live</strong> for live streaming. You can add additional VOD and live streaming applications in Wowza Streaming Engine Manager; however, you must use different application names.</blockquote>

<h5>Live</h5>
<p>Use a <strong>Live</strong> application to deliver live streams to players (single server) or as an origin server to deliver live streams to other servers running Wowza Media Server or Wowza Streaming Engine software in order to scale content delivery to a large number of players.</p>
<h5>Live Edge</h5>
<p>Use a <strong>Live Edge</strong> application to ingest live streams from a live application on an origin server that's running Wowza Media Server or Wowza Streaming Engine software. This application is then used to deliver the live streams to players (single server).</p>
<h5>Live HTTP Origin</h5>
<p>Use a <strong>Live HTTP Origin</strong> application to deliver live streams to an HTTP caching infrastructure using HTTP streaming protocols (MPEG-DASH, Apple HLS, Adobe HDS, and Microsoft Smooth Streaming).</p>
<h5>VOD</h5>
<p>Use a <strong>VOD</strong> application to stream video on demand (VOD) files to players (single server).</p>
<h5>VOD Edge</h5>
<p>Use a <strong>VOD Edge</strong> application to ingest video on demand files from a Media Cache source. This application is then used to stream the on demand files to players (single server).</p>
<h5>VOD HTTP Origin</h5>
<p>Use a <strong>VOD HTTP Origin</strong> application to deliver video on demand files to an HTTP caching infrastructure using HTTP streaming protocols (MPEG-DASH, Apple HLS, Adobe HDS, and Microsoft Smooth Streaming).</p>
