#!/bin/bash
if [ -d /Library/WowzaStreamingEngine ]
then
	# OS X
	. /Library/WowzaStreamingEngine/bin/setenv.sh
else
	# Linux
	. /usr/local/WowzaStreamingEngine/bin/setenv.sh
fi

$_EXECJAVA -Dcom.wowza.wms.AppHome="$WMSAPP_HOME" -Dcom.wowza.wms.ConfigHome="$WMSCONFIG_HOME" -cp $WMSAPP_HOME/bin/wms-bootstrap.jar com.wowza.wms.bootstrap.Bootstrap stop


# clean things up in case the service was running
WMSBASE_NAME=WowzaStreamingEngine
WMSPID_FILE="/var/run/$WMSBASE_NAME.pid"
WMSLOCK_FILE="/var/run/$WMSBASE_NAME"
if test -w "/var/lock/subsys" ; then
	WMSLOCK_FILE="/var/lock/subsys/$WMSBASE_NAME"
fi
if [ -f $WMSPID_FILE ]; then
	rm -f $WMSPID_FILE
fi
if [ -f $WMSLOCK_FILE ]; then
	rm -f $WMSLOCK_FILE
fi
