/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.http;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.livestreamrecord.manager.ILiveStreamRecordManager;
import com.wowza.wms.livestreamrecord.manager.IStreamRecorder;
import com.wowza.wms.livestreamrecord.manager.StreamRecorderParameters;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class HTTPLiveStreamRecord
extends HTTProvider2Base {
    public static final String CLASSNAME = "HTTPLiveStreamRecord";
    private static final Class<HTTPLiveStreamRecord> CLASS = HTTPLiveStreamRecord.class;
    private WMSLogger logger = WMSLoggerFactory.getLogger(CLASS);

    public void onHTTPRequest(IVHost vhost, IHTTPRequest req, IHTTPResponse resp) {
        String ret;
        block26: {
            if (!this.doHTTPAuthentication(vhost, req, resp)) {
                return;
            }
            Map params = req.getParameterMap();
            IApplicationInstance appInstance = null;
            ret = "";
            String action = "";
            String app = "";
            String streamName = "";
            String error = "";
            if (req.getMethod().equalsIgnoreCase("get") || req.getMethod().equalsIgnoreCase("post") || req.getMethod().equalsIgnoreCase("put")) {
                req.parseBodyForParams(true);
                try {
                    if (params.containsKey("action")) {
                        action = (String)((List)params.get("action")).get(0);
                    } else {
                        error = String.valueOf(error) + "<BR>action is required";
                    }
                    this.logger.debug("HTTPLiveStreamRecord action: " + action);
                    if (params.containsKey("app")) {
                        app = (String)((List)params.get("app")).get(0);
                    } else {
                        error = String.valueOf(error) + "<BR>app is required";
                    }
                    this.logger.debug("HTTPLiveStreamRecord app: " + app);
                    if (params.containsKey("streamname")) {
                        streamName = (String)((List)params.get("streamname")).get(0);
                    } else {
                        error = String.valueOf(error) + "<BR>streamname is required";
                    }
                    this.logger.debug("HTTPLiveStreamRecord streamName: " + streamName);
                    if (error.length() == 0) {
                        appInstance = vhost.getApplication(app).getAppInstance("_definst_");
                        StreamRecorderParameters recordParams = new StreamRecorderParameters(appInstance);
                        if (params.containsKey("option")) {
                            String option = (String)((List)params.get("option")).get(0);
                            recordParams.versioningOption = option.startsWith("append") ? "append" : (option.startsWith("overwrite") ? "overwrite" : "version");
                        }
                        if (params.containsKey("outputPath")) {
                            recordParams.outputPath = (String)((List)params.get("outputPath")).get(0);
                        }
                        if (params.containsKey("outputFile")) {
                            recordParams.outputFile = (String)((List)params.get("outputFile")).get(0);
                        }
                        if (params.containsKey("segmentSize")) {
                            recordParams.segmentSize = Integer.parseInt((String)((List)params.get("segmentSize")).get(0));
                        }
                        if (params.containsKey("segmentDuration")) {
                            recordParams.segmentDuration = Integer.parseInt((String)((List)params.get("segmentDuration")).get(0));
                        }
                        if (params.containsKey("segmentSchedule")) {
                            recordParams.segmentSchedule = (String)((List)params.get("segmentSchedule")).get(0);
                        }
                        if (params.containsKey("fileTemplate")) {
                            recordParams.fileTemplate = (String)((List)params.get("fileTemplate")).get(0);
                        }
                        if (params.containsKey("startonkeyframe")) {
                            recordParams.startOnKeyFrame = Boolean.parseBoolean((String)((List)params.get("startonkeyframe")).get(0));
                        }
                        if (params.containsKey("recorddata")) {
                            recordParams.recordData = Boolean.parseBoolean((String)((List)params.get("recorddata")).get(0));
                        }
                        if (params.containsKey("format")) {
                            int format = Integer.parseInt((String)((List)params.get("format")).get(0));
                            String string = recordParams.fileFormat = format == 1 ? "flv" : "mp4";
                        }
                        if (appInstance.getPublishStreamNames().contains(streamName)) {
                            recordParams.segmentationType = action.equalsIgnoreCase("startRecordingSegmentBySize") ? "size" : (action.equalsIgnoreCase("startRecordingSegmentByDuration") ? "duration" : (action.equalsIgnoreCase("startRecordingSegmentBySchedule") ? "schedule" : "none"));
                            ret = action.equalsIgnoreCase("stopRecording") ? this.stopRecording(appInstance, streamName) : (action.equalsIgnoreCase("splitRecordingNow") ? this.splitRecording(appInstance, streamName) : this.startRecording(appInstance, streamName, recordParams));
                        } else {
                            ret = "Stream Not Found: " + streamName;
                        }
                        break block26;
                    }
                    ret = error;
                }
                catch (Exception ex) {
                    ret = "Error: " + ex.getMessage();
                }
            } else {
                ret = "Nothing to do.";
            }
        }
        try {
            OutputStream out = resp.getOutputStream();
            byte[] outBytes = ret.toString().getBytes();
            out.write(outBytes);
            out.close();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public String startRecording(IApplicationInstance appInstance, String streamName, StreamRecorderParameters recordParams) {
        String output = "";
        IVHost vhost = appInstance.getVHost();
        this.logger.debug("HTTPLiveStreamRecord.startRecording");
        vhost.getLiveStreamRecordManager().startRecording(appInstance, streamName, recordParams);
        output = "startRecording " + streamName;
        return output;
    }

    public String splitRecording(IApplicationInstance appInstance, String streamName) {
        String outputPath = "";
        IVHost vhost = appInstance.getVHost();
        ILiveStreamRecordManager streamRecordManager = vhost.getLiveStreamRecordManager();
        IStreamRecorder recorder = streamRecordManager.getRecorder(appInstance, streamName);
        if (recorder != null) {
            streamRecordManager.splitRecording(appInstance, streamName);
            outputPath = recorder.getFilePath();
        }
        return outputPath;
    }

    public String stopRecording(IApplicationInstance appInstance, String streamName) {
        String outputPath = "";
        IVHost vhost = appInstance.getVHost();
        ILiveStreamRecordManager streamRecordManager = vhost.getLiveStreamRecordManager();
        IStreamRecorder recorder = streamRecordManager.getRecorder(appInstance, streamName);
        if (recorder != null) {
            streamRecordManager.stopRecording(appInstance, streamName);
            outputPath = recorder.getFilePath();
        }
        return outputPath;
    }
}

