<?php
require_once("inc/protecao-admin.php");

$total_streamings = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings"));
$total_revendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE tipo = '1'"));
$total_subrevendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE tipo != '1'"));
$total_servidores = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM servidores"));
$total_apps = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM apps"));


?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Administra&ccedil;&atilde;o</title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">  
  <?php if($dados_revenda["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico" />
  <script type="text/javascript" src="/admin/inc/ajax.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>
<body>
  <div class="container-scroller">
    <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Administra&ccedil;&atilde;o</span></a>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><i class="fa fa-lock text-yellow"></i></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav mr-lg-2">
          <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        </ul>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>
    <div class="container-fluid page-body-wrapper">
      <nav class="sidebar sidebar-offcanvas" id="sidebar">
        <ul class="nav">
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-streamings">
              <i class="fa fa-headphones text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_streaming; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-revendas">
              <i class="fa fa-users text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_revenda; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-servidores">
              <i class="fa fa-tasks text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_servidor; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-avisos">
              <i class="fa fa-info-circle text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_avisos; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-tutoriais">
              <i class="fa fa-life-bouy text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_tutoriais; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-apps">
              <i class="fa fa-android text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_apps; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-logs-acoes">
              <i class="fa fa-file-text-o text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_logs_acoes; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-backup">
              <i class="fa fa-shield text-icones"></i>
              <span class="menu-title">Backup</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-estatisticas">
              <i class="fa fa-bar-chart-o text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_estatisticas; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-configuracoes">
              <i class="fa fa-cog text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_configuracoes; ?></span>
            </a>
          </li>   
        </ul>
      </nav>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-6">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_pagina_estatisticas_titulo_acessos; ?></header>
                  </div>
                <div class="card-body">
                    <table class="table table-hover mb-0">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo lang_pagina_estatisticas_paginas; ?></th>
                                                        <th><?php echo lang_pagina_estatisticas_acessos; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql_stats_pagina = mysqli_query($conexao,"SELECT * FROM acessos_paginas ORDER by total DESC LIMIT 10");
while ($dados_stats_pagina = mysqli_fetch_array($sql_stats_pagina)) {

$array_paginas_exclude = array("funcoes-ajax","favicon.ico","index");

if(!array_search($dados_stats_pagina["pagina"],$array_paginas_exclude)) {

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stats_pagina["pagina"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".number_format($dados_stats_pagina["total"] , 0, ',', '.')."</td>
</tr>";

}
}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

            <div class="col-lg-6">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_pagina_estatisticas_titulo_acessos_players; ?></header>
                  </div>
                <div class="card-body">
                    <table class="table table-hover mb-0">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo lang_pagina_estatisticas_paginas; ?></th>
                                                        <th><?php echo lang_pagina_estatisticas_acessos; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql_stats_players = mysqli_query($conexao,"SELECT * FROM acessos_players ORDER by total DESC LIMIT 10");
while ($dados_stats_player = mysqli_fetch_array($sql_stats_players)) {

$array_players_exclude = array("img","video","status.xsl?mount=","favicon.ico","funcoes-ajax-players","index");

if(!array_search($dados_stats_player["player"],$array_players_exclude)) {

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stats_player["player"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".number_format($dados_stats_player["total"] , 0, ',', '.')."</td>
</tr>";

}
}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_pagina_estatisticas_titulo_geral; ?></header>
                  </div>
                <div class="card-body">
                    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td width="130" height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_streamings; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_streamings; ?></td>
                                              </tr>
                                              <tr>
                                                <td width="129" height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_revendas; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_revendas; ?></td>
                                              </tr>
                                              <tr>
                                                <td width="129" height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_subrevendas; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_subrevendas; ?></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_servidores; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_servidores; ?></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_apps; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_apps; ?></td>
                                              </tr>
                                            </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
      <!-- modal -->                
        <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                  <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
              </div>
          </div>
        </div>

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/admin-streamings/resultado/"+document.getElementById("busca_chave").value;
    }
  }); 
  </script>
</body>
</html>