﻿<?php
require_once("inc/protecao-admin.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Administra&ccedil;&atilde;o</title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <link rel="stylesheet" href="/inc/theme.css">
  <link rel="shortcut icon" href="/img/favicon.png">
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <a class="navbar-brand brand-logo" href="/dashboard"><img src="/img/logo.png?<?php echo time();?>" alt="logo" style="width: auto; max-height: 50px;"></a>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><i class="fa fa-lock text-icones"></i></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item">
            <a class="nav-link" href="/" target="_blank"><i class="fa fa-eye f-22 text-success" data-toggle="tooltip" data-placement="bottom" title="Acessar Site"></i></a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/administrador"><i class="fa fa-user-circle-o f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Administrador"></i></a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="fa fa-sign-out f-22 text-danger" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-6">
              <div class="card">
                  <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                      <h4 class="card-title">Visitas Diárias Este M&ecirc;s</h4>
                    </div>
                    <div style="height: 250px;">
                      <canvas id="visitas_diarias"></canvas>
                    </div>
                  </div>
              </div>
            </div>           

            <div class="col-lg-6">
              <div class="card">
                  <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                      <h4 class="card-title">Visitas Mensal <?php echo date("Y");?></h4>
                    </div>
                    <div style="height: 250px;">
                      <canvas id="visitas_mensal"></canvas>
                    </div>
                  </div>
              </div>
            </div>           

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                      <h4 class="card-title">Visitas P&aacute;ginas</h4>
                    </div>
                    <table id="data_table" class="table dataTable no-footer table-hover" role="grid" aria-describedby="data_table_info">
                      <thead>
                        <tr role="row">
                            <th>P&aacute;gina</th>
                            <th style="width: 25%!important">Total Acessos</th>
                        </tr>
                      </thead>
                      <tbody>
<?php
$array_exclude = array("favicon.ico", "musica-atual", "chat-home", "historico-musicas", "musica-atual.php", "widget-lateral", "captcha", "img", "assets", "votar");

$sql = mysqli_query($conexao,"SELECT * FROM acessos_paginas ORDER by total DESC");
while ($dados_acesso = mysqli_fetch_array($sql)) {

if(!in_array($dados_acesso["pagina"], $array_exclude)) {

echo "<tr>
<td height='25' align='left' scope='col'><small>&nbsp;https://".$_SERVER['HTTP_HOST']."/".$dados_acesso["pagina"]."</small></td>
<td height='25' align='left' scope='col'><small>&nbsp;".$dados_acesso["total"]."</small></td>
</tr>";
}

}
?>
                      </tbody>
                    </table>
                  </div>
              </div>
            </div>  

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.7.1/chart.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/chartjs-plugin-datalabels/2.0.0/chartjs-plugin-datalabels.min.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
    var VisitasDiariasData = {
      labels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31],
      datasets: [{
        label: 'Total',
        data: [<?php
          for($i=1;$i<=31;$i++){
            $dia = sprintf("%02s",$i);
            $dados = mysqli_fetch_array(mysqli_query($conexao,"SELECT total FROM acessos WHERE DAY(data) = '".$dia."'"));
            $total .= $dados["total"].",";
          }
          echo substr($total, 0, -1);
          ?>],
        backgroundColor: '#464dee',
        borderColor: '#464dee',
        borderWidth: 0,
        fill: false
      }]
    };
    var VisitasMensalData = {
      labels: ["Jan", "Fev", "Mar", "Abr", "Mai", "Jun", "Jul", "Ago", "Set", "Out", "Nov", "Dez"],
      datasets: [{
        label: 'Total',
        data: [<?php
          for($i=1;$i<=12;$i++){
            $mes = sprintf("%02s",$i);
            $ano = date("Y");
            $dados = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(total) as total FROM acessos WHERE YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."'"));
            $total_mes .= $dados["total"].",";
          }
          echo substr($total_mes, 0, -1);
          ?>],
        backgroundColor: '#464dee',
        borderColor: '#464dee',
        borderWidth: 0,
        fill: false
      }]
    };
    var VisitasDiariasGrafico = $("#visitas_diarias").get(0).getContext("2d");
    var VisitasDiariasGraf = new Chart(VisitasDiariasGrafico, {type: 'bar',data: VisitasDiariasData,options: { responsive: true, maintainAspectRatio: false }});
    var VisitasMensalGrafico = $("#visitas_mensal").get(0).getContext("2d");
    var VisitasMensalGraf = new Chart(VisitasMensalGrafico, {type: 'bar',data: VisitasMensalData,options: { responsive: true, maintainAspectRatio: false }});
    </script>
</body>
</html>