<?php
ini_set("memory_limit", "256M");
ini_set("max_execution_time", 3600);
ini_set("date.timezone","America/Sao_Paulo");

require_once("".str_replace("/robots","",realpath(dirname(__FILE__)))."/admin/inc/conecta.php");
require_once("".str_replace("/robots","",realpath(dirname(__FILE__)))."/admin/inc/funcoes.php");
require_once("".str_replace("/robots","",realpath(dirname(__FILE__)))."/admin/inc/classe.ssh.php");

function tempo_exec_live($date){$first = new DateTime($date);$second = new DateTime("now");$diff = $first->diff( $second );$minutes = $diff->days * 24 * 60;$minutes += $diff->h * 60;$minutes += $diff->i;return $minutes;}

parse_str($argv[1],$opcoes);

list($inicial,$final) = explode("-",$opcoes["registros"]);

echo "[".date("d/m/Y H:i:s")."] Processo Iniciado.\n";

$data_atual_servidor = date("Y-m-d H:i");

$query = mysqli_query($conexao,"SELECT *, DATE_FORMAT(data_inicio,'%Y-%m-%d %H:%i') AS data_inicio, DATE_FORMAT(data_fim,'%Y-%m-%d %H:%i') AS data_fim FROM lives ORDER by codigo ASC LIMIT ".$inicial.", ".$final."");
while ($dados_live = mysqli_fetch_array($query)) {

$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_live["codigo_stm"]."'"));
$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

$data_atual = formatar_data("Y-m-d H:i", $data_atual_servidor, $dados_stm["timezone"]);

////////////////////////////
// Inicializao de lives //
////////////////////////////

if($dados_stm["status"] == 1 && $dados_servidor["status"] == "on") {

if($dados_live["status"] == 2 && $dados_live["data_inicio"] == $data_atual) {

// Conexao SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

$ssh->executar("mkdir -v /home/streaming/lives;echo OK");
$ssh->enviar_arquivo($_FILES["capa"]["tmp_name"],"/home/streaming/lives/capa-".$dados_stm["porta"]."-".$dados_live["codigo"].".jpg",0777);
$ssh->enviar_arquivo($_FILES["capa"]["tmp_name"],"/home/streaming/lives/capa-live-".$dados_stm["porta"]."-".$dados_live["codigo"].".jpg",0777);

$tiktok_kwai_instagram = ($dados_live["tipo"] == "tiktok" || $dados_live["tipo"] == "kwai" || $dados_live["tipo"] == "instagram") ? "-vf 'crop=ih*(9/16):ih' -crf 21" : "";

if($dados_live["exibir_cs"] == "sim") {

if($dados_live["cs_audio"] == "sim") {

$ssh->executar('echo OK;screen -dmS '.$dados_stm["porta"].'_'.$dados_live["codigo"].' bash -c \'/usr/local/bin/ffmpeg -re -stream_loop -1 -f image2 -thread_queue_size 4096 -i /home/streaming/lives/capa-'.$dados_stm["porta"].'-'.$dados_live["codigo"].'.jpg -i "'.$dados_live["cs_url"].'" '.$tiktok_kwai_instagram.' -filter_complex "[1]scale=iw*0.9:-1[wm];[0][wm]overlay=x=100:y=(H-h)/2" -r 24 -g 48 -x264-params keyint=48:min-keyint=48:scenecut=-1 -b:v 2048k -b:a 128k -ar 44100 -acodec aac -vcodec libx264 -color_range pc -preset superfast -bufsize 2048k -maxrate 3000k -crf 28 -threads 1 -f flv \''.$dados_live["servidor_live"].'\'; exec sh\'');


} else {

$ssh->executar('echo OK;screen -dmS '.$dados_stm["porta"].'_'.$dados_live["codigo"].' bash -c \'/usr/local/bin/ffmpeg -re -stream_loop -1 -f image2 -i /home/streaming/lives/capa-'.$dados_stm["porta"].'-'.$dados_live["codigo"].'.jpg -i "'.$dados_live["cs_url"].'" -filter_complex "[1]scale=iw*0.9:-1[wm];[0][wm]overlay=x=100:y=(H-h)/2" -i \''.$dados_live["servidor_stm"].'\' -r 24 -g 48 -x264-params keyint=48:min-keyint=48:scenecut=-1 -b:v 2048k -b:a 128k -ar 44100 -acodec aac -vcodec libx264 -color_range pc -preset superfast -bufsize 2048k -maxrate 3000k -crf 28 -threads 1 -f flv \''.$dados_live["servidor_live"].'\'; exec sh\'');

}

} else {

$ssh->executar('/usr/bin/php /home/streaming/lives/gerar-fundo-lives.php '.$dados_stm["porta"].'');

sleep(5);

$ssh->executar('echo OK;screen -dmS '.$dados_stm["porta"].'_'.$dados_live["codigo"].' bash -c "/usr/local/bin/ffmpeg -re -stream_loop -1 -framerate 2 -f image2 -thread_queue_size 4096 -i /home/streaming/lives/capa-live-'.$dados_stm["porta"].'-'.$dados_live["codigo"].'.jpg -thread_queue_size 4096 -i \''.$dados_live["servidor_stm"].'\' '.$tiktok_kwai_instagram.' -r 24 -g 48 -b:v 1024k -b:a 128k -ar 44100 -acodec aac -vcodec libx264 -color_range pc -preset superfast -bufsize 1024k -maxrate 1024k -crf 28 -threads 1 -f flv \''.$dados_live["servidor_live"].'\'; exec sh"');

}

sleep(5);

$resultado = $ssh->executar("/bin/ps aux | /bin/grep ffmpeg | /bin/grep http | /bin/grep ".$dados_stm["porta"]." | /bin/grep ".$dados_live["tipo"]." | /usr/bin/wc -l");

if($resultado > 0) {

if($dados_live["exibir_capa"] == "nao") {
  $ssh->executar("touch /home/streaming/lives/".$dados_stm["porta"].".lock;echo OK");
} else {
  $ssh->executar("rm -rfv /home/streaming/lives/".$dados_stm["porta"].".lock;echo OK");
}

echo "[".$dados_stm["porta"]."][".$data_atual_servidor."][".$dados_live["data_inicio"]."] Iniciando live ".$dados_live["tipo"]."\n";

// Atualiza status para transmitindo
mysqli_query($conexao,"Update lives set status = '1' where codigo = '".$dados_live["codigo"]."'");

} else {

echo "[".$dados_stm["porta"]."][".$data_atual_servidor."][".$dados_live["data_inicio"]."] Erro ao iniciar live ".$dados_live["tipo"]."\n";

// Atualiza status para transmitindo
mysqli_query($conexao,"Update lives set status = '3' where codigo = '".$dados_live["codigo"]."'");

} 

}

} // FIM -> Verifica se o streaming e servidor esta ON/OFF

//////////////////////////
// Finalizao de lives //
//////////////////////////
/*
if($dados_live["status"] == 1 && $dados_live["data_fim"] == $data_atual) {

// Conexao SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

$ssh->executar("echo OK;screen -ls | grep -o '[0-9]*\.".$dados_stm["porta"]."_".$dados_live["codigo"]."\>' | xargs -I{} screen -X -S {} quit");
$ssh->executar("echo OK;rm -fv /home/streaming/lives/capa-".$dados_stm["porta"]."*.jpg /home/streaming/lives/capa-live-".$dados_stm["porta"].".jpg");
$ssh->executar("echo OK;rm -fv /home/streaming/lives/".$dados_stm["porta"].".lock");

echo "[".$dados_stm["porta"]."][".$data_atual_servidor."][".$dados_live["data_fim"]."] Live ".$dados_live["tipo"]." finalizada.\n";

mysqli_query($conexao,"Update lives set status = '0' where codigo = '".$dados_live["codigo"]."'");
}
*/
////////////////////////////////////////////////////////
// Finalizao de lives com mais de 24hs de execusso //
////////////////////////////////////////////////////////
$tempo_exec = tempo_exec_live($dados_live["data_inicio"]);

if($dados_live["status"] == 1 && $tempo_exec > 500) {

// Conexao SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

$ssh->executar("echo OK;screen -ls | grep -o '[0-9]*\.".$dados_stm["porta"]."_".$dados_live["codigo"]."\>' | xargs -I{} screen -X -S {} quit");
$ssh->executar("echo OK;rm -fv /home/streaming/lives/capa-".$dados_stm["porta"]."*.jpg /home/streaming/lives/capa-live-".$dados_stm["porta"].".jpg");
$ssh->executar("echo OK;rm -fv /home/streaming/lives/".$dados_stm["porta"].".lock");

echo "[".$dados_stm["porta"]."][".$data_atual_servidor."][".$dados_live["data_fim"]."] Live ".$dados_live["tipo"]." finalizada por estar transmitindo a mais de 24hs.\n";

// Atualiza status para transmitindo
mysqli_query($conexao,"Update lives set status = '0' where codigo = '".$dados_live["codigo"]."'");

}

} // FIM -> while


// Remove registros de lives finalizadas a mais de 3 dias
$data_live_finalizada = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-3, date("Y")));
mysqli_query($conexao,"Delete From lives WHERE data_inicio < '".$data_live_finalizada."' AND status = 0");

echo "\n[".date("d/m/Y H:i:s")."] Processo Concludo.\n\n";

?>