<?php

// Função para ligar streaming
if($acao == "ligar_streaming") {

	$porta = code_decode(query_string('2'),"D");
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$porta."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".$lang['lang_alerta_manutencao_servidor']."</div>";
	exit();	
	}
	
	$status_streaming = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);
	
	if($status_streaming == "desligado") {

	$total_multipoint = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."'"));

	// IceCast
	if($dados_stm["tipo_servidor"] == "icecast") {

	$servidor = dominio_servidor($conexao,$dados_servidor["nome"]);
	$porta_dj_icecast = $dados_stm["porta"]+1;
	$icecast_publico = ($dados_stm["publicserver"] == "always") ? 1 : 0;

	$config_streaming .= "<icecast>\n";
	$config_streaming .= "<location>Streaming</location>\n";
	$config_streaming .= "<admin>no-reply@localhost</admin>\n";

	$config_streaming .= "<http-headers>\n";
	$config_streaming .= "<header name=\"Access-Control-Allow-Origin\" value=\"*\" />\n";
	$config_streaming .= "<header name=\"Access-Control-Allow-Headers\" value=\"Origin, Accept, X-Requested-With, Content-Type, If-Modified-Since\" />\n";
	$config_streaming .= "<header name=\"Access-Control-Allow-Methods\" value=\"GET, OPTIONS, HEAD\" />\n";
	$config_streaming .= "</http-headers>\n";

	$config_streaming .= "<limits>\n";
	$config_streaming .= "<clients>".$dados_stm["ouvintes"]."</clients>\n";
	$config_streaming .= "<sources>3</sources>\n";
	$config_streaming .= "<threadpool>5</threadpool>\n";
	$config_streaming .= "<queue-size>1048576</queue-size>\n";
	$config_streaming .= "<client-timeout>30</client-timeout>\n";
	$config_streaming .= "<header-timeout>15</header-timeout>\n";
	$config_streaming .= "<source-timeout>10</source-timeout>\n";
	$config_streaming .= "<burst-on-connect>1</burst-on-connect>\n";
	$config_streaming .= "<burst-size>128535</burst-size>\n";
	$config_streaming .= "</limits>\n";

	$config_streaming .= "<authentication>\n";
	$config_streaming .= "<source-password>".$dados_stm["senha"]."</source-password>\n";
	$config_streaming .= "<relay-password>".$dados_stm["senha"]."</relay-password>\n";
	$config_streaming .= "<admin-user>admin</admin-user>\n";
	$config_streaming .= "<admin-password>".$dados_stm["senha_admin"]."</admin-password>\n";
	$config_streaming .= "</authentication>\n";

	$config_streaming .= "<directory>\n";
	$config_streaming .= "<yp-url-timeout>15</yp-url-timeout>\n";
	$config_streaming .= "<yp-url>http://dir.xiph.org/cgi-bin/yp-cgi</yp-url>\n";
	$config_streaming .= "</directory>\n";

	$config_streaming .= "<hostname>".$servidor."</hostname>\n";
	$config_streaming .= "<listen-socket>\n";
	$config_streaming .= "<port>".$dados_stm["porta"]."</port>\n";
	$config_streaming .= "<ssl>1</ssl>\n";
	$config_streaming .= "</listen-socket>\n";
	$config_streaming .= "<listen-socket>\n";
	$config_streaming .= "<port>".$porta_dj_icecast."</port>\n";
	$config_streaming .= "</listen-socket>\n";
	$config_streaming .= "<bind-address>0.0.0.0</bind-address>\n";
	$config_streaming .= "<fileserve>1</fileserve>\n";

	if($total_multipoint > 0) {
	
		$sql_multipoint = mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."' ORDER by id ASC");
		while ($dados_ponto = mysqli_fetch_array($sql_multipoint)) {
		
			$config_streaming_multipoint .= "streamid_".$dados_ponto["id"]."=".$dados_ponto["id"]."\n";
			$config_streaming_multipoint .= "streampath_".$dados_ponto["id"]."=".$dados_ponto["ponto"]."\n";
			$config_streaming_multipoint .= "streammaxuser_".$dados_ponto["id"]."=".$dados_ponto["ouvintes"]."\n\n";

			$config_streaming .= "<mount>\n";
			$config_streaming .= "<mount-name>".$dados_ponto["ponto"]."</mount-name>\n";
			$config_streaming .= "<max-listeners>".$dados_ponto["ouvintes"]."</max-listeners>\n";
			$config_streaming .= "<public>".$icecast_publico."</public>\n";
			$config_streaming .= "</mount>\n";

		}
	
	} else {

		$config_streaming .= "<mount>\n";
		$config_streaming .= "<mount-name>/stream</mount-name>\n";
		$config_streaming .= "<public>".$icecast_publico."</public>\n";
		$config_streaming .= "</mount>\n";
	
	}
	
	$config_streaming .= "<paths>\n";
	$config_streaming .= "<basedir>/home/streaming/</basedir>\n";
	$config_streaming .= "<logdir>/home/streaming/logs</logdir>\n";
	$config_streaming .= "<webroot>/home/streaming/icecast/web</webroot>\n";
	$config_streaming .= "<adminroot>/home/streaming/icecast/admin</adminroot>\n";
	$config_streaming .= "<pidfile>/home/streaming/configs/".$dados_stm["porta"].".pid</pidfile>\n";
	$config_streaming .= "<deny-ip>/home/streaming/configs/".$dados_stm["porta"].".deny</deny-ip>\n";
	$config_streaming .= "<alias source='/' dest='/status.xsl'></alias>\n";
	$config_streaming .= "<ssl-certificate>/home/streaming/icecast/".strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"].".pem</ssl-certificate>\n";
	$config_streaming .= "</paths>\n";

	if($dados_stm["relay"] == "sim") {

	$relay_ponto = ($dados_stm["relay_ponto"]) ? $dados_stm["relay_ponto"] : "/stream";

	$config_streaming .= "<relay>\n";
	$config_streaming .= "<server>".$dados_stm["relay_ip"]."</server>\n";
	$config_streaming .= "<port>".$dados_stm["relay_porta"]."</port>\n";
	$config_streaming .= "<mount>".$relay_ponto."</mount>\n";
	$config_streaming .= "</relay>\n";
	}

	$config_streaming .= "<logging>\n";
	$config_streaming .= "<accesslog>log-".$dados_stm["porta"].".log</accesslog>\n";
	$config_streaming .= "<errorlog>log-".$dados_stm["porta"].".log</errorlog>\n";
	$config_streaming .= "<playlistlog>log-".$dados_stm["porta"].".log</playlistlog>\n";
	$config_streaming .= "<loglevel>3</loglevel>\n";
	$config_streaming .= "</logging>\n";

	$config_streaming .= "<security>\n";
	$config_streaming .= "<chroot>0</chroot>\n";
	$config_streaming .= "<changeowner>\n";
	$config_streaming .= "<user>streaming</user>\n";
	$config_streaming .= "<group>streaming</group>\n";
	$config_streaming .= "</changeowner>\n";
	$config_streaming .= "</security>\n";
	$config_streaming .= "</icecast>\n";

	} else {
	// Shoutcast
	
	if($total_multipoint > 0) {
	
	$sql_multipoint = mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."' ORDER by id ASC");
	while ($dados_ponto = mysqli_fetch_array($sql_multipoint)) {
	
	$config_streaming_multipoint .= "streamid_".$dados_ponto["id"]."=".$dados_ponto["id"]."\n";
	$config_streaming_multipoint .= "streampath_".$dados_ponto["id"]."=".$dados_ponto["ponto"]."\n";
	$config_streaming_multipoint .= "streammaxuser_".$dados_ponto["id"]."=".$dados_ponto["ouvintes"]."\n\n";

	}
	
	}
	
	$senha_admin = ($dados_stm["senha_admin"]) ? $dados_stm["senha_admin"] : microtime();
	
	$config_streaming = ";DADOS GERAIS\n";
	
	if($total_multipoint == 0) {
	$config_streaming .= "streamid=1\n";
	}
	
	$max_ouvintes = ($dados_stm["ouvintes"] == 999999) ? '0' : $dados_stm["ouvintes"];
	
	$config_streaming .= "portbase=".$dados_stm["porta"]."\n";
	$config_streaming .= "maxuser=".$max_ouvintes."\n";
	$config_streaming .= "adminpassword=".$senha_admin."\n";
	$config_streaming .= "password=".$dados_stm["senha"]."\n";
	$config_streaming .= "srcip=any\n";
	$config_streaming .= "destip=any\n";
	$config_streaming .= "namelookups=0\n";
	$config_streaming .= "publicserver=".$dados_stm["publicserver"]."\n";
	$config_streaming .= "allowrelay=".$dados_stm["allowrelay"]."\n";
	$config_streaming .= "allowpublicrelay=1\n";
	$config_streaming .= "metainterval=32768\n";
	$config_streaming .= ";LOGS\n";
	$config_streaming .= "logfile=/home/streaming/logs/log-".$dados_stm["porta"].".log\n";
	$config_streaming .= "banfile=/home/streaming/configs/".$dados_stm["porta"].".ban\n";
	$config_streaming .= "banfile=/home/streaming/configs/".$dados_stm["porta"].".agent\n";
	$config_streaming .= "flashpolicyfile=/home/streaming/configs/crossdomain.xml\n";
	$config_streaming .= "pidfile=/home/streaming/configs/".$dados_stm["porta"].".pid\n";
	$config_streaming .= "w3cenable=0\n";
	$config_streaming .= "logclients=1\n";
	$config_streaming .= "showlastsongs=".$dados_stm["showlastsongs"]."\n";
	$config_streaming .= ";YPSERVER\n";
	$config_streaming .= "ypaddr=46.105.114.166\n";
	$config_streaming .= "ypport=80\n";
	$config_streaming .= "ypPath=/yp2\n";
	$config_streaming .= "ypTimeout=10\n";
	$config_streaming .= "ypmaxretries=10\n";
	$config_streaming .= "ypreportinterval=3600\n";
	$config_streaming .= "ypminreportinterval=1800\n";
	$config_streaming .= "configrewrite=1\n";
	$config_streaming .= ";UPDATE\n";
	$config_streaming .= "cpucount=24\n";
	//$config_streaming .= "portlegacy=0\n";
	$config_streaming .= "maxbitrate=".$dados_stm["bitrate"]."000\n";
	$config_streaming .= ";SSL\n";
	$config_streaming .= "sslcertificatefile=/etc/letsencrypt/live/".strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"]."/fullchain.pem\n";
	$config_streaming .= "sslcertificatekeyfile=/etc/letsencrypt/live/".strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"]."/privkey.pem\n";
	
	if($dados_stm["arquivo_intro"]) {
	$config_streaming .= "introfile=/home/streaming/".$dados_stm["porta"]."/streaming_intro.mp3\n";
	}
	
	if($dados_stm["arquivo_backup"]) {
	$config_streaming .= "backupfile=/home/streaming/".$dados_stm["porta"]."/streaming_backup.mp3\n";
	}
	
	if($dados_stm["relay"] == "sim") {
	$config_streaming .= ";RELAY\n";
	$config_streaming .= "streamrelayurl=http://".$dados_stm["relay_ip"].":".$dados_stm["relay_porta"]."\n";
	$config_streaming .= "relayreconnecttime=1\n";	
	}
	
	if($total_multipoint > 0) {
	$config_streaming .= "\n;MULTI POINT\n";
	$config_streaming .= $config_streaming_multipoint;	
	}

	}
	
	$config_streaming = gerar_conf_streaming($dados_stm["porta"],$config_streaming);
	
	// Conexão SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->enviar_arquivo("/home/painel/public_html/temp/".$config_streaming."","/home/streaming/configs/".$config_streaming."",0777);
	
	unlink("/home/painel/public_html/temp/".$config_streaming."");

	if($dados_stm["tipo_servidor"] == "icecast") {
	$ssh->executar("ulimit -n 300000;/home/streaming/icecast/icecast -b -c /home/streaming/configs/".$config_streaming." > /dev/null & echo $!");
	} else {
	$ssh->executar("ulimit -n 300000;/home/streaming/sc_serv daemon /home/streaming/configs/".$config_streaming." > /dev/null & echo $!");
	}

	sleep(1);
	
	$status_streaming = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);
	
	if($status_streaming == "ligado") {
	
	if($dados_stm["autodj"] == "sim") {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_acao_ligar_stm_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_acao_ligar_stm_resultado_ok']."</div>";
	
	}
	
	// Insere a ação executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_ligar_stm_resultado_ok']."");
	
	} else {
	
	// Força desligamento do streaming por ter ocorrido erro ao ligar
	$ssh->executar("echo OK;/bin/ps aux | /bin/grep '\<".$dados_stm["porta"].".conf\>' | /bin/grep liquidsoap | /bin/awk '{ print $2;}' | /usr/bin/xargs /bin/kill -9");
	$ssh->executar("echo OK;/bin/ps aux | /bin/grep '\<".$dados_stm["porta"].".conf\>' | /bin/grep 'sc_serv\|icecast' | /bin/awk '{ print $2;}' | /usr/bin/xargs /bin/kill -9");
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_acao_ligar_stm_resultado_erro']."</div>";
	
	// Insere a ação executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_ligar_stm_resultado_erro']."");
	
	}
	
	} else {

	echo "<div class='alert alert-warning text-center' role='alert'>".$lang['lang_acao_ligar_stm_resultado_alerta']."</div>";
	
	// Insere a ação executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_ligar_stm_resultado_alerta']."");
	
	}
	
	exit();
}

// Função para desligar streaming
if($acao == "desligar_streaming") {

	// Proteção contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	monitoramento_ataques();
	die("<b>0x001 - Atenção! Acesso não autorizado, favor entrar em contato com nosso atendimento para maiores informações!</b>");
	}

	$porta = code_decode(query_string('2'),"D");
		
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$porta."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".$lang['lang_alerta_manutencao_servidor']."</div>";
	exit();	
	}
	
	// Conexão SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("echo OK;/bin/ps aux | /bin/grep '\<".$dados_stm["porta"].".conf\>' | /bin/grep 'sc_serv\|icecast' | /bin/awk '{ print $2;}' | /usr/bin/xargs /bin/kill -TERM");
	$ssh->executar("echo OK;/bin/ps aux | /bin/grep '\<autodj-".$dados_stm["porta"].".conf\>' | /bin/grep liquidsoap | /bin/awk '{ print $2;}' | /usr/bin/xargs /bin/kill -TERM");

	$status_streaming = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);
	
	if($status_streaming == "desligado") {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_acao_desligar_stm_resultado_ok']."</div>";
	
	// Insere a ação executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_desligar_stm_resultado_ok']."");
	
	} else {

	$ssh->executar("echo OK;/bin/ps aux | /bin/grep '\<".$dados_stm["porta"].".conf\>' | /bin/grep liquidsoap | /bin/awk '{ print $2;}' | /usr/bin/xargs /bin/kill -9");
	$ssh->executar("echo OK;/bin/ps aux | /bin/grep '\<".$dados_stm["porta"].".conf\>' | /bin/grep 'sc_serv\|icecast' | /bin/awk '{ print $2;}' | /usr/bin/xargs /bin/kill -9");
	
	$status_streaming = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);
	
	if($status_streaming == "desligado") {

	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_acao_desligar_stm_resultado_ok']."</div>";
	
	// Insere a ação executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_desligar_stm_resultado_ok']."");
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_acao_desligar_stm_resultado_erro']."</div>";
	
	// Insere a ação executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_desligar_stm_resultado_erro']."");
	
	}
	}
	
	exit();
}

// Função para verificar o status do streaming e autodj
if($acao == "status_streaming") {
	
	// Proteção contra sessão expirada
	if(empty($_SESSION["porta_logada"]) && empty($_SESSION["porta_logada_dj"])) {
	echo "Sess&atilde;o Expirada!|warning";
	exit();	
	}

	$porta = code_decode(query_string('2'),"D");
		
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$porta."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	$verificar_dj_conectado = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM djs WHERE codigo_stm = '".$dados_stm["codigo"]."' AND conectado = 'sim'"));
	$verificar_relay_conectado = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM relay_agendamentos WHERE codigo_stm = '".$dados_stm["codigo"]."' AND conectado = 'sim'"));
	
	if($dados_servidor["status"] == "off") {
	echo "".$lang['lang_info_status_manutencao']."|secondary";
	exit();
	}
	
	$status_conexao = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);

	if($dados_stm["tipo_servidor"] == "icecast") {
	$status_conexao_transmissao = status_streaming_transmissao_icecast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);
	} else {
	$status_conexao_transmissao = status_streaming_transmissao($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);
	}
	
	if($status_conexao_transmissao == "relay" || $verificar_relay_conectado > 0) {
	echo "".$lang['lang_info_status_transmitindo']."<br><small>".$lang['lang_info_status_relay']."</small>|info";
	exit();
	}

	if($status_conexao_transmissao == "autodj" && $verificar_dj_conectado > 0) {
	echo "".$lang['lang_info_status_transmitindo']."<br><small>".$lang['lang_info_status_autodj']." + ".$lang['lang_info_status_aovivo']."</small>|success";
	exit();
	}
	
	if($status_conexao_transmissao == "autodj") {
	echo "".$lang['lang_info_status_transmitindo']."<br><small>".$lang['lang_info_status_autodj']."</small>|success";
	exit();
	}
	
	if($status_conexao_transmissao == "aovivo") {
	echo "".$lang['lang_info_status_transmitindo']."<br><small>".$lang['lang_info_status_aovivo']."</small>|success";
	exit();
	}
	
	if($status_conexao == "ligado") {
	echo "".$lang['lang_info_status_ligado']."|success";
	exit();
	}
	
	echo "".$lang['lang_info_status_desligado']."|secondary";
	
	exit();
	
}

// Função para verificar o status do streaming e autodj
if($acao == "status_streaming_interno") {

	$porta = code_decode(query_string('2'),"D");
		
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$porta."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	$status_conexao = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);
	if($dados_stm["tipo_servidor"] == "icecast") {
	$status_conexao_autodj = status_autodj_icecast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);
	} else {
	$status_conexao_autodj = status_autodj($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha"]);
	}
	$status_conexao_relay = status_relay($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha"]);
	
	if($dados_servidor["status"] == "off") {
	echo "manutencao";
	exit();
	}
	
	if($status_conexao_relay == "ligado") {
	echo "ligado-relay";
	exit();
	}
	
	if($status_conexao_autodj == "ligado") {
	echo "ligado-autodj";
	exit();
	}
	
	if($status_conexao == "ligado" && $dados_stm["autodj"] == "nao") {
	echo "ligado-autodj-desativado";
	exit();
	}
	
	if($status_conexao == "ligado") {
	echo "ligado";
	exit();
	}
	
	echo "desligado";
	
	exit();
	
}


// Função para checar a quantidade de ouvintes online e criar a barra de porcentagem de uso
if($acao == "estatistica_uso_plano") {

	$porta = query_string('2');
	$recurso = query_string('3');
	$texto = query_string('4');
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$porta."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	$dados_servidor_aacplus = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor_aacplus"]."'"));
	$total_pontos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."'"));
	
	if($recurso == "ouvintes") {
	
	$status_streaming = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);
	
	if($status_streaming == "ligado") {

	if($dados_stm["tipo_servidor"] == "icecast") {

	$porta_admin_icecast = $dados_stm["porta"]+1;

	if($total_pontos > 0) {
		
	$sql_pontos = mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."' ORDER by id ASC");
	while ($dados_ponto = mysqli_fetch_array($sql_pontos)) {
		$json_icecast = utf8_encode(file_get_contents("http://".$dados_servidor["ip"].":".$porta_admin_icecast."/status-json.xsl?mount=".$dados_ponto["ponto"]));

		$stats_icecast = json_decode($json_icecast,TRUE);
		$ouvintes_conectados += $stats_icecast["icestats"]["source"]["listeners"];
	}
		
	} else {
		$json_icecast = utf8_encode(file_get_contents("http://".$dados_servidor["ip"].":".$porta_admin_icecast."/status-json.xsl?mount=/stream"));
		$stats_icecast = json_decode($json_icecast,TRUE);
		$ouvintes_conectados = $stats_icecast["icestats"]["source"]["listeners"];
	}

	} else {
	
	$xml_shoutcast = @simplexml_load_string(utf8_encode(@file_get_contents("http://".$dados_servidor["ip"].":".$dados_stm["porta"]."/stats")));
	$stats_shoutcast = json_decode(json_encode($xml_shoutcast),TRUE);
	$ouvintes_conectados = $stats_shoutcast["CURRENTLISTENERS"];

	}
	
	$porcentagem_uso_ouvintes = ($dados_stm["ouvintes"] == 0) ? "0" : $ouvintes_conectados*100/$dados_stm["ouvintes"];	
	$porcentagem_uso_ouvintes = ($porcentagem_uso_ouvintes < 1 && $ouvintes_conectados > 0) ? "1" : $porcentagem_uso_ouvintes;
	
	$modo_texto = ($texto == "sim") ? '<span class="texto_padrao_pequeno">('.str_replace("-","",$ouvintes_conectados).' de '.$dados_stm["ouvintes"].')</span>' : '';
	
	echo barra_uso_plano(str_replace("-","",$porcentagem_uso_ouvintes),'('.str_replace("-","",$ouvintes_conectados).' de '.$dados_stm["ouvintes"].')').'&nbsp;'.$modo_texto;
	
	} else { // Streaming desligado	
	echo barra_uso_plano(0,'(0 de '.$dados_stm["ouvintes"].')').'&nbsp;'.$modo_texto;
	}
		
	} else { // -> Recurso FTP
	
	$porcentagem_uso_espaco = ($dados_stm["espaco_usado"] == 0 || $dados_stm["espaco"] == 0) ? "0" : $dados_stm["espaco_usado"]*100/$dados_stm["espaco"];
	
	$modo_texto = ($texto == "sim") ? '<span class="texto_padrao_pequeno">('.tamanho($dados_stm["espaco_usado"]).' de '.tamanho($dados_stm["espaco"]).')</span>' : '';
	
	echo barra_uso_plano($porcentagem_uso_espaco,'('.tamanho($dados_stm["espaco_usado"]).' de '.tamanho($dados_stm["espaco"]).')').'&nbsp;'.$modo_texto;
	
	}
	
	exit();
}

// Função para exibir a música atual tocando no streaming
if($acao == "musica_atual") {

	// Proteção contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Atenção! Acesso não autorizado, favor entrar em contato com nosso atendimento para maiores informações!</b>");
	}
	
	$porta = query_string('2');
	$limite_caracteres = (query_string('3')) ? query_string('3') : 1000;
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$porta."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	if($dados_stm["tipo_servidor"] == "icecast") {

	$porta_admin_icecast = $dados_stm["porta"]+1;

	$dados_icecast = @file_get_contents("http://".$dados_servidor["ip"].":".$porta_admin_icecast."/status-json.xsl?mount=/stream");

	$dados_json_icecast = json_decode($dados_icecast, true);

	$musica = ($dados_json_icecast["icestats"]["source"]["artist"]) ? $dados_json_icecast["icestats"]["source"]["artist"]." - ".$dados_json_icecast["icestats"]["source"]["title"] : $dados_json_icecast["icestats"]["source"]["title"];

	} else {
	$musica = @file_get_contents("http://".$dados_servidor["ip"].":".$dados_stm["porta"]."/currentsong?sid=1");
	}
	
	$musica = ucwords(strtolower($musica));

	$musica = utf8_decode($musica);
	
	if(strlen($musica) > $limite_caracteres) {
	echo "<img src='/img/icones/img-icone-arquivo-musica.png' border='0' align='absmiddle' />&nbsp;".substr($musica, 0, $limite_caracteres)."...";
	} else {
	echo "<img src='/img/icones/img-icone-arquivo-musica.png' border='0' align='absmiddle' />&nbsp;".$musica;
	}
	
	exit();
	
}

// Função para exibir a música atual tocando no streaming
if($acao == "capa_musica_atual") {

	// Proteção contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Atenção! Acesso não autorizado, favor entrar em contato com nosso atendimento para maiores informações!</b>");
	}
	
	$porta = query_string('2');
	
	$dados_config = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM configuracoes"));
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$porta."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	$host_sources = ($dados_config["usar_cdn"] == "sim") ? $dados_config["dominio_cdn"] : $_SERVER['HTTP_HOST'];
	
	if($dados_stm["tipo_servidor"] == "icecast") {

	$porta_admin_icecast = $dados_stm["porta"]+1;

	$dados_icecast = @file_get_contents("http://".$dados_servidor["ip"].":".$porta_admin_icecast."/status-json.xsl?mount=/stream");

	$dados_json_icecast = json_decode($dados_icecast, true);

	$musica = ($dados_json_icecast["icestats"]["source"]["artist"]) ? $dados_json_icecast["icestats"]["source"]["artist"]." - ".$dados_json_icecast["icestats"]["source"]["title"] : $dados_json_icecast["icestats"]["source"]["title"];

	} else {
	$musica = @file_get_contents("http://".$dados_servidor["ip"].":".$dados_stm["porta"]."/currentsong?sid=1");
	}

	$musica_partes = explode("-",$musica);	

	$artista = str_replace("_"," ",$musica_partes[0]);
	$artista = rtrim($artista, " \t.");
	
	$musica = $musica_partes[1];

	$resultado_api_lastfm_vagalume = lastfm('artist',$artista);
	
	if($resultado_api_lastfm_vagalume["status"] == "ok") {
	$imagem = $resultado_api_lastfm_vagalume["imagem"];
	} else {
	$resultado_api_lastfm_vagalume = vagalumeapi('capa2',$artista,$musica);
	}
	
	if($resultado_api_lastfm_vagalume["status"] == "ok") {
	$imagem = $resultado_api_lastfm_vagalume["imagem"];
	} else {
	$resultado_api_lastfm_vagalume = vagalumeapi('capa1',$artista,'');
	}

	if($resultado_api_lastfm_vagalume["status"] == "ok") {
	echo $imagem = $resultado_api_lastfm_vagalume["imagem"];
	} else {
	echo "/img/img-capa-artista-padrao.png";
	}
	
	exit();
	
}