<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

$estatistica = query_string('1');
$exibir = query_string('2');
$mes = query_string('3');
$ano = query_string('4');

$total_ouvintes_db = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));
$total_ouvintes_unicos_db = mysqli_num_rows(mysqli_query($conexao,"SELECT DISTINCT ip FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));
$tempo_conectado = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));

$average_ouvintes  = $tempo_conectado["total_tempo"]/$tempo_conectado["total_registros"];

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Streaming <?php echo $dados_stm["porta"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <?php if($dados_stm["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
  <script type="text/javascript" src="/inc/javascript.js"></script>  
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script src="https://code.highcharts.com/highcharts.js"></script>
  <script src="https://code.highcharts.com/highcharts-3d.js"></script>
  <script src="https://code.highcharts.com/modules/exporting.js"></script>
  <style type="text/css">@media print{.no-print{display:none}}.rotate_45{-webkit-transform:rotate(-45deg);-moz-transform:rotate(-45deg);-ms-transform:rotate(-45deg);-o-transform:rotate(-45deg)}.rotate_90{-webkit-transform:rotate(-90deg);-moz-transform:rotate(-90deg);-ms-transform:rotate(-90deg);-o-transform:rotate(-90deg)}</style>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Painel Streaming</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown show">
            <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" id="profileDropdown" aria-expanded="true">
              <i class="fa fa-power-off f-18 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_botao_titulo_ligar']; ?>/<?php echo $lang['lang_botao_titulo_desligar']; ?>"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown" aria-labelledby="profileDropdown">
              <a class="dropdown-item text-success" href="javascript:ligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> Streaming</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> Streaming</a>
              <?php if($dados_stm["autodj"] == "sim") { ?>
              <div class="dropdown-divider"></div>              
              <a class="dropdown-item text-success" href="javascript:carregar_opcoes_ligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> AutoDJ</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> AutoDJ</a>
              <?php } ?>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_streaming($conexao,$dados_stm["porta"],$dados_servidor["codigo"]); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
          <li>
            <button type="button" class="btn btn-info" id="status-streaming" onClick="status_streaming('<?php echo $porta_code; ?>');" style="margin: 10px;min-width: 150px; min-height: 40px"><i class="fa fa-refresh"></i></button>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

             <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_estatisticas_registros_tab_titulo']; ?></header>
                                    </div>
                                    <div class="card-body">
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                              <td width="25%" height="70" align="center"><i class='fa fa-users icon-lg text-icones'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-user icon-lg text-icones'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-bar-chart-o icon-lg text-icones'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-clock-o icon-lg text-icones'></i></td>
                                            </tr>
                                            <tr>
                                              <td height="30" align="center"><strong><?php echo $total_ouvintes_db; ?></strong><br /><small><?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></small></td>
                                              <td align="center"><strong><?php echo $total_ouvintes_unicos_db; ?></strong><br /><small><?php echo $lang['lang_info_estatisticas_total_ouvintes_unicos']; ?></small></td>
                                              <td align="center"><strong><?php echo $total_ouvintes_db; ?></strong><br /><small><?php echo $lang['lang_info_estatisticas_total_ouvintes_pico']; ?></small></td>
                                              <td align="center"><strong><?php echo seconds2time($average_ouvintes); ?></strong><br /><small><?php echo $lang['lang_info_estatisticas_total_ouvintes_tempo_conectados']; ?></small></td>
                                            </tr>
                                          </table>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_estatisticas_grafico_periodo_tab_titulo']; ?></header>
                                    </div>
                                    <div class="card-body">
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                              <td colspan="4" align="center"><select name="estatistica" class="input" id="estatistica" style="width:220px;height:30px" onChange="tipo_estatistica(this.value);">
                                              <optgroup label="<?php echo $lang['lang_info_estatisticas_periodo_graficos']; ?>">
                                      <option value="1"><?php echo $lang['lang_info_estatisticas_estatistica_ouvintes_dia']; ?></option>
                                      <option value="2"><?php echo $lang['lang_info_estatisticas_estatistica_ouvintes_ano']; ?></option>
                                      <option value="3"><?php echo $lang['lang_info_estatisticas_grafico_tempo_medio_conectado']; ?></option>
                                      <option value="4"><?php echo $lang['lang_info_estatisticas_grafico_localidade']; ?></option>
                                      <option value="5"><?php echo $lang['lang_info_estatisticas_grafico_players']; ?></option>
                                      <option value="6"><?php echo $lang['lang_info_estatisticas_grafico_ouvintes_hora']; ?></option>
                                      </optgroup>
                                    </select>&nbsp;<select name="mes" class="input" id="mes" style="width:220px;height:30px">
                                              <optgroup label="<?php echo $lang['lang_info_estatisticas_periodo_meses']; ?>">
                                              <option value="todos">Anual(texto)</option>
                                      <option value="01" <?php if(date("m") == '01') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_01']; ?></option>
                                      <option value="02" <?php if(date("m") == '02') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_02']; ?></option>
                                      <option value="03" <?php if(date("m") == '03') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_03']; ?></option>
                                      <option value="04" <?php if(date("m") == '04') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_04']; ?></option>
                                      <option value="05" <?php if(date("m") == '05') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_05']; ?></option>
                                      <option value="06" <?php if(date("m") == '06') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_06']; ?></option>
                                      <option value="07" <?php if(date("m") == '07') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_07']; ?></option>
                                      <option value="08" <?php if(date("m") == '08') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_08']; ?></option>
                                      <option value="09" <?php if(date("m") == '09') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_09']; ?></option>
                                      <option value="10" <?php if(date("m") == '10') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_10']; ?></option>
                                      <option value="11" <?php if(date("m") == '11') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_11']; ?></option>
                                      <option value="12" <?php if(date("m") == '12') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_12']; ?></option>
                                      </optgroup>
                                    </select>&nbsp;<select name="ano" class="input" id="ano" style="width:150px;height:30px">
                                              <optgroup label="<?php echo $lang['lang_info_estatisticas_periodo_anos']; ?>">
                                        <?php
                                            $ano_inicial = date("Y")-1;
                                            $ano_final = date("Y")+1;
                                            $qtd = $ano_final-$ano_inicial;
                                                for($i=0; $i <= $qtd; $i++) {
                                                        if(sprintf("%02s",$ano_inicial+$i) == date("Y")) {
                                                            echo "<option value=\"".sprintf("%02s",$ano_inicial+$i)."\" selected=\"selected\">".sprintf("%02s",$ano_inicial+$i)."</option>\n";
                                                        } else {
                                                            echo "<option value=\"".sprintf("%02s",$ano_inicial+$i)."\">".sprintf("%02s",$ano_inicial+$i)."</option>\n";
                                                        }
                                                }
                                        ?>
                                        </optgroup>
                                    </select>&nbsp;<select name="exibir" class="input" id="exibir" style="width:100px;height:30px">
                                              <optgroup label="Exibi&ccedil;&atilde;o">
                                                <option value="grafico">Gr&aacute;fico</option>
                                                <option value="texto">Texto</option>
                                            </optgroup>
                                    </select>&nbsp;<button type="button" class="btn btn-info" onClick="window.location = '/estatisticas/'+document.getElementById('estatistica').value+'/'+document.getElementById('exibir').value+'/'+document.getElementById('mes').value+'/'+document.getElementById('ano').value+'';"><?php echo $lang['lang_botao_titulo_visualizar']; ?></button></td>
                                            </tr>
                                          </table>
                                    </div>
                                </div>
                            </div>
                            <?php if($estatistica) { ?>
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body">
                                        
                                        <?php if($estatistica == "1" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_ouvintes_dia',
                                                        type: 'area'
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?>'
                                                    },
                                                    subtitle: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano; ?>'
                                                    },
                                                    xAxis: {
                                                        categories: [
                                                        <?php
                                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");
                                                        
                                                        for($i=1;$i<=$array_dias_meses[$mes];$i++){
                                                        
                                                        $dias .= sprintf("%02s",$i).",";

                                                        }
                                                        
                                                        echo substr($dias, 0, -1);          
                                                        ?>              
                                                        ],
                                                        tickmarkPlacement: 'on',
                                                        title: {
                                                            enabled: false
                                                        }
                                                    },
                                                    yAxis: {
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?>'
                                                        },
                                                        labels: {
                                                            formatter: function() {
                                                                return this.value;
                                                            }
                                                        }
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return ''+
                                                                this.x +'/<?php echo $mes;?>/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_ouvintes']; ?>';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        area: {
                                                            stacking: 'normal',
                                                            lineColor: '#666666',
                                                            lineWidth: 1,
                                                            cursor: 'pointer',
                                                            marker: {
                                                                lineWidth: 1,
                                                                lineColor: '#666666',
                                                                enabled: false,
                                                                symbol: 'circle',
                                                                radius: 2,
                                                                states: {
                                                                    hover: {
                                                                    enabled: true
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    series: [{
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_dia']; ?>',
                                                        data: [
                                                        <?php
                                                        
                                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){
                                                        
                                                        $dia = sprintf("%02s",$i);
                                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                                        $total_ouvintes_mes = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));
                                                        
                                                        echo $total_ouvintes_mes.",";
                                                        echo "\n";
                                                        
                                                        }
                                                        ?>
                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <center><div id="grafico_ouvintes_dia" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "2" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_ouvintes_ano',
                                                        type: 'area'
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_ano']; ?>'
                                                    },
                                                    subtitle: {
                                                        text: '<?php echo $ano; ?>'
                                                    },
                                                    xAxis: {
                                                        categories: [
                                                        <?php
                                                        echo "'".$lang['lang_info_estatisticas_periodo_01']."','".$lang['lang_info_estatisticas_periodo_02']."','".$lang['lang_info_estatisticas_periodo_03']."','".$lang['lang_info_estatisticas_periodo_04']."','".$lang['lang_info_estatisticas_periodo_05']."','".$lang['lang_info_estatisticas_periodo_06']."','".$lang['lang_info_estatisticas_periodo_07']."','".$lang['lang_info_estatisticas_periodo_08']."','".$lang['lang_info_estatisticas_periodo_09']."','".$lang['lang_info_estatisticas_periodo_10']."','".$lang['lang_info_estatisticas_periodo_11']."','".$lang['lang_info_estatisticas_periodo_12']."'";
                                                        ?>              
                                                        ],
                                                        tickmarkPlacement: 'on',
                                                        title: {
                                                            enabled: false
                                                        }
                                                    },
                                                    yAxis: {
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?>'
                                                        },
                                                        labels: {
                                                            formatter: function() {
                                                                return this.value;
                                                            }
                                                        }
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return ''+
                                                                this.x +'/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_ouvintes']; ?>';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        area: {
                                                            stacking: 'normal',
                                                            lineColor: '#666666',
                                                            lineWidth: 1,
                                                            cursor: 'pointer',
                                                            marker: {
                                                                lineWidth: 1,
                                                                lineColor: '#666666',
                                                                enabled: false,
                                                                symbol: 'circle',
                                                                radius: 2,
                                                                states: {
                                                                    hover: {
                                                                    enabled: true
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    series: [{
                                                        name: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?>',
                                                        data: [
                                                        <?php
                                                        
                                                        $array_meses_ano = array("01","02","03","04","05","06","07","08","09","10","11","12");
                                                        
                                                        foreach($array_meses_ano as $mes_ano) {
                                                        
                                                        $mes_ano = sprintf("%02s",$mes_ano);
                                                        
                                                        $total_ouvintes_ano = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes_ano."'"));
                                                        
                                                        $total_ouvintes_meses .= $total_ouvintes_ano.",";
                                                        
                                                        }
                                                        echo substr($total_ouvintes_meses, 0, -1);  
                                                        ?>
                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <center><div id="grafico_ouvintes_ano" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "3" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_ouvintes_tempo_conectado',
                                                        type: 'area'
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_grafico_ouvintes_tempo_conectado_tab_titulo']; ?>'
                                                    },
                                                    subtitle: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano;?>'
                                                    },
                                                    xAxis: {
                                                        categories: [
                                                        <?php
                                                        $array_dias_meses = array("01" => "31", "02" => "28", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");
                                                        
                                                        for($i=1;$i<=$array_dias_meses[$mes];$i++){
                                                        
                                                        $dias .= sprintf("%02s",$i).",";

                                                        }
                                                        
                                                        echo substr($dias, 0, -1);          
                                                        ?>              
                                                        ],
                                                        tickmarkPlacement: 'on',
                                                        title: {
                                                            enabled: false
                                                        }
                                                    },
                                                    yAxis: {
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_tempo_conectado_minutos']; ?>'
                                                        },
                                                        labels: {
                                                            formatter: function() {
                                                                return this.value;
                                                            }
                                                        }
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return ''+
                                                                this.x +'/<?php echo $mes;?>/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_minutos']; ?>';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        area: {
                                                            stacking: 'normal',
                                                            lineColor: '#666666',
                                                            lineWidth: 1,
                                                            cursor: 'pointer',
                                                            marker: {
                                                                lineWidth: 1,
                                                                lineColor: '#666666',
                                                                enabled: false,
                                                                symbol: 'circle',
                                                                radius: 2,
                                                                states: {
                                                                    hover: {
                                                                    enabled: true
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    series: [{
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_tempo_conectado_minutos']; ?>',
                                                        data: [
                                                        <?php
                                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){
                                                        
                                                        $dia = sprintf("%02s",$i);
                                                        
                                                        $data = $ano."-".$mes."-".$dia;

                                                        
                                                        $tempo_conectado_stat = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));
                                                        
                                                        $media = ($tempo_conectado_stat["total_registros"] > 0) ? $tempo_conectado_stat["total_tempo"]/$tempo_conectado_stat["total_registros"] : '0';
                                                        
                                                        echo date('i',mktime(0,0,$media,15,03,2013)).",";
                                                        echo "\n";
                                                        
                                                        }
                                                        ?>
                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });

                                        </script>
                                        <center><div id="grafico_ouvintes_tempo_conectado" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "4" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_paises',
                                                        type: 'pie',
                                                            options3d: {
                                                                enabled: true,
                                                                alpha: 45,
                                                                beta: 0
                                                            }
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_paises']; ?>'
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        pie: {
                                                            allowPointSelect: true,
                                                            cursor: 'pointer',
                                                            depth: 35,
                                                            dataLabels: {
                                                                enabled: true
                                                            },
                                                            showInLegend: true
                                                        }
                                                    },
                                                    series: [{
                                                        type: 'pie',
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_paises']; ?>',
                                                        data: [
                                                        
                                                        <?php
                                                        
                                                        $sql_paises = mysqli_query($conexao,"SELECT distinct(pais) as pais, count(pais) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' GROUP by pais ORDER by total DESC LIMIT 5");
                                                        while ($dados_pais_ip = mysqli_fetch_array($sql_paises)) {

                                                        if($dados_pais_ip["total"] > 1) {
                                                        
                                                        echo "['".$dados_pais_ip["pais"]."', ".$dados_pais_ip["total"]."],";
                                                        echo "\n";

                                                        }

                                                        }
                                                        
                                                        ?>

                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_estados',
                                                        type: 'pie',
                                                            options3d: {
                                                                enabled: true,
                                                                alpha: 45,
                                                                beta: 0
                                                            }
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_estados']; ?>'
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        pie: {
                                                            allowPointSelect: true,
                                                            cursor: 'pointer',
                                                            depth: 35,
                                                            dataLabels: {
                                                                enabled: true
                                                            },
                                                            showInLegend: true
                                                        }
                                                    },
                                                    series: [{
                                                        type: 'pie',
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_estados']; ?>',
                                                        data: [
                                                        
                                                        <?php
                                                        
                                                        $sql_estados = mysqli_query($conexao,"SELECT distinct(estado) as estado, count(estado) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND estado != '' GROUP by estado ORDER by total DESC LIMIT 6");
                                                        while ($dados_stat_estado = mysqli_fetch_array($sql_estados)) {

                                                        if($dados_stat_estado["total"] > 1) {
                                                        
                                                        echo "['".$dados_stat_estado["estado"]."', ".$dados_stat_estado["total"]."],";
                                                        echo "\n";

                                                        }

                                                        }
                                                        
                                                        ?>

                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_cidades',
                                                        type: 'pie',
                                                            options3d: {
                                                                enabled: true,
                                                                alpha: 45,
                                                                beta: 0
                                                            }
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_cidades']; ?>'
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        pie: {
                                                            allowPointSelect: true,
                                                            cursor: 'pointer',
                                                            depth: 35,
                                                            dataLabels: {
                                                                enabled: true
                                                            },
                                                            showInLegend: true
                                                        }
                                                    },
                                                    series: [{
                                                        type: 'pie',
                                                        data: [
                                                        
                                                        <?php
                                                        
                                                        $sql_cidades = mysqli_query($conexao,"SELECT distinct(cidade) as cidade, count(cidade) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND cidade != '' GROUP by cidade ORDER by total DESC LIMIT 6");
                                                        while ($dados_stat_cidade = mysqli_fetch_array($sql_cidades)) {

                                                        if($dados_stat_cidade["total"] > 0) {
                                                        
                                                        echo "['".$dados_stat_cidade["cidade"]."', ".$dados_stat_cidade["total"]."],";
                                                        echo "\n";

                                                        }

                                                        }
                                                        
                                                        ?>

                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <center><div id="grafico_paises" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <br /><br />
                                        <center><div id="grafico_estados" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <br /><br />
                                        <center><div id="grafico_cidades" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "5" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_players',
                                                        type: 'pie',
                                                            options3d: {
                                                                enabled: true,
                                                                alpha: 45,
                                                                beta: 0
                                                            }
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_players']; ?>'
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        pie: {
                                                            allowPointSelect: true,
                                                            cursor: 'pointer',
                                                            depth: 35,
                                                            dataLabels: {
                                                                enabled: true
                                                            },
                                                            showInLegend: true
                                                        }
                                                    },
                                                    series: [{
                                                        type: 'pie',
                                                        data: [
                                                        
                                                        <?php
                                                        
                                                        $sql_players = mysqli_query($conexao,"SELECT distinct(player) as player, count(player) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND player != '' GROUP by player ORDER by total DESC LIMIT 6");
                                                        while ($dados_player = mysqli_fetch_array($sql_players)) {

                                                        if($dados_player["total"] > 0) {
                                                        
                                                        echo "['".$dados_player["player"]."', ".$dados_player["total"]."],";
                                                        echo "\n";

                                                        }

                                                        }
                                                        
                                                        ?>

                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <center><div id="grafico_players" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "6" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_ouvintes_tempo_conectado_hora',
                                                        type: 'area'
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_grafico_ouvintes_hora_tab_titulo']; // Ouvintes Conectados por Hora ?>'
                                                    },
                                                    subtitle: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano;?>'
                                                    },
                                                    xAxis: {
                                                        categories: ['00:00-00:59','01:00-01:59','02:00-02:59','03:00-03:59','04:00-04:59','05:00-05:59','06:00-06:59','07:00-07:59','08:00-08:59','09:00-09:59','10:00-10:59','11:00-11:59','12:00-12:59','13:00-13:59','14:00-14:59','15:00-15:59','16:00-16:59','17:00-17:59','18:00-18:59','19:00-19:59','20:00-20:59','21:00-21:59','22:00-22:59','23:00-23:59'],
                                                        tickmarkPlacement: 'on',
                                                    },
                                                    yAxis: {
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; // Total de Ouvintes ?>'
                                                        },
                                                        labels: {
                                                            formatter: function() {
                                                                return this.value;
                                                            }
                                                        }
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return ''+this.x+': '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_ouvintes']; // ouvinte(s) ?>';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        area: {
                                                            stacking: 'normal',
                                                            lineColor: '#666666',
                                                            lineWidth: 1,
                                                            cursor: 'pointer',
                                                            marker: {
                                                                lineWidth: 1,
                                                                lineColor: '#666666',
                                                                enabled: false,
                                                                symbol: 'circle',
                                                                radius: 2,
                                                                states: {
                                                                    hover: {
                                                                    enabled: true
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    series: [{
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_ano']; ?>',
                                                        data: [<?php
                                                        
                                                        for($i=0;$i<=23;$i++){
                                                        
                                                        $hora = sprintf("%02s",$i);
                                                        
                                                        $total_ouvintes = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data,hora FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND HOUR(hora) = '".$hora."'"));
                                                        
                                                        $array_total_ouvintes .= $total_ouvintes.",";
                                                        
                                                        }
                                                        echo substr($array_total_ouvintes, 0, -1);  
                                                        
                                                        unset($array_total_ouvintes);
                                                        unset($total_ouvintes);
                                                        ?>]
                                                    }]
                                                });
                                            });
                                            
                                        });

                                        </script>
                                        <center><div id="grafico_ouvintes_tempo_conectado_hora" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "1" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td colspan="4" align="center">
                                        <?php if(is_numeric($mes)) { ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="40" align="center" class="texto_padrao_vermelho_destaque" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br><span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              01</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              02</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              03</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              04</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              05</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              06</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              07</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              08</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              09</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              10</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              11</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              12</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              13</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              14</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              15</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              16</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              17</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              18</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              19</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              20</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              21</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              22</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              23</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              24</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              25</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              26</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              27</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              28</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              29</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              30</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              31</td>
                                          </tr>
                                          <tr>
                                            <td height="25" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        // Mes especifico

                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");

                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){

                                        $dia = sprintf("%02s",$i);          
                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                        $total_ouvintes_dia = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $total_ouvintes_dia; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <?php } else { ?>

                                        <?php
                                        // Todos os meses
                                        for($iMes=1;$iMes<=date("m");$iMes++){

                                        $mes = sprintf("%02s",$iMes);   
                                        ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="40" align="center" class="texto_padrao_vermelho_destaque" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br><span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              01</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              02</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              03</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              04</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              05</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              06</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              07</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              08</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              09</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              10</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              11</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              12</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              13</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              14</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              15</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              16</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              17</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              18</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              19</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              20</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              21</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              22</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              23</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              24</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              25</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              26</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              27</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              28</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              29</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              30</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              31</td>
                                          </tr>
                                          <tr>
                                            <td height="25" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");

                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){

                                        $dia = sprintf("%02s",$i);          
                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                        $total_ouvintes_dia = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $total_ouvintes_dia; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <?php } ?>
                                        <?php } ?>
                                        </td>
                                        </tr>
                                        </table>
                                        <?php } else if($estatistica == "2" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $ano; ?></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_01']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_02']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_03']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_04']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_05']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_06']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_07']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_08']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_09']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_10']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_11']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_12']; ?></div></td>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $array_meses_ano = array("01","02","03","04","05","06","07","08","09","10","11","12");
                                                        
                                        foreach($array_meses_ano as $mes_ano) {
                                                        
                                        $mes_ano = sprintf("%02s",$mes_ano);
                                                        
                                        $total_ouvintes_mes = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes_ano."'"));

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $total_ouvintes_mes; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                                          </td>
                                                        </tr>
                                                      </table>
                                        <?php } else if($estatistica == "3" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <?php if(is_numeric($mes)) { ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="40" align="center" class="texto_padrao_vermelho_destaque" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br><span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              01</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              02</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              03</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              04</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              05</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              06</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              07</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              08</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              09</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              10</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              11</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              12</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              13</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              14</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              15</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              16</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              17</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              18</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              19</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              20</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              21</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              22</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              23</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              24</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              25</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              26</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              27</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              28</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              29</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              30</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              31</td>
                                          </tr>
                                          <tr>
                                            <td height="25" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo ucfirst($lang['lang_info_estatisticas_legenda_minutos']); ?></td>
                                        <?php
                                        // Mes especifico

                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");

                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){

                                        $dia = sprintf("%02s",$i);          
                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                        $tempo_conectado_stat = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));
                                                        
                                        $media = ($tempo_conectado_stat["total_registros"] > 0) ? $tempo_conectado_stat["total_tempo"]/$tempo_conectado_stat["total_registros"] : '0';

                                        $media = $media/60;

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo round($media); ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <?php } else { ?>

                                        <?php
                                        // Todos os meses
                                        for($iMes=1;$iMes<=date("m");$iMes++){

                                        $mes = sprintf("%02s",$iMes);   
                                        ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="40" align="center" class="texto_padrao_vermelho_destaque" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br><span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              01</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              02</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              03</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              04</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              05</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              06</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              07</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              08</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              09</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              10</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              11</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              12</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              13</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              14</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              15</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              16</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              17</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              18</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              19</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              20</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              21</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              22</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              23</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              24</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              25</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              26</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              27</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              28</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              29</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              30</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              31</td>
                                          </tr>
                                          <tr>
                                            <td height="25" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo ucfirst($lang['lang_info_estatisticas_legenda_minutos']); ?></td>
                                        <?php
                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");

                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){

                                        $dia = sprintf("%02s",$i);          
                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                        $tempo_conectado_stat = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));
                                                        
                                        $media = ($tempo_conectado_stat["total_registros"] > 0) ? $tempo_conectado_stat["total_tempo"]/$tempo_conectado_stat["total_registros"] : '0';

                                        $media = $media/60;

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo round($media); ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <?php } ?>
                                        <?php } ?>
                                                        </td>
                                                        </tr>
                                                      </table>
                                        <?php } else if($estatistica == "4" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_info_stats_paises']; ?></td>
                                        <?php
                                        $sql_paises = mysqli_query($conexao,"SELECT distinct(pais) as pais, count(pais) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND pais != 'Not found' GROUP by pais ORDER by pais ASC LIMIT 10");
                                        while ($dados_pais_ip = mysqli_fetch_array($sql_paises)) {

                                        if($dados_pais_ip["total"] > 1) {

                                        $pais = ($dados_pais_ip["pais"]) ? $dados_pais_ip["pais"] : "Not found";

                                        ?>
                                        <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $pais; ?></div></td>
                                        <?php } ?>
                                        <?php } ?>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $sql_paises = mysqli_query($conexao,"SELECT distinct(pais) as pais, count(pais) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND pais != 'Not found' GROUP by pais ORDER by codigo ASC LIMIT 10");
                                        while ($dados_pais_ip = mysqli_fetch_array($sql_paises)) {

                                        if($dados_pais_ip["total"] > 1) {

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $dados_pais_ip["total"]; ?></td>
                                        <?php } ?>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_info_stats_estados']; ?></td>
                                        <?php
                                        $sql_estados = mysqli_query($conexao,"SELECT distinct(estado) as estado, count(estado) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND estado != 'Not found' GROUP by estado ORDER by codigo ASC LIMIT 10");
                                        while ($dados_estado_ip = mysqli_fetch_array($sql_estados)) {

                                        if($dados_estado_ip["total"] > 1) {

                                        $estado = ($dados_estado_ip["estado"]) ? $dados_estado_ip["estado"] : "Not found";

                                        ?>
                                        <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $estado; ?></div></td>
                                        <?php } ?>
                                        <?php } ?>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $sql_estados = mysqli_query($conexao,"SELECT distinct(estado) as estado, count(estado) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND estado != 'Not found' GROUP by estado ORDER by codigo ASC LIMIT 10");
                                        while ($dados_estado_ip = mysqli_fetch_array($sql_estados)) {

                                        if($dados_estado_ip["total"] > 1) {

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $dados_estado_ip["total"]; ?></td>
                                        <?php } ?>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_info_stats_cidades']; ?></td>
                                        <?php
                                        $sql_cidades = mysqli_query($conexao,"SELECT distinct(cidade) as cidade, count(cidade) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND cidade != 'Not found' GROUP by cidade ORDER by codigo ASC LIMIT 10");
                                        while ($dados_cidade_ip = mysqli_fetch_array($sql_cidades)) {

                                        if($dados_cidade_ip["total"] > 1) {

                                        $cidade = ($dados_cidade_ip["cidade"]) ? $dados_cidade_ip["cidade"] : "Not found";

                                        ?>
                                        <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $cidade; ?></div></td>
                                        <?php } ?>
                                        <?php } ?>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $sql_cidades = mysqli_query($conexao,"SELECT distinct(cidade) as cidade, count(cidade) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND cidade != 'Not found' GROUP by cidade ORDER by codigo ASC LIMIT 10");
                                        while ($dados_cidade_ip = mysqli_fetch_array($sql_cidades)) {

                                        if($dados_cidade_ip["total"] > 1) {

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $dados_cidade_ip["total"]; ?></td>
                                        <?php } ?>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                                          </td>
                                                        </tr>
                                                      </table>
                                        <?php } else if($estatistica == "5" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_info_stats_players']; ?></td>
                                        <?php
                                        $sql_players = mysqli_query($conexao,"SELECT distinct(player) as player, count(player) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' GROUP by player ORDER by player ASC LIMIT 10");
                                        while ($dados_player_ip = mysqli_fetch_array($sql_players)) {

                                        if($dados_player_ip["total"] > 1) {

                                        $player = ($dados_player_ip["player"]) ? $dados_player_ip["player"] : "Not found";

                                        ?>
                                        <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $player; ?></div></td>
                                        <?php } ?>
                                        <?php } ?>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $sql_players = mysqli_query($conexao,"SELECT distinct(player) as player, count(player) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' GROUP by player ORDER by player ASC LIMIT 10");
                                        while ($dados_player_ip = mysqli_fetch_array($sql_players)) {

                                        if($dados_player_ip["total"] > 1) {

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $dados_player_ip["total"]; ?></td>
                                        <?php } ?>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                                          </td>
                                                        </tr>
                                                      </table>
                                        <?php } else if($estatistica == "6" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <?php if(is_numeric($mes)) { ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="300" height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br>
                                              <span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">00:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">01:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">02:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">03:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">04:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">05:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">06:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">07:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">08:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">09:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">10:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">11:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">12:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">13:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">14:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">15:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">16:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">17:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">18:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">19:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">20:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">21:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">22:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">23:00</div></td>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        // Mes especifico

                                        for($i=0;$i<=23;$i++){
                                                        
                                        $hora = sprintf("%02s",$i);
                                                        
                                        $total_ouvintes_hora = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data,hora FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND HOUR(hora) = '".$hora."'")); 

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $total_ouvintes_hora; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <?php } else { ?>
                                        <?php
                                        // Todos os meses
                                        for($iMes=1;$iMes<=date("m");$iMes++){

                                        $mes = sprintf("%02s",$iMes);   
                                        ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="300" height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br>
                                              <span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">00:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">01:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">02:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">03:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">04:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">05:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">06:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">07:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">08:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">09:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">10:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">11:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">12:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">13:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">14:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">15:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">16:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">17:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">18:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">19:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">20:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">21:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">22:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">23:00</div></td>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        // Mes especifico

                                        for($i=0;$i<=23;$i++){
                                                        
                                        $hora = sprintf("%02s",$i);
                                                        
                                        $total_ouvintes_hora = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data,hora FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND HOUR(hora) = '".$hora."'")); 

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $total_ouvintes_hora; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <?php } ?>
                                        <?php } ?>
                                                          </td>
                                                        </tr>
                                                      </table>
                                        <?php } ?>

                                    </div>
                                </div>
                            </div>
                            <?php } ?>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script>
  status_streaming('<?php echo $porta_code; ?>');
  setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
  </script>
</body>
</html>