<?php
require_once("admin/inc/protecao-final-dj.php");

if($dados_stm["idioma_painel"] == "pt-br") {
$lang_sortable = "Portuguese-Brasil";
} elseif($dados_stm["idioma_painel"] == "en-us") {
$lang_sortable = "English";
} else {
$lang_sortable = "Spanish";
}

$dados_servidor_aacplus = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor_aacplus"]."'"));

if($dados_stm["idioma_painel"]) {
require_once("inc/lang-".$dados_stm["idioma_painel"].".php");
} else {
require_once("inc/lang-pt-br.php");
}

$status_streaming = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);
    
if($status_streaming == "ligado") {

// Dados do streaming
$info = shoutcast_info($dados_servidor["ip"],$dados_stm["porta"],1);
$pico_ouvintes = $info["pico_ouvintes"];
$average_ouvintes = $info["average"];
$unique_ouvintes = $info["unique"];

$total_pontos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."'"));

if($total_pontos > 0) {

$sql = mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."' ORDER by id ASC");
while ($dados_ponto = mysqli_fetch_array($sql)) {
$stats_shoutcast[] = estatistica_ouvintes_conectados_shoutcast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"],$dados_ponto["id"]);
}

$stats_shoutcast = flatten_array($stats_shoutcast);

} else {
$stats_shoutcast = estatistica_ouvintes_conectados_shoutcast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"],1);
}

if($dados_stm["aacplus"] == 'sim') {
$stats_aacplus = estatistica_ouvintes_conectados_aacplus($dados_servidor_aacplus["ip"],$dados_stm["porta"],$dados_servidor_aacplus["senha"]);
}

if(@count($stats_aacplus) > 0) {
$array_estatisticas = @array_merge($stats_shoutcast, $stats_aacplus);
} else {
$array_estatisticas = $stats_shoutcast;
}

$array_estatisticas = @array_filter($array_estatisticas);

if(@count($array_estatisticas) > 0 && $dados_stm["aacplus"] == 'sim') {

foreach($array_estatisticas as $estatistica){

if(!preg_match('/'.$dados_servidor_aacplus["ip"].'/',$estatistica)) {
$estatisticas[] = $estatistica;
}

}
} else {
$estatisticas = $array_estatisticas;
}

$porcentagem_uso_ouvintes = ($dados_stm["ouvintes"] == 0) ? "0" : @count($estatisticas)*100/$dados_stm["ouvintes"];
$porcentagem_uso_ouvintes = ($porcentagem_uso_ouvintes < 1 && @count($estatisticas) > 0) ? "1" : $porcentagem_uso_ouvintes;

$porcentagem_uso_ftp = ($dados_stm["espaco_usado"] == 0 || $dados_stm["espaco"] == 0) ? "0" : $dados_stm["espaco_usado"]*100/$dados_stm["espaco"];

// Insere os ouvintes conectados na tabela temporaria
if(@count($estatisticas) > 0) {

// Apaga os ouvintes antigos
mysqli_query($conexao,"Delete From ouvintes_conectados where codigo_stm = '".$dados_stm["codigo"]."'");

foreach($estatisticas as $estatistica) {

list($ip, $tempo_conectado, $pais_sigla, $pais_nome, $player) = explode("|",$estatistica);

$dados_api_geoip = unserialize(@file_get_contents("http://www.geoplugin.net/php.gp?ip=".$ip.""));

$pais_codigo = ($dados_api_geoip["geoplugin_countryCode"]) ? $dados_api_geoip["geoplugin_countryCode"] : "desconhecido";
$pais_nome = ($dados_api_geoip["geoplugin_countryName"]) ? utf8_decode($dados_api_geoip["geoplugin_countryName"]) : "Desconhecido/Unknown";

mysqli_query($conexao,"INSERT INTO ouvintes_conectados (codigo_stm,ip,tempo_conectado,pais_sigla,pais_nome,cidade,estado,player) VALUES ('".$dados_stm["codigo"]."','".$ip."','".$tempo_conectado."','".$pais_codigo."','".$pais_nome."','".utf8_decode($dados_api_geoip["geoplugin_city"])."','".utf8_decode($dados_api_geoip["geoplugin_region"])."','".$player."')");

}
}

} 

if($dados_stm["idioma_painel"] == "pt-br") {
$lang_sortable = "Portuguese-Brasil";
} elseif($dados_stm["idioma_painel"] == "en-us") {
$lang_sortable = "English";
} else {
$lang_sortable = "Spanish";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Streaming <?php echo $dados_stm["porta"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
    <link rel="stylesheet" media="all" href="https://jvectormap.com/css/jquery-jvectormap-2.0.5.css"/>
  <?php if($dados_stm["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
  <script type="text/javascript" src="/inc/javascript.js"></script>  
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
        <script src="https://code.highcharts.com/highcharts.js"></script>
        <script src="https://code.highcharts.com/highcharts-3d.js"></script>
        <script src="https://code.highcharts.com/modules/exporting.js"></script>
        <script src="https://jvectormap.com/js/jquery-jvectormap-2.0.5.min.js"></script>
        <script src="https://jvectormap.com/js/jquery-jvectormap-world-mill.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/dj"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/dj"><span>Painel Streaming</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/dj"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown show">
            <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" id="profileDropdown" aria-expanded="true">
              <i class="fa fa-power-off f-18 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_botao_titulo_ligar']; ?>/<?php echo $lang['lang_botao_titulo_desligar']; ?>"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown" aria-labelledby="profileDropdown">
              <a class="dropdown-item text-success" href="javascript:ligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> Streaming</a>
              <div class="dropdown-divider"></div>              
              <a class="dropdown-item text-success" href="javascript:carregar_opcoes_ligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> AutoDJ</a>
              <a class="dropdown-item text-warning" href="javascript:kick_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_acao_stm_kick']; ?></a>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
          <li>
            <button type="button" class="btn btn-info" id="status-streaming" onClick="status_streaming('<?php echo $porta_code; ?>');" style="margin: 10px;min-width: 150px; min-height: 40px"><i class="fa fa-refresh"></i></button>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <nav class="sidebar sidebar-offcanvas" id="sidebar">
        <ul class="nav">
          <li class="nav-item">
            <a class="nav-link" href="/dj">
              <i class="fa fa-home text-icones"></i>
              <span class="menu-title">Dashboard</span>
            </a>
          </li>
        </ul>
      </nav>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <?php
$total_pedidos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM pedidos_musicais WHERE codigo_stm = '".$dados_stm["codigo"]."'"));

if($total_pedidos > 0) {
?>
                            <div class="col-md-12">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_streaming_pedidos_musicais_tab_titulo']; ?></header>
                                    </div>
                                    <div class="card-block">
                                        <div class="table-responsive">
                                            <table id="data_table1" class="table dataTable no-footer" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_streaming_pedidos_musicais_data']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_streaming_pedidos_musicais_ouvinte']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_streaming_pedidos_musicais_musica']; ?></th>
                                                        <th class="nosort sorting_disabled"></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT * FROM pedidos_musicais WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo DESC LIMIT 500");
while ($dados_pedido = mysqli_fetch_array($sql)) {

$pedido_code = code_decode($dados_pedido["codigo"],"E");

echo "<tr id='".$pedido_code."'>
<td height='25' align='left' scope='col'>&nbsp;".formatar_data($dados_stm["formato_data"], $dados_pedido["data"], $dados_stm["timezone"])."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_pedido["nome"]." - ".$dados_pedido["email"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_pedido["musica"]."</td>
<td height='25' align='center' scope='col'>&nbsp;<a href='javascript:remover_pedido_musical(\"".$pedido_code."\");'><i class='ik ik-trash-2 f-16 text-red'></i></a></td>
</tr>";

}
?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
<?php } ?>
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_ouvintes_conectados_trans_atual_tab_titulo']; ?></header>
                                    </div>
                                    <div class="card-body">
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                          <td width="25%" height="70" align="center"><img src="/img/icones/img-icone-ouvintes.png" width="48" height="48" /></td>
                                          <td width="25%" align="center"><img src="/img/icones/img-icone-dj.png" width="48" height="48" /></td>
                                          <td width="25%" align="center"><img src="/img/icones/img-icone-estatistica.png" width="48" height="48" /></td>
                                          <td width="25%" align="center"><img src="/img/icones/img-icone-agendamento.png" width="48" height="48" /></td>
                                        </tr>
                                        <tr>
                                          <td height="30" align="center"><strong><?php echo @count($estatisticas); ?></strong><br /><?php echo $lang['lang_info_ouvintes_conectados_ouvintes_total']; ?></td>
                                          <td align="center"><strong><?php echo $unique_ouvintes; ?></strong><br /><?php echo $lang['lang_info_ouvintes_conectados_ouvintes_unicos']; ?></td>
                                          <td align="center"><strong><?php echo $pico_ouvintes; ?></strong><br /><?php echo $lang['lang_info_ouvintes_conectados_ouvintes_pico']; ?></td>
                                          <td align="center"><strong><?php echo seconds2time($average_ouvintes); ?></strong><br /><?php echo $lang['lang_info_ouvintes_conectados_ouvintes_average']; ?></td>
                                        </tr>
                                      </table>
                                    </div>
                                </div>
                            </div>

                            <?php if(@count($estatisticas) > 0) { ?>

                            <div class="col-xl-6 col-md-6">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_ouvintes_conectados_paises_tab_titulo']; ?></header>
                                    </div>
                                    <div class="card-block">
                                        <div class="table-responsive">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                <tr>
                                                <?php
                                                if(count($estatisticas) > 0) {
                                                $count = 0;

                                                $sql_paises = mysqli_query($conexao,"SELECT *, count(pais_sigla) as total FROM ouvintes_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' GROUP by pais_sigla ORDER by total DESC LIMIT 5");
                                                while ($dados_pais = mysqli_fetch_array($sql_paises)) {

                                                if(!($count % 2)){ echo "<tr></tr>"; }

                                                echo '<td width="50%" height="25" align="left" scope="col" style="padding-left:10px;"><img src="/img/icones/paises/'.strtolower($dados_pais["pais_sigla"]).'.png" border="0" width="16" height="11" align="absmiddle" />&nbsp;&nbsp;'.$dados_pais["pais_nome"].'&nbsp;&nbsp;('.$dados_pais["total"].')</td>';

                                                $count++;
                                                }

                                                }
                                                ?>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-6 col-md-6">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_ouvintes_conectados_players_tab_titulo']; ?></header>
                                    </div>
                                    <div class="card-block">
                                        <div class="table-responsive">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                <tr>
                                                <?php
                                                if(count($estatisticas) > 0) {
                                                $count = 0;

                                                $sql_player = mysqli_query($conexao,"SELECT *, count(player) as total FROM ouvintes_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' GROUP by player ORDER by total DESC LIMIT 5");
                                                while ($dados_player = mysqli_fetch_array($sql_player)) {

                                                $player_icone = (file_exists("img/icones/players/".str_replace(" ","",$dados_player["player"]).".png")) ? str_replace(" ","",$dados_player["player"]) : "Outro";

                                                if(!($count % 2)){ echo "<tr></tr>"; }

                                                echo '<td width="50%" height="25" align="left" scope="col" style="padding-left:10px;"><img src="/img/icones/players/'.$player_icone.'.png" border="0" width="16" height="16" align="absmiddle" />&nbsp;&nbsp;'.$dados_player["player"].'&nbsp;&nbsp;('.$dados_player["total"].')</td>';

                                                $count++;
                                                }

                                                }
                                                ?>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_ouvintes_conectados_tab_titulo']; ?></header>
                                    </div>
                                        <div class="table-responsive">
                                            <table id="data_table2" class="table dataTable no-footer" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_ouvintes_conectados_ip']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_ouvintes_conectados_pais']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_ouvintes_conectados_player']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_ouvintes_conectados_tempo_conectado']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php

$sql_ouvintes = mysqli_query($conexao,"SELECT * FROM ouvintes_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by ip ASC");
while ($dados_ouvinte = mysqli_fetch_array($sql_ouvintes)) {

$localidade .= ($dados_ouvinte["estado"]) ? " - ".$dados_ouvinte["estado"]."" : "";
$localidade .= ($dados_ouvinte["cidade"]) ? " - ".$dados_ouvinte["cidade"]."" : "";

$player_icone = (file_exists("img/icones/players/".str_replace(" ","",$dados_ouvinte["player"]).".png")) ? str_replace(" ","",$dados_ouvinte["player"]) : "Outro";

echo "
  <tr>
    <td height='23' class='texto_padrao'>&nbsp;".$dados_ouvinte["ip"]."</td>
    <td height='23' class='texto_padrao'>&nbsp;<img src='/img/icones/paises/".strtolower($dados_ouvinte["pais_sigla"]).".png' border='0' align='absmiddle' />&nbsp;".$dados_ouvinte["pais_nome"]."".$localidade."</td>
    <td height='23' class='texto_padrao'>&nbsp;<img src='/img/icones/players/".$player_icone.".png' border='0' width='16' height='16' align='absmiddle' />&nbsp;".$dados_ouvinte["player"]."</td>
    <td height='23' class='texto_padrao'>&nbsp;".$dados_ouvinte["tempo_conectado"]."</td>
  </tr>
";
unset($localidade);

}
?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                            </div>

                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body">
                                        <script type="text/javascript">
                                            var markers = [
                                            <?php

                                            $sql_ouvintes = mysqli_query($conexao,"SELECT * FROM ouvintes_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by ip ASC");
                                            while ($dados_ouvinte = mysqli_fetch_array($sql_ouvintes)) {

                                            $dados_api_geoip_lat_long = api_geoip($dados_ouvinte["ip"]);

                                            $latitude = $dados_api_geoip_lat_long["latitude"];
                                            $longitude = $dados_api_geoip_lat_long["longitude"];

                                            echo "{latLng: [".$latitude.", ".$longitude."], name: 'Ouvinte: ".$dados_ouvinte["ip"]." | Localidade: ".$dados_ouvinte["cidade"]." - ".$dados_ouvinte["estado"]." | Player: ".$dados_ouvinte["player"]."'},";

                                            }

                                            ?>];
                                            $(function () {
                                              $('#mapa_ouvintes').vectorMap({
                                                map              : 'world_mill',
                                                normalizeFunction: 'polynomial',
                                                hoverOpacity     : 0.7,
                                                hoverColor       : false,
                                                backgroundColor  : 'transparent',
                                                regionStyle      : {
                                                  initial      : {
                                                    fill            : 'rgba(210, 214, 222, 1)',
                                                    'fill-opacity'  : 1,
                                                    stroke          : 'none',
                                                    'stroke-width'  : 0,
                                                    'stroke-opacity': 1
                                                  },
                                                  hover        : {
                                                    'fill-opacity': 0.7,
                                                    cursor        : 'pointer'
                                                  },
                                                  selected     : {
                                                    fill: 'yellow'
                                                  },
                                                  selectedHover: {}
                                                },
                                                markerStyle      : {
                                                  initial: {
                                                    fill  : '#00a65a',
                                                    stroke: '#111'
                                                  }
                                                },
                                                markers: markers

                                                });
                                              });

                                            </script>
                                        <div id="mapa_ouvintes" style="width:100%; height: 350px; margin: 0 auto"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body">
                                        <script type="text/javascript">
                                            // Graficos
                                            $(function () {
                                                var chart;
                                                $(document).ready(function() {
                                                    chart = new Highcharts.Chart({
                                                        chart: {
                                                            renderTo: 'grafico_horas',
                                                            type: 'area'
                                                        },
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_ouvintes_conectados_estatisticas_titulo']; ?>'
                                                        },
                                                        subtitle: {
                                                            text: '<?php echo formatar_data($dados_stm["formato_data"], date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-1, date("Y"))), $dados_stm["timezone"]). " - " . formatar_data($dados_stm["formato_data"], date("Y-m-d"), $dados_stm["timezone"]);?>'
                                                        },
                                                        xAxis: {
                                                            categories: ['00:00-00:59','01:00-01:59','02:00-02:59','03:00-03:59','04:00-04:59','05:00-05:59','06:00-06:59','07:00-07:59','08:00-08:59','09:00-09:59','10:00-10:59','11:00-11:59','12:00-12:59','13:00-13:59','14:00-14:59','15:00-15:59','16:00-16:59','17:00-17:59','18:00-18:59','19:00-19:59','20:00-20:59','21:00-21:59','22:00-22:59','23:00-23:59'],
                                                            tickmarkPlacement: 'on',
                                                            title: {
                                                                enabled: true,
                                                                text: '<?php echo $lang['lang_info_ouvintes_conectados_estatisticas_info_hora']; ?>'
                                                            }
                                                        },
                                                        yAxis: {
                                                            title: {
                                                                text: '<?php echo $lang['lang_info_ouvintes_conectados_estatisticas_total_ouvintes']; ?>'
                                                            },
                                                            labels: {
                                                                formatter: function() {
                                                                    return this.value;
                                                                }
                                                            }
                                                        },
                                                        tooltip: {
                                                            formatter: function() {
                                                                return ''+this.x+': '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_ouvintes_conectados_estatisticas_balao_ouvintes']; ?>';
                                                            }
                                                        },
                                                        plotOptions: {
                                                            area: {
                                                                stacking: 'normal',
                                                                lineColor: '#666666',
                                                                lineWidth: 1,
                                                                cursor: 'pointer',
                                                                marker: {
                                                                    lineWidth: 1,
                                                                    lineColor: '#666666',
                                                                    enabled: false,
                                                                    symbol: 'circle',
                                                                    radius: 2,
                                                                    states: {
                                                                        hover: {
                                                                        enabled: true
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        },
                                                        series: [{
                                                            name: '<?php echo $lang['lang_info_ouvintes_conectados_estatisticas_total_ouvintes_ontem']; ?>',
                                                            data: [<?php
                                                            
                                                            $data_ontem = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-1, date("Y")));
                                                            
                                                            for($i=0;$i<=23;$i++){
                                                            
                                                            $hora = sprintf("%02s",$i);
                                                            
                                                            $total_ouvintes = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data_ontem."' AND HOUR(hora) = '".$hora."'"));
                                                            
                                                            $array_total_ouvintes .= $total_ouvintes.",";
                                                            
                                                            }
                                                            echo substr($array_total_ouvintes, 0, -1);  
                                                            
                                                            unset($array_total_ouvintes);
                                                            unset($total_ouvintes);
                                                            ?>]
                                                            }, {
                                                            name: '<?php echo $lang['lang_info_ouvintes_conectados_estatisticas_total_ouvintes_hoje']; ?>',
                                                            data: [<?php
                                                            
                                                            for($i=0;$i<=23;$i++){
                                                            
                                                            $hora = sprintf("%02s",$i);
                                                            
                                                            $total_ouvintes = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".date("Y-m-d")."' AND HOUR(hora) = '".$hora."'"));
                                                            
                                                            $array_total_ouvintes .= $total_ouvintes.",";
                                                            
                                                            }
                                                            echo substr($array_total_ouvintes, 0, -1);  
                                                            
                                                            unset($array_total_ouvintes);
                                                            unset($total_ouvintes);
                                                            ?>]
                                                        }]
                                                    });
                                                });
                                                
                                            });
                                            </script>
                                        <div id="grafico_horas" style="width:100%; height: 350px; margin: 0 auto"></div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script>
  status_streaming('<?php echo $porta_code; ?>');
  setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
        setTimeout("window.location.reload();",45000);   
        $(document).ready(function() {

            var table = $('#data_table1').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });   
        $(document).ready(function() {

            var table = $('#data_table2').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });
  </script>
</body>
</html>