<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

// Stats do shoutcast
$info = shoutcast_info($dados_servidor["ip"],$dados_stm["porta"],1);
$proxima_musica = str_replace("\n","",$info["proxima_musica"]);
$encoder = (preg_match('/aacp/i',$info["encoder"])) ? "AACPlus" : "MP3";

$porcentagem_uso_ouvintes = ($dados_stm["ouvintes"] == 0 || $dados_stm["ouvintes"] > 999998) ? "0" : $total_ouvintes*100/$dados_stm["ouvintes"];
$porcentagem_uso_espaco_ftp = ($dados_stm["espaco"] == 0 || $dados_stm["espaco"] > 999998) ? "0" : $dados_stm["espaco_usado"]*100/$dados_stm["espaco"];
$porcentagem_uso_bitrate = ($dados_stm["bitrate_autodj"] > 0) ? $dados_stm["bitrate_autodj"]*100/$dados_stm["bitrate"] : "0";

$limite_ouvintes = ($dados_stm["ouvintes"] == 999999) ? '<small>'.lang_info_ilimitado.'</small>' : $dados_stm["ouvintes"];

// Transmissao atual
$total_ouvintes = ($info["ouvintes_total"] > 0) ? $info["ouvintes_total"] : "0";
$bitrate = ($info["bitrate_autodj"] > 0) ? $info["bitrate_autodj"] : "0";

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Streaming <?php echo $dados_stm["porta"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <?php if($dados_stm["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
  <script type="text/javascript" src="/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Painel Streaming</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown show">
            <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" id="profileDropdown" aria-expanded="true">
              <i class="fa fa-power-off f-18 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_botao_titulo_ligar']; ?>/<?php echo $lang['lang_botao_titulo_desligar']; ?>"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown" aria-labelledby="profileDropdown">
              <a class="dropdown-item text-success" href="javascript:ligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> Streaming</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> Streaming</a>
              <?php if($dados_stm["autodj"] == "sim") { ?>
              <div class="dropdown-divider"></div>              
              <a class="dropdown-item text-success" href="javascript:carregar_opcoes_ligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> AutoDJ</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> AutoDJ</a>
              <?php } ?>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_streaming($conexao,$dados_stm["porta"],$dados_servidor["codigo"]); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
          <li>
            <button type="button" class="btn btn-info" id="status-streaming" onClick="status_streaming('<?php echo $porta_code; ?>');" style="margin: 10px;min-width: 150px; min-height: 40px"><i class="fa fa-refresh"></i></button>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>    
          <?php if($_SESSION["code_user_logged"] && $dados_stm["codigo_cliente"] == $_SESSION["code_user_logged"]) { ?><div class="alert alert-warning text-center" role="alert"><i class="fa fa-warning"></i>&nbsp;<?php echo $lang['lang_info_acessar_painel_revenda_logado']; ?></div><?php } ?>
          <div class="row">            

            <div class="col-12">
              <div class="row">
                <div class="<?php if($dados_stm["autodj"] == "sim") { ?>col-12 col-sm-6 col-md-3<?php } else { ?>col-12 col-sm-6 col-md-4<?php } ?>">
                  <div class="card">
                    <div class="card-body">
                      <h2 class="card-title" style="font-size: 30px"><?php echo $dados_stm["porta"]; ?></h2>
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><?php echo $lang['lang_info_pagina_informacoes_streaming_tab_stm_porta']; ?> DJ</p>
                        <p class="text-muted"><small><?php echo $dados_stm["porta_dj"]; ?></small></p>
                      </div>
                      <div style="min-height: 2px"></div>
                    </div>
                  </div>
                </div>
                <div class="<?php if($dados_stm["autodj"] == "sim") { ?>col-12 col-sm-6 col-md-3<?php } else { ?>col-12 col-sm-6 col-md-4<?php } ?>">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo $lang['lang_info_pagina_informacoes_streaming_tab_plano_ouvintes']; ?></h4>                      
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-headphones f-32"></i></p>
                        <p class="text-muted" id="total_ouvintes"><?php echo $total_ouvintes; ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-success" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_ouvintes; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_ouvintes" style="width: <?php echo $porcentagem_uso_ouvintes; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <?php if($dados_stm["autodj"] == "sim") { ?>
                <div class="col-12 col-sm-6 col-md-3">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo $lang['lang_info_pagina_informacoes_streaming_tab_ftp_espaco']; ?></h4>
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-hdd-o f-32"></i></p>
                        <p class="text-muted"><?php echo tamanho($dados_stm["espaco_usado"]); ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-danger" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_espaco_ftp; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_ouvintes" style="width: <?php echo $porcentagem_uso_espaco_ftp; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <?php } ?>
                <div class="<?php if($dados_stm["autodj"] == "sim") { ?>col-12 col-sm-6 col-md-3<?php } else { ?>col-12 col-sm-6 col-md-4<?php } ?>">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title">Bitrate</h4>
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-signal f-32"></i></p>
                        <p class="text-muted"><?php echo $dados_stm["bitrate"]; ?> <small>Kbps</small></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-warning" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_bitrate; ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $porcentagem_uso_bitrate; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>           

            <div class="<?php if($dados_stm["autodj"] == "sim") { ?>col-lg-8<?php } else {?>col-lg-12<?php } ?>">
              <div class="card">
                  <div class="card-header">
                    <header>Player</header>
                  </div>
                <div class="card-block" style="background-color: #e9ecef;">
                    <iframe src="https://player.<?php echo $dados_config['dominio_padrao']; ?>/player-web/<?php echo $dados_stm["porta"]; ?>" frameborder="0" width="100%" height="450"></iframe>
                    <textarea name="textarea" readonly="readonly" class="form-control" style="width:100%; height:35px;font-size:11px" onmouseover="this.select()"><iframe src="https://player.<?php echo $dados_config['dominio_padrao']; ?>/player-web/<?php echo $dados_stm["porta"]; ?>" frameborder="0" width="100%" height="465"></iframe></textarea>
                </div>
              </div>
            </div>
            <?php if($dados_stm["autodj"] == "sim") { ?>
            <div class="col-lg-4">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo $lang[ 'lang_acao_label_atalhos' ];?></header>
                  </div>
                <div class="card-block text-center">
                    <table width="60%" border="0" cellspacing="0" cellpadding="0" align="center" style="margin-top: 5px; margin-bottom: 5px;">
                                          <tr>
                                            <td height="55" align="center"><button type="button" class="btn btn-sm btn-info btn-block" onClick="javascript:trocar_playlist('<?php echo $porta_code; ?>','carregar_playlists','0');"><i class="fa fa-play-circle"></i> <?php echo $lang['lang_acao_autodj_trocar_playlist']; ?></button></td>
                                          </tr>
                                          <tr>
                                            <td height="55" align="center"><button type="button" class="btn btn-sm btn-info btn-block" onClick="window.location = '/gerenciar-musicas';"><i class="fa fa-music"></i> <?php echo $lang['lang_acao_autodj_gerenciar_musicas']; ?></button></td>
                                          </tr>
                                          <tr>
                                            <td height="55" align="center"><button type="button" class="btn btn-sm btn-info btn-block" onClick="window.location = '/playlists';"><i class="fa fa-list"></i> <?php echo $lang['lang_acao_autodj_gerenciar_playlists']; ?></button></td>
                                          </tr>
                                          <tr>
                                            <td height="55" align="center"><button type="button" class="btn btn-sm btn-info btn-block" onClick="window.location = '/gerenciar-agendamentos';"><i class="fa fa-calendar"></i> <?php echo $lang['lang_acao_autodj_gerenciar_agendamentos']; ?></button></td>
                                          </tr>
                                          <tr>
                                            <td height="55" align="center"><button type="button" class="btn btn-sm btn-info btn-block" onClick="window.location = '/ouvintes-conectados';"><i class="fa fa-users"></i> <?php echo $lang['lang_acao_ouvintes_ouvintes_conectados']; ?></button></td>
                                          </tr>
                                        </table>
                </div>
              </div>
            </div>
            <?php } ?>
            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header>Logs</header>
                  </div>
                  <div class="card-body">
                      <div class="table-responsive">
                                            <table class="table table-hover mb-0">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo $lang['lang_info_streaming_logs_data']; ?></th>
                                                        <th><?php echo $lang['lang_info_streaming_logs_ip']; ?></th>
                                                        <th><?php echo $lang['lang_info_streaming_logs_navegador']; ?></th>
                                                        <th><?php echo $lang['lang_info_streaming_logs_log']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT * FROM logs_streamings WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo DESC LIMIT 5");
while ($dados_log = mysqli_fetch_array($sql)) {

$log = str_replace("<br>","",$dados_log["log"]);
$log = str_replace("<br />","",$log);

$log = (strlen($log) > 105) ? substr($log, 0, 105)."..." : $log;

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".formatar_data($dados_stm["formato_data"], $dados_log["data"], $dados_stm["timezone"])."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_log["ip"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_log["navegador"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$log."</td>
</tr>";

}
?>
                                                </tbody>
                                            </table>
                                        </div>
                  </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  status_streaming('<?php echo $porta_code; ?>');
  transmissao_atual();
  setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
        setInterval("transmissao_atual()",60000);
        // Clima
        !function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src='https://weatherwidget.io/js/widget.min.js';fjs.parentNode.insertBefore(js,fjs);}}(document,'script','weatherwidget-io-js');
  <?php if(is_numeric($dados_revenda["numero_whatsapp"]) && $dados_revenda["numero_whatsapp"] > 0) { ?>
        CreateWhatsappChatWidget(options);
        setTimeout(function() {
          $(".wa-chat-box-poweredby").remove();
        }, 2000);
    <?php } ?>
    var url = 'https://wati-integration-service.clare.ai/ShopifyWidget/shopifyWidget.js?75396';
    var s = document.createElement('script');
    s.type = 'text/javascript';
    s.async = true;
    s.src = url;
    var options = {
  "enabled":true,
  "chatButtonSetting":{
      "backgroundColor":"#4dc247",
      "ctaText":"Atendimento",
      "borderRadius":"25",
      "marginLeft":"0",
      "marginBottom":"50",
      "marginRight":"50",
      "position":"left"
  },
  "brandSetting":{
      "brandName":"Suporte",
      "brandSubTitle":"Online",
      "brandImg":"https://icons.iconarchive.com/icons/dtafalonso/android-l/64/WhatsApp-icon.png",
      "welcomeText":"Olá, em que podemos ajudar? Envia-nos uma mensagem.",
      "messageText":"",
      "backgroundColor":"#0a5f54",
      "ctaText":"Enviar Mensagem",
      "borderRadius":"25",
      "autoShow":false,
      "phoneNumber":"<?php echo str_replace(" ","",$dados_revenda["numero_whatsapp"]); ?>"
  }
};
var x = document.getElementsByTagName('script')[0];
x.parentNode.insertBefore(s, x);
  </script>
</body>
</html>