-- Painel de Streaming de Áudio
-- Criado por Cesar - cesarlwh@gmail.com
-- Se voce nao comprou este painel comigo, sinto dizer que esta correndo risco de seguranca e de seus dados serem expostos

--
-- Banco de dados: `audio`
--

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `lives` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `data_inicio` datetime NOT NULL,
  `data_fim` datetime NOT NULL,
  `tipo` varchar(255) NOT NULL,
  `servidor_stm` varchar(255) NOT NULL,
  `servidor_live` varchar(255) NOT NULL,
  `exibir_capa` char(3) DEFAULT 'sim',
  `status` int(1) NOT NULL DEFAULT 0
) ENGINE=MyISAM;

--
-- Estrutura da tabela `administradores`
--

CREATE TABLE `administradores` (
  `codigo` int(10) NOT NULL,
  `nome` varchar(255) DEFAULT NULL,
  `usuario` varchar(255) DEFAULT NULL,
  `senha` varchar(255) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `apps`
--

CREATE TABLE `apps` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `radio_nome` varchar(255) DEFAULT NULL,
  `radio_email` varchar(255) DEFAULT NULL,
  `radio_site` varchar(255) DEFAULT NULL,
  `radio_facebook` varchar(255) DEFAULT NULL,
  `radio_twitter` varchar(255) DEFAULT NULL,
  `radio_descricao` text DEFAULT NULL,
  `play` char(3) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `apk` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `package` varchar(255) DEFAULT NULL,
  `tipo` varchar(255) NOT NULL DEFAULT 'android',
  `aviso` text DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 0,
  `data` datetime DEFAULT NULL,
  `print` varchar(255) DEFAULT NULL,
  `source` varchar(255) NOT NULL DEFAULT 'source1',
  `log_build` longtext DEFAULT NULL,
  `compilado` char(3) DEFAULT 'nao'
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `atalhos`
--

CREATE TABLE `atalhos` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `menu` varchar(255) DEFAULT NULL,
  `lang` varchar(255) DEFAULT NULL,
  `ordem` int(10) NOT NULL DEFAULT 0
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `autodj_acoes`
--

CREATE TABLE `autodj_acoes` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `codigo_playlist` int(10) NOT NULL DEFAULT 0,
  `frequencia` int(1) DEFAULT NULL,
  `data` date DEFAULT NULL,
  `hora` char(2) DEFAULT NULL,
  `minuto` char(2) DEFAULT NULL,
  `dias` varchar(50) DEFAULT NULL,
  `acao` varchar(255) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `avisos`
--

CREATE TABLE `avisos` (
  `codigo` int(10) NOT NULL,
  `codigo_servidor` int(10) NOT NULL DEFAULT 0,
  `area` varchar(255) DEFAULT NULL,
  `titulo` varchar(255) DEFAULT NULL,
  `descricao` longtext DEFAULT NULL,
  `data` date DEFAULT NULL,
  `mensagem` longtext DEFAULT NULL,
  `status` char(3) NOT NULL DEFAULT 'sim'
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `avisos_desativados`
--

CREATE TABLE `avisos_desativados` (
  `codigo` int(10) NOT NULL,
  `codigo_aviso` int(10) NOT NULL DEFAULT 0,
  `codigo_usuario` int(10) NOT NULL DEFAULT 0,
  `area` varchar(255) DEFAULT NULL,
  `data` date DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `bloqueios_login`
--

CREATE TABLE `bloqueios_login` (
  `codigo` int(10) NOT NULL,
  `codigo_cliente` int(10) NOT NULL DEFAULT 0,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `data` datetime DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `navegador` varchar(255) DEFAULT NULL,
  `tentativas` int(10) NOT NULL DEFAULT 0
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `certificados`
--

CREATE TABLE `certificados` (
  `codigo` int(10) NOT NULL,
  `dominio` varchar(255) DEFAULT NULL,
  `data` datetime DEFAULT NULL,
  `tipo` varchar(255) DEFAULT NULL,
  `status` int(1) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `configuracoes`
--

CREATE TABLE `configuracoes` (
  `dominio_cdn` varchar(255) DEFAULT NULL,
  `dominio_padrao` varchar(255) DEFAULT NULL,
  `codigo_servidor_atual` int(10) NOT NULL DEFAULT 0,
  `codigo_servidor_aacplus_atual` int(10) NOT NULL DEFAULT 0,
  `usar_cdn` char(3) NOT NULL DEFAULT 'sim',
  `manutencao` char(3) NOT NULL DEFAULT 'nao'
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `dicas_rapidas`
--

CREATE TABLE `dicas_rapidas` (
  `codigo` int(10) NOT NULL,
  `titulo` varchar(255) DEFAULT NULL,
  `mensagem` text DEFAULT NULL,
  `exibir` char(3) NOT NULL DEFAULT 'sim'
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `dicas_rapidas_acessos`
--

CREATE TABLE `dicas_rapidas_acessos` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `codigo_dica` int(10) NOT NULL DEFAULT 0,
  `total` int(10) NOT NULL DEFAULT 0
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `djs`
--

CREATE TABLE `djs` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `login` varchar(255) DEFAULT NULL,
  `senha` varchar(255) DEFAULT NULL,
  `hora_inicio` char(5) DEFAULT NULL,
  `hora_fim` char(5) DEFAULT NULL,
  `dias_semana` int(3) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `djs_restricoes`
--

CREATE TABLE `djs_restricoes` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `codigo_dj` int(10) NOT NULL DEFAULT 0,
  `hora_inicio` char(5) DEFAULT NULL,
  `hora_fim` char(5) DEFAULT NULL,
  `dias_semana` int(3) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `estatisticas`
--

CREATE TABLE `estatisticas` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `data` date DEFAULT NULL,
  `hora` time DEFAULT NULL,
  `ip` varchar(255) NOT NULL DEFAULT '000.000.000.000',
  `pais` varchar(255) DEFAULT NULL,
  `estado` varchar(255) DEFAULT NULL,
  `cidade` varchar(255) DEFAULT NULL,
  `tempo_conectado` int(20) NOT NULL DEFAULT 0,
  `player` varchar(255) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `geoip`
--

CREATE TABLE `geoip` (
  `codigo` int(10) NOT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `pais_sigla` varchar(255) DEFAULT NULL,
  `pais_nome` varchar(255) DEFAULT NULL,
  `estado` varchar(255) DEFAULT NULL,
  `cidade` varchar(255) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `logs`
--

CREATE TABLE `logs` (
  `codigo` int(10) NOT NULL,
  `data` datetime DEFAULT NULL,
  `host` varchar(255) NOT NULL DEFAULT 'http://',
  `ip` varchar(255) DEFAULT NULL,
  `navegador` varchar(255) DEFAULT NULL,
  `log` text DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `logs_acessos`
--

CREATE TABLE `logs_acessos` (
  `codigo` int(10) NOT NULL,
  `usuario` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `data` datetime DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `painel` varchar(255) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `logs_streamings`
--

CREATE TABLE `logs_streamings` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `data` datetime DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `navegador` varchar(255) DEFAULT NULL,
  `log` text DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `multipoint`
--

CREATE TABLE `multipoint` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `id` int(10) NOT NULL DEFAULT 0,
  `ponto` varchar(255) DEFAULT NULL,
  `ouvintes` int(10) NOT NULL DEFAULT 0,
  `bitrate` int(10) NOT NULL DEFAULT 0,
  `encoder` char(5) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `ouvintes_conectados`
--

CREATE TABLE `ouvintes_conectados` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `ip` varchar(255) DEFAULT NULL,
  `tempo_conectado` varchar(255) DEFAULT NULL,
  `pais_sigla` varchar(255) DEFAULT NULL,
  `pais_nome` varchar(255) DEFAULT NULL,
  `cidade` varchar(255) DEFAULT NULL,
  `estado` varchar(255) DEFAULT NULL,
  `player` varchar(255) DEFAULT NULL,
  `latitude` varchar(255) NOT NULL DEFAULT '0.0',
  `longitude` varchar(255) NOT NULL DEFAULT '0.0'
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `pedidos_musicais`
--

CREATE TABLE `pedidos_musicais` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `nome` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `data` datetime DEFAULT NULL,
  `musica` varchar(255) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `playlists`
--

CREATE TABLE `playlists` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `nome` varchar(255) DEFAULT NULL,
  `arquivo` varchar(255) DEFAULT NULL,
  `data` datetime DEFAULT NULL,
  `hora_certa` char(3) DEFAULT 'nao',
  `vinhetas_comerciais` char(3) DEFAULT 'nao'
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `playlists_agendamentos`
--

CREATE TABLE `playlists_agendamentos` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `codigo_playlist` int(10) NOT NULL DEFAULT 0,
  `frequencia` int(1) DEFAULT NULL,
  `data` date DEFAULT NULL,
  `hora` char(2) DEFAULT NULL,
  `minuto` char(2) DEFAULT NULL,
  `dias` varchar(50) DEFAULT NULL,
  `ultima_execussao` datetime DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `playlists_agendamentos_logs`
--

CREATE TABLE `playlists_agendamentos_logs` (
  `codigo` int(10) NOT NULL,
  `codigo_agendamento` int(10) NOT NULL DEFAULT 0,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `data` datetime DEFAULT NULL,
  `playlist` varchar(255) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `playlists_musicas`
--

CREATE TABLE `playlists_musicas` (
  `codigo` int(10) NOT NULL,
  `codigo_playlist` int(10) NOT NULL DEFAULT 0,
  `path_musica` varchar(255) DEFAULT NULL,
  `musica` varchar(255) DEFAULT NULL,
  `duracao` varchar(10) NOT NULL DEFAULT '00:00:00',
  `duracao_segundos` int(10) NOT NULL DEFAULT 0,
  `tipo` varchar(255) NOT NULL DEFAULT 'musica',
  `ordem` char(10) NOT NULL DEFAULT '0'
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `programetes_programas_links`
--

CREATE TABLE `programetes_programas_links` (
  `codigo` int(10) NOT NULL,
  `pasta` varchar(255) NOT NULL,
  `link` text NOT NULL,
  `produtora` varchar(255) NOT NULL,
  `tipo` varchar(255) NOT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `relay_agendamentos`
--

CREATE TABLE `relay_agendamentos` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `servidor` varchar(255) DEFAULT NULL,
  `frequencia` int(1) DEFAULT NULL,
  `data` date DEFAULT NULL,
  `hora` char(2) DEFAULT NULL,
  `minuto` char(2) DEFAULT NULL,
  `duracao_hora` char(2) NOT NULL DEFAULT '00',
  `duracao_minuto` char(2) NOT NULL DEFAULT '00',
  `dias` varchar(50) DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `revendas`
--

CREATE TABLE `revendas` (
  `codigo` int(10) NOT NULL,
  `codigo_revenda` int(10) NOT NULL DEFAULT 0,
  `id` char(6) DEFAULT NULL,
  `nome` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `senha` varchar(255) DEFAULT NULL,
  `streamings` int(10) NOT NULL DEFAULT 0,
  `ouvintes` int(10) NOT NULL DEFAULT 0,
  `bitrate` int(10) NOT NULL DEFAULT 0,
  `espaco` int(20) DEFAULT NULL,
  `subrevendas` int(10) NOT NULL DEFAULT 0,
  `url_logo` varchar(255) DEFAULT NULL,
  `chave_api` longtext DEFAULT NULL,
  `chave_api_google_maps` longtext DEFAULT NULL,
  `servidor` int(10) NOT NULL DEFAULT 0,
  `status` int(1) NOT NULL DEFAULT 1,
  `avisos` varchar(255) DEFAULT NULL,
  `aacplus` char(3) NOT NULL DEFAULT 'nao',
  `url_suporte` text DEFAULT NULL,
  `data_cadastro` datetime DEFAULT NULL,
  `alterar_senha` int(1) NOT NULL DEFAULT 1,
  `dominio_padrao` varchar(255) DEFAULT NULL,
  `smtp_servidor` varchar(255) DEFAULT NULL,
  `smtp_porta` int(10) NOT NULL DEFAULT 0,
  `smtp_email` varchar(255) DEFAULT NULL,
  `smtp_senha` varchar(255) DEFAULT NULL,
  `stm_exibir_tutoriais` char(3) NOT NULL DEFAULT 'sim',
  `url_tutoriais` varchar(255) NOT NULL DEFAULT 'http://',
  `url_downloads` varchar(255) DEFAULT NULL,
  `stm_exibir_app_android` char(3) NOT NULL DEFAULT 'nao',
  `stm_exibir_downloads` char(3) NOT NULL DEFAULT 'sim',
  `stm_exibir_mini_site` char(3) NOT NULL DEFAULT 'nao',
  `stm_exibir_app_android_painel` char(3) NOT NULL DEFAULT 'sim',
  `idioma_painel` char(10) NOT NULL DEFAULT 'pt-br',
  `tipo` int(1) NOT NULL DEFAULT 1,
  `ultimo_acesso_data` datetime DEFAULT NULL,
  `ultimo_acesso_ip` varchar(255) NOT NULL DEFAULT '000.000.000.000',
  `programetes` char(3) NOT NULL DEFAULT 'sim',
  `programas` char(3) NOT NULL DEFAULT 'nao',
  `status_dominio_ssl` int(1) NOT NULL DEFAULT 0,
  `codigo_servidor_privado` varchar(255) DEFAULT NULL,
  `download_programetes_programas` varchar(3) NOT NULL DEFAULT 'nao'
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `screen_size`
--

CREATE TABLE `screen_size` (
  `codigo` int(11) NOT NULL,
  `width` int(10) NOT NULL DEFAULT 0,
  `height` int(10) NOT NULL DEFAULT 0,
  `data` datetime DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `servidores`
--

CREATE TABLE `servidores` (
  `codigo` int(10) NOT NULL,
  `nome` varchar(255) NOT NULL DEFAULT 'Stm',
  `ip` varchar(255) DEFAULT NULL,
  `senha` varchar(255) DEFAULT NULL,
  `porta_ssh` int(6) NOT NULL DEFAULT 6985,
  `status` char(3) NOT NULL DEFAULT 'on',
  `limite_streamings` int(10) NOT NULL DEFAULT 150,
  `tipo` varchar(255) NOT NULL DEFAULT 'streaming',
  `load` float DEFAULT NULL,
  `trafego` varchar(255) DEFAULT NULL,
  `trafego_out` varchar(255) DEFAULT NULL,
  `ordem` int(10) NOT NULL DEFAULT 0,
  `mensagem_manutencao` text DEFAULT NULL,
  `grafico_trafego` text DEFAULT NULL
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `streamings`
--

CREATE TABLE `streamings` (
  `codigo` int(10) NOT NULL,
  `codigo_cliente` int(10) NOT NULL DEFAULT 0,
  `codigo_servidor` int(10) NOT NULL DEFAULT 0,
  `codigo_servidor_aacplus` int(10) NOT NULL DEFAULT 0,
  `porta` int(10) NOT NULL DEFAULT 0,
  `porta_dj` int(10) NOT NULL DEFAULT 0,
  `ouvintes` int(10) NOT NULL DEFAULT 0,
  `bitrate` int(10) NOT NULL DEFAULT 0,
  `bitrate_autodj` int(10) NOT NULL DEFAULT 0,
  `encoder_mp3` char(3) NOT NULL DEFAULT 'sim',
  `encoder_aacplus` char(3) NOT NULL DEFAULT 'sim',
  `encoder` varchar(255) NOT NULL DEFAULT 'mp3',
  `espaco` int(10) NOT NULL DEFAULT 0,
  `espaco_usado` int(10) NOT NULL DEFAULT 0,
  `senha` varchar(255) DEFAULT NULL,
  `senha_admin` varchar(255) DEFAULT NULL,
  `streamtitle` varchar(255) NOT NULL DEFAULT 'Web Radio',
  `streamurl` varchar(255) NOT NULL DEFAULT 'http://www.seusite.com',
  `genre` varchar(255) NOT NULL DEFAULT 'Rock',
  `showlastsongs` int(10) NOT NULL DEFAULT 5,
  `publicserver` char(6) NOT NULL DEFAULT 'always',
  `allowrelay` int(1) NOT NULL DEFAULT 1,
  `descricao` text DEFAULT NULL,
  `xfade` int(10) NOT NULL DEFAULT 0,
  `ftp_dir` varchar(255) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  `identificacao` varchar(255) NOT NULL DEFAULT 'NÃƒÂ£o cadastrada',
  `data_cadastro` date DEFAULT NULL,
  `hora_cadastro` time DEFAULT NULL,
  `local_cadastro` varchar(255) NOT NULL DEFAULT 'painel',
  `ip_cadastro` varchar(255) NOT NULL DEFAULT '000.000.000.000',
  `pid` int(10) NOT NULL DEFAULT 0,
  `pid_autodj` int(10) NOT NULL DEFAULT 0,
  `protecao` int(1) NOT NULL DEFAULT 0,
  `ultima_playlist` int(10) NOT NULL DEFAULT 0,
  `aacplus` char(3) NOT NULL DEFAULT 'nao',
  `relay` char(3) NOT NULL DEFAULT 'nao',
  `relay_ip` varchar(255) NOT NULL DEFAULT 'empty',
  `relay_porta` int(10) NOT NULL DEFAULT 0,
  `relay_monitorar` char(3) NOT NULL DEFAULT 'nao',
  `pagina_inicial` varchar(255) NOT NULL DEFAULT '/informacoes',
  `autodj` char(3) NOT NULL DEFAULT 'sim',
  `autodj_channels` int(2) NOT NULL DEFAULT 2,
  `autodj_samplerate` int(6) NOT NULL DEFAULT 44100,
  `autodj_shuffle` int(1) NOT NULL DEFAULT 0,
  `autodj_prog_aovivo` char(3) NOT NULL DEFAULT 'nao',
  `autodj_prog_aovivo_msg` varchar(255) NOT NULL DEFAULT 'Ao vivo',
  `idioma_painel` char(10) NOT NULL DEFAULT 'pt-br',
  `email` varchar(255) DEFAULT NULL,
  `exibir_app_android` char(3) NOT NULL DEFAULT 'sim',
  `exibir_atalhos` char(3) NOT NULL DEFAULT 'nao',
  `player_autoplay` char(5) NOT NULL DEFAULT 'true',
  `player_exibir_chat` char(3) NOT NULL DEFAULT 'nao',
  `player_exibir_pedido_musical` char(3) NOT NULL DEFAULT 'nao',
  `player_volume_inicial` char(3) NOT NULL DEFAULT '1.0',
  `permitir_alterar_senha` char(3) NOT NULL DEFAULT 'sim',
  `timezone` varchar(255) NOT NULL DEFAULT 'America/Sao_Paulo',
  `formato_data` char(11) NOT NULL DEFAULT 'd/m/Y H:i:s',
  `exibir_mini_site` char(3) NOT NULL DEFAULT 'nao',
  `mini_site_dominio` varchar(255) DEFAULT NULL,
  `mini_site_cor_fundo` char(6) NOT NULL DEFAULT 'FFFFFF',
  `mini_site_cor_topo` char(6) NOT NULL DEFAULT 'E9E9E9',
  `mini_site_cor_texto_topo` char(6) NOT NULL DEFAULT '000000',
  `mini_site_cor_texto_padrao` char(6) NOT NULL DEFAULT '000000',
  `mini_site_cor_texto_rodape` char(6) NOT NULL DEFAULT '000000',
  `mini_site_exibir_chat` char(3) NOT NULL DEFAULT 'sim',
  `mini_site_exibir_xat_id` int(10) NOT NULL DEFAULT 0,
  `mini_site_url_facebook` text DEFAULT NULL,
  `mini_site_url_twitter` text DEFAULT NULL,
  `arquivo_intro` varchar(255) DEFAULT NULL,
  `arquivo_backup` varchar(255) DEFAULT NULL,
  `aparencia_exibir_stats_ouvintes` char(3) NOT NULL DEFAULT 'sim',
  `aparencia_exibir_stats_ftp` char(3) NOT NULL DEFAULT 'sim',
  `aparencia_exibir_musica_atual` char(3) NOT NULL DEFAULT 'sim',
  `aparencia_exibir_player` char(3) NOT NULL DEFAULT 'sim',
  `ultimo_acesso_data` datetime DEFAULT NULL,
  `ultimo_acesso_ip` varchar(255) NOT NULL DEFAULT '000.000.000.000',
  `data_bloqueio` datetime DEFAULT NULL,
  `cidade` varchar(100) DEFAULT NULL,
  `programetes` char(3) NOT NULL DEFAULT 'sim',
  `programas` char(3) NOT NULL DEFAULT 'sim',
  `gravador_status` char(3) NOT NULL DEFAULT 'nao',
  `gravador_data_inicio` datetime DEFAULT NULL,
  `gravador_arquivo` varchar(255) DEFAULT NULL,
  `multipoint` char(3) NOT NULL DEFAULT 'nao',
  `multipoint_max` varchar(255) NOT NULL DEFAULT '',
  `live_youtube` char(3) NOT NULL DEFAULT 'nao',
  `live_youtube_status` char(3) NOT NULL DEFAULT 'nao',
  `live_youtube_data` datetime DEFAULT NULL,
  `download_programetes_programas` char(3) DEFAULT 'nao'
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- Estrutura da tabela `tutoriais`
--

CREATE TABLE `tutoriais` (
  `codigo` int(10) NOT NULL,
  `titulo` varchar(255) DEFAULT NULL,
  `data` date DEFAULT NULL,
  `vizualizacoes` int(10) NOT NULL DEFAULT 0,
  `tutorial` longtext DEFAULT NULL
) ENGINE=MyISAM;

CREATE TABLE `app_multi_plataforma` (
  `codigo` int(10) NOT NULL AUTO_INCREMENT,
  `codigo_stm` int(10) NOT NULL,
  `nome` VARCHAR(255) NOT NULL,
  `email` VARCHAR(255) NOT NULL,
  `url_facebook` VARCHAR(255) NOT NULL,
  `url_instagram` VARCHAR(255) NOT NULL,
  `url_twitter` VARCHAR(255) NOT NULL,
  `url_youtube` VARCHAR(255) NOT NULL,
  `url_site` VARCHAR(255) NOT NULL,
  `url_chat` VARCHAR(255) NOT NULL,
  `url_camera_studio` VARCHAR(255) NOT NULL,
  `url_pedir_musica` VARCHAR(255) NOT NULL,
  `url_logo` VARCHAR(255) NOT NULL,
  `url_background` VARCHAR(255) NOT NULL,
  `whatsapp` VARCHAR(255) NOT NULL,
  `cor_texto` CHAR(7) NOT NULL DEFAULT '#FFFFFF',
  `cor_menu_claro` CHAR(7) NOT NULL DEFAULT '#7386d5',
  `cor_menu_escuro` CHAR(7) NOT NULL DEFAULT '#6d7fcc',
  `cor_splash` CHAR(7) NOT NULL DEFAULT '#6d7fcc',
  `visualizer` int(1) NOT NULL DEFAULT '1',
  `exibir_capa` CHAR(3) NOT NULL DEFAULT 'sim',
  `text_prog` LONGTEXT NOT NULL,
  `text_hist` LONGTEXT NOT NULL,
  PRIMARY KEY (`codigo`)
) ENGINE=MyISAM;
--
-- Índices para tabelas despejadas
--

--
-- Índices para tabela `administradores`
--
ALTER TABLE `administradores`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `apps`
--
ALTER TABLE `apps`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `atalhos`
--
ALTER TABLE `atalhos`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `autodj_acoes`
--
ALTER TABLE `autodj_acoes`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `avisos`
--
ALTER TABLE `avisos`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `avisos_desativados`
--
ALTER TABLE `avisos_desativados`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `bloqueios_login`
--
ALTER TABLE `bloqueios_login`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `certificados`
--
ALTER TABLE `certificados`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `dicas_rapidas`
--
ALTER TABLE `dicas_rapidas`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `dicas_rapidas_acessos`
--
ALTER TABLE `dicas_rapidas_acessos`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `djs`
--
ALTER TABLE `djs`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `djs_restricoes`
--
ALTER TABLE `djs_restricoes`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `estatisticas`
--
ALTER TABLE `estatisticas`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `indice_stm` (`codigo_stm`),
  ADD KEY `indice_pais` (`codigo_stm`,`pais`(10)),
  ADD KEY `indice_data` (`codigo_stm`,`data`),
  ADD KEY `indice_tempo_conectado` (`codigo_stm`,`tempo_conectado`),
  ADD KEY `indice_ip` (`codigo_stm`,`ip`(15)),
  ADD KEY `indice_robot` (`codigo_stm`,`data`,`ip`(12)),
  ADD KEY `player` (`player`),
  ADD KEY `codigo_stm` (`codigo_stm`,`data`,`hora`);

--
-- Índices para tabela `geoip`
--
ALTER TABLE `geoip`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `logs`
--
ALTER TABLE `logs`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `logs_acessos`
--
ALTER TABLE `logs_acessos`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `logs_streamings`
--
ALTER TABLE `logs_streamings`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `multipoint`
--
ALTER TABLE `multipoint`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `ouvintes_conectados`
--
ALTER TABLE `ouvintes_conectados`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `pedidos_musicais`
--
ALTER TABLE `pedidos_musicais`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `playlists`
--
ALTER TABLE `playlists`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `playlists_agendamentos`
--
ALTER TABLE `playlists_agendamentos`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `indice_data` (`data`);

--
-- Índices para tabela `playlists_agendamentos_logs`
--
ALTER TABLE `playlists_agendamentos_logs`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `playlists_musicas`
--
ALTER TABLE `playlists_musicas`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `indice_playlist` (`codigo_playlist`);

--
-- Índices para tabela `programetes_programas_links`
--
ALTER TABLE `programetes_programas_links`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `relay_agendamentos`
--
ALTER TABLE `relay_agendamentos`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `revendas`
--
ALTER TABLE `revendas`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `screen_size`
--
ALTER TABLE `screen_size`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `servidores`
--
ALTER TABLE `servidores`
  ADD PRIMARY KEY (`codigo`);

--
-- Índices para tabela `streamings`
--
ALTER TABLE `streamings`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `indice_porta` (`porta`),
  ADD KEY `indice_porta_dj` (`porta_dj`);

--
-- Índices para tabela `tutoriais`
--
ALTER TABLE `tutoriais`
  ADD PRIMARY KEY (`codigo`);

--
-- AUTO_INCREMENT de tabelas despejadas
--

--
-- AUTO_INCREMENT de tabela `administradores`
--
ALTER TABLE `administradores`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `apps`
--
ALTER TABLE `apps`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `atalhos`
--
ALTER TABLE `atalhos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `autodj_acoes`
--
ALTER TABLE `autodj_acoes`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `avisos`
--
ALTER TABLE `avisos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `avisos_desativados`
--
ALTER TABLE `avisos_desativados`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `bloqueios_login`
--
ALTER TABLE `bloqueios_login`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `certificados`
--
ALTER TABLE `certificados`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `dicas_rapidas`
--
ALTER TABLE `dicas_rapidas`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `dicas_rapidas_acessos`
--
ALTER TABLE `dicas_rapidas_acessos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `djs`
--
ALTER TABLE `djs`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `djs_restricoes`
--
ALTER TABLE `djs_restricoes`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `estatisticas`
--
ALTER TABLE `estatisticas`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `geoip`
--
ALTER TABLE `geoip`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `logs`
--
ALTER TABLE `logs`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `logs_acessos`
--
ALTER TABLE `logs_acessos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `logs_streamings`
--
ALTER TABLE `logs_streamings`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `multipoint`
--
ALTER TABLE `multipoint`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `ouvintes_conectados`
--
ALTER TABLE `ouvintes_conectados`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `pedidos_musicais`
--
ALTER TABLE `pedidos_musicais`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `playlists`
--
ALTER TABLE `playlists`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `playlists_agendamentos`
--
ALTER TABLE `playlists_agendamentos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `playlists_agendamentos_logs`
--
ALTER TABLE `playlists_agendamentos_logs`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `playlists_musicas`
--
ALTER TABLE `playlists_musicas`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `programetes_programas_links`
--
ALTER TABLE `programetes_programas_links`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `relay_agendamentos`
--
ALTER TABLE `relay_agendamentos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `revendas`
--
ALTER TABLE `revendas`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `screen_size`
--
ALTER TABLE `screen_size`
  MODIFY `codigo` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `servidores`
--
ALTER TABLE `servidores`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `streamings`
--
ALTER TABLE `streamings`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `tutoriais`
--
ALTER TABLE `tutoriais`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;
COMMIT;

ALTER TABLE `configuracoes` ADD `tipo_proxy` VARCHAR(255) NOT NULL DEFAULT 'php', ADD `url_app_painel` VARCHAR(255) NOT NULL;
ALTER TABLE `configuracoes` ADD `codigo_servidor_camera_studio_atual` INT(10) NOT NULL DEFAULT '0' AFTER `codigo_servidor_atual`;
ALTER TABLE `configuracoes` ADD `idioma_painel` VARCHAR(255) NOT NULL DEFAULT 'pt-br';
ALTER TABLE `streamings` ADD `codigo_servidor_camera_studio_atual` INT(10) NOT NULL DEFAULT '0' AFTER `codigo_servidor`;
ALTER TABLE `programetes_programas_links` ADD `dias` VARCHAR(255) NOT NULL DEFAULT '1,2,3,4,5,6,0';
CREATE TABLE `acessos_players` ( `codigo` int(10) NOT NULL AUTO_INCREMENT, `player` varchar(255) NOT NULL, `total` int(10) NOT NULL, PRIMARY KEY (`codigo`) ) ENGINE=MyISAM;
ALTER TABLE `revendas` ADD `camera_studio` CHAR(3) NOT NULL DEFAULT 'nao';
ALTER TABLE `streamings` CHANGE `encoder` `encoder` VARCHAR(255) NOT NULL DEFAULT 'aacp';
ALTER TABLE `streamings` CHANGE `aacplus` `aacplus` CHAR(3) NOT NULL DEFAULT 'sim';
ALTER TABLE `streamings` CHANGE `espaco` `espaco` INT(10) NOT NULL DEFAULT '0';
ALTER TABLE `streamings` ADD `camera_studio` CHAR(3) NOT NULL DEFAULT 'nao', ADD `camera_studio_instalado` CHAR(3) NOT NULL DEFAULT 'nao' AFTER `camera_studio`;
ALTER TABLE `playlists_agendamentos` ADD `inicio` INT(1) NOT NULL DEFAULT '2';
ALTER TABLE `playlists_agendamentos` ADD `ordem_musicas` INT(1) NOT NULL DEFAULT '1';
CREATE TABLE IF NOT EXISTS `configuracoes_backup`( `ftp_servidor` varchar(255) NOT NULL, `ftp_usuario` varchar(255) NOT NULL, `ftp_senha` varchar(255) NOT NULL, `bkp_arquivos` char(3) NOT NULL, `bkp_mysql` char(3) NOT NULL, `bkp_mysql_stats` char(3) NOT NULL, `log` longtext NOT NULL) ENGINE=MyISAM;
CREATE TABLE IF NOT EXISTS `lives`( `codigo` int(10) NOT NULL AUTO_INCREMENT, `codigo_stm` int(10) NOT NULL, `data_inicio` datetime NOT NULL, `data_fim` datetime NOT NULL, `tipo` varchar(255) NOT NULL, `status` int(1) NOT NULL DEFAULT '0', PRIMARY KEY (`codigo`)) ENGINE=MyISAM;
ALTER TABLE `streamings` ADD `tema_dark` CHAR(20) NOT NULL DEFAULT 'nao';
ALTER TABLE `revendas` ADD `tema_dark` CHAR(20) NOT NULL DEFAULT 'nao';
ALTER TABLE `configuracoes` ADD `tema_dark` CHAR(20) NOT NULL DEFAULT 'nao';
ALTER TABLE `streamings` ADD `site_adm` VARCHAR(3) NOT NULL DEFAULT 'sim';
ALTER TABLE `streamings` ADD `site_adm_instalado` VARCHAR(3) NOT NULL DEFAULT 'nao';
ALTER TABLE `streamings` ADD `site_adm_dominio` VARCHAR(255) NOT NULL;
ALTER TABLE `revendas` ADD `site_adm` INT(10) NOT NULL DEFAULT '0';
ALTER TABLE `streamings` ADD `app_nome` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_email` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_whatsapp` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_logo` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_icone` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_background` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_facebook` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_instagram` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_twitter` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_site` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_chat` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_camera_studio` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_pedir_musica` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_certificado` VARCHAR(255) NOT NULL DEFAULT 'padrao';
ALTER TABLE `streamings` ADD `app_package` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_url_youtube` VARCHAR(255) NOT NULL;
ALTER TABLE `streamings` ADD `app_msg_saudacao` VARCHAR(255) NOT NULL DEFAULT 'Seja Bem Vindo!';
ALTER TABLE `streamings` ADD `app_text_prog` LONGTEXT NOT NULL;
ALTER TABLE `streamings` ADD `app_text_hist` LONGTEXT NOT NULL;
CREATE TABLE IF NOT EXISTS `app_packages` ( `codigo` int(10) NOT NULL AUTO_INCREMENT, `codigo_stm` int(10) NOT NULL, `package` varchar(255) NOT NULL, PRIMARY KEY (`codigo`) ) ENGINE=MyISAM;