package com.shoutcast.stm.radio_nome.activities;

import static com.shoutcast.stm.radio_nome.utils.Constant.LOCALHOST_ADDRESS;

import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.widget.ProgressBar;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import com.shoutcast.stm.radio_nome.BuildConfig;
import com.shoutcast.stm.radio_nome.Config;
import com.shoutcast.stm.radio_nome.R;
import com.shoutcast.stm.radio_nome.callbacks.CallbackConfig;
import com.shoutcast.stm.radio_nome.database.dao.AppDatabase;
import com.shoutcast.stm.radio_nome.database.dao.DAO;
import com.shoutcast.stm.radio_nome.database.prefs.SharedPref;
import com.shoutcast.stm.radio_nome.models.Radio;
import com.shoutcast.stm.radio_nome.models.Settings;
import com.shoutcast.stm.radio_nome.rests.RestAdapter;
import com.shoutcast.stm.radio_nome.utils.Utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ActivitySplash extends AppCompatActivity {

    public static final String TAG = "ActivitySplash";
    ProgressBar progressBar;
    SharedPref sharedPref;
    Call<CallbackConfig> callbackCall = null;
    Radio radio;
    Settings settings;
    private DAO db;
    long id = System.currentTimeMillis();

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash);
        db = AppDatabase.getDb(this).get();
        sharedPref = new SharedPref(this);

        initAppConfiguration();

        progressBar = findViewById(R.id.progressBar);
        progressBar.setVisibility(View.VISIBLE);


    }

    private void initAppConfiguration() {
        if (Config.ENABLE_REMOTE_JSON) {
            requestConfig();
        } else {
            requestConfigFromAssets();
        }
    }

    @SuppressWarnings("ConstantConditions")
    private void requestConfig() {

        String remoteUrl = Config.URL_JSON;

        requestConfig(remoteUrl);

        Log.d(TAG, "Start request config");
    }

    private void requestConfig(String remoteUrl) {

        if (remoteUrl.startsWith("http://") || remoteUrl.startsWith("https://")) {
            if (remoteUrl.contains("https://drive.google.com")) {
                String driveUrl = remoteUrl.replace("https://", "").replace("http://", "");
                List<String> data = Arrays.asList(driveUrl.split("/"));
                String googleDriveFileId = data.get(3);
                callbackCall = RestAdapter.createAPI().getDriveJsonFileId(googleDriveFileId);
            } else {
                callbackCall = RestAdapter.createAPI().getJsonUrl(remoteUrl);
            }
        } else {
            callbackCall = RestAdapter.createAPI().getDriveJsonFileId(remoteUrl);
        }

        callbackCall.enqueue(new Callback<CallbackConfig>() {
            @Override
            public void onResponse(@NonNull Call<CallbackConfig> call, @NonNull Response<CallbackConfig> response) {
                CallbackConfig resp = response.body();
                displayApiResults(resp);
            }

            @Override
            public void onFailure(@NonNull Call<CallbackConfig> call, @NonNull Throwable t) {
                requestConfigFromAssets();
                Log.d(TAG, "onFailure : " + t.getMessage());
            }

        });
    }

    private void displayApiResults(CallbackConfig resp) {
        if (resp != null) {

            radio = resp.radio.get(0);
            settings = resp.settings.get(0);

            sharedPref.saveSettings(
                    settings.app_status,
                    settings.privacy_policy_url,
                    settings.more_apps_url,
                    settings.redirect_url,
                    radio.song_metadata,
                    radio.image_album_art,
                    radio.image_album_art_dynamic_background,
                    radio.blur_radio_background,
                    radio.auto_play
            );

            if (settings.app_status.equals("0")) {
                Intent intent = new Intent(getApplicationContext(), ActivityRedirect.class);
                startActivity(intent);
                finish();
                Log.d(TAG, "App status is inactive, open redirect activity");
            } else {
                db.deleteAllRadio();
                new Handler().postDelayed(() -> {
                    db.insertRadio(
                            id,
                            radio.radio_name,
                            radio.radio_genre,
                            radio.radio_url,
                            radio.radio_image_url,
                            radio.background_image_url
                    );
                    startMainActivity();
                }, 100);
            }
            Log.d(TAG, "success load config");
        } else {
            requestConfigFromAssets();
            Log.d(TAG, "error load remote json, start load config.json from assets");
        }
    }

    private void requestConfigFromAssets() {
        try {
            JSONObject jsonObject = new JSONObject(Objects.requireNonNull(Utils.loadJSONFromAsset(this, "config.json")));
            JSONArray radios = jsonObject.getJSONArray("radio");
            JSONArray settings = jsonObject.getJSONArray("settings");
            JSONArray socials = jsonObject.getJSONArray("socials");

            JSONObject radio = radios.getJSONObject(0);
            JSONObject setting = settings.getJSONObject(0);

            String radio_name = radio.getString("radio_name");
            String radio_genre = radio.getString("radio_genre");
            String radio_url = radio.getString("radio_url");
            String radio_image_url = radio.getString("radio_image_url");
            String background_image_url = radio.getString("background_image_url");
            String blur_radio_background = radio.getString("blur_radio_background");
            String song_metadata = radio.getString("song_metadata");
            String image_album_art = radio.getString("image_album_art");
            String image_album_art_dynamic_background = radio.getString("image_album_art_dynamic_background");
            String auto_play = radio.getString("auto_play");

            String app_status = setting.getString("app_status");
            String onesignal_app_id = setting.getString("onesignal_app_id");
            String fcm_notification_topic = setting.getString("fcm_notification_topic");
            String privacy_policy_url = setting.getString("privacy_policy_url");
            String more_apps_url = setting.getString("more_apps_url");
            String redirect_url = setting.getString("redirect_url");


            sharedPref.saveSettings(
                    app_status,
                    privacy_policy_url,
                    more_apps_url,
                    redirect_url,
                    song_metadata,
                    image_album_art,
                    image_album_art_dynamic_background,
                    blur_radio_background,
                    auto_play
            );


            db.deleteAllRadio();
            new Handler().postDelayed(() -> {
                db.insertRadio(
                        id,
                        radio_name,
                        radio_genre,
                        radio_url,
                        radio_image_url,
                        background_image_url
                );
                startMainActivity();
            }, 100);

            Log.d(TAG, "success");

        } catch (JSONException e) {
            e.printStackTrace();
            Log.d(TAG, "failed : " + e.getMessage());
            startMainActivity();
        }
    }

    private void startMainActivity() {
        new Handler().postDelayed(() -> {
            Intent intent = new Intent(getApplicationContext(), MainActivity.class);
            startActivity(intent);
            finish();
        }, Config.SPLASH_DURATION);
    }

    private void readSocial() {
        try {
            JSONObject object = new JSONObject(readJSON());
            JSONArray array = object.getJSONArray("socials");
            for (int i = 0; i < array.length(); i++) {
                JSONObject jsonObject = array.getJSONObject(i);
                String social_name = jsonObject.getString("social_name");
                String social_icon = jsonObject.getString("social_icon");
                String social_url = jsonObject.getString("social_url");
                String social_ext = jsonObject.getString("social_ext");
                db.deleteAllSocial();
                new Handler().postDelayed(() -> db.insertSocial(social_name, social_icon, social_url, social_ext), 100);
                Log.d(TAG, social_name);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String readJSON() {
        String json = null;
        try {
            // Opening data.json file
            InputStream inputStream = getAssets().open("config.json");
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            // read values in the byte array
            inputStream.read(buffer);
            inputStream.close();
            // convert byte to string
            json = new String(buffer, StandardCharsets.UTF_8);
        } catch (IOException e) {
            e.printStackTrace();
            return json;
        }
        return json;
    }

}
