<?php
require_once("inc/protecao-revenda.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Revenda <?php echo $dados_revenda["id"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <?php if($dados_revenda["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/admin/inc/ajax-revenda.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda-configuracoes"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda-configuracoes"><span>Painel Revenda</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/admin/revenda-configuracoes"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo lang_info_pagina_informacoes_revenda_tab_avisos; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_revenda($conexao); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu-revenda.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_menu_streaming; ?></header>
                                        <div class="card-header-right">
                                            <button type="button" class="btn btn-success" onClick="ligar_streamings_revenda();" data-toggle="tooltip" data-placement="bottom" title="<?php echo lang_acao_stm_ligar_todos; ?>"><i class="ik ik-play"></i>Streamings</button>
                                            <button type="button" class="btn btn-success" onClick="ligar_autodjs_revenda();" data-toggle="tooltip" data-placement="bottom" title="<?php echo lang_acao_stm_ligar_autodj_todos; ?>"><i class="ik ik-play"></i>AutoDJs</button>&nbsp;<button type="button" class="btn btn-info" onClick="window.location = '/admin/revenda-cadastrar-streaming';"><i class="ik ik-file-plus"></i><?php echo lang_botao_titulo_cadastrar; ?></button>
                                        </div>
                  </div>
                <div class="card-body">
                    <table id="data_table" class="table dataTable no-footer table-hover" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_porta; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_porta_dj; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_servidor; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_plano; ?></th>
                                                        <th class="nosort sorting_disabled" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_status; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_pagina_configurar_streaming_identificacao; ?></th>
                                                        <th class="nosort sorting_disabled" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_info_subrevenda_streamings_acoes; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
if(query_string('2') == "resultado") {

    if(query_string('3') == "porta") {
        $query = "SELECT * FROM streamings WHERE porta LIKE '%".query_string('4')."%' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "porta_dj") {
        $query = "SELECT * FROM streamings WHERE porta_dj LIKE '%".query_string('4')."%' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "ouvintes") {
        $query = "SELECT * FROM streamings WHERE ouvintes = '".query_string('4')."' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "bitrate") {
        $query = "SELECT * FROM streamings WHERE bitrate = '".query_string('4')."' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "encoder") {
        $query = "SELECT * FROM streamings WHERE encoder = '".query_string('4')."' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "identificacao") {
        $query = "SELECT * FROM streamings WHERE identificacao LIKE '%".query_string('4')."%' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "email") {
        $query = "SELECT * FROM streamings WHERE email LIKE '%".query_string('4')."%' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } elseif(query_string('3') == "data_cadastro") {
        $data_cadastro = query_string('6')."-".query_string('5')."-".query_string('4');
        $query = "SELECT * FROM streamings WHERE data_cadastro = '".$data_cadastro."' AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    } else {
        $query = "SELECT * FROM streamings WHERE (porta LIKE '%".query_string('4')."%' OR identificacao LIKE '%".query_string('4')."%') AND codigo_cliente = '".$dados_revenda["codigo"]."'";
    }

} else {
$query = "SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'";
}

$sql = mysqli_query($conexao,"".$query." ORDER by porta ASC");
while ($dados_stm = mysqli_fetch_array($sql)) {

$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
$total_playlists = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."'"));

if($dados_stm["status"] > 1) {
$cor_status = "class='table-danger'";
}

$status_conexao = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);
$status_conexao_transmissao = status_streaming_transmissao($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);

if($status_conexao == "ligado") {
$status = "<i class='ik ik-check-circle text-green'>&nbsp;".lang_info_status_ligado."</i>";
// Adiciona na lista para botao de ligar autodj
if($total_playlists > 0) {
    $array_autodjs .= "".code_decode($dados_stm["porta"],"E")."|";
}
} else {
$status = "<i class='ik ik-info'>&nbsp;".lang_info_status_desligado."</i>";
// Adiciona na lista para botao de ligar streaming
$array_streamings .= "".code_decode($dados_stm["porta"],"E")."|";
}

if($status_conexao_transmissao == "relay") {
$status = "<i class='ik ik-check-circle text-pink'>&nbsp;".lang_info_status_relay."</i>";
} elseif($status_conexao_transmissao == "autodj") {
$status = "<i class='ik ik-check-circle text-green'>&nbsp;".lang_info_status_autodj."</i>";
} elseif($status_conexao_transmissao == "aovivo") {
$status = "<i class='ik ik-check-circle text-red'>&nbsp;".lang_info_status_aovivo."</i>";
}

$servidor = ($dados_revenda["dominio_padrao"]) ? strtolower($dados_servidor["nome"]).".".$dados_revenda["dominio_padrao"] : strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"];

$porta_code = code_decode($dados_stm["porta"],"E");

echo "<tr id='".$porta_code."' ".$cor_status.">
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["porta"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["porta_dj"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$servidor."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["ouvintes"]." ".lang_info_subrevenda_streamings_ouvintes." | ".$dados_stm["bitrate"]." Kbps | ".tamanho($dados_stm["espaco"])." FTP</td>
<td height='25' align='left' scope='col'>".$status."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["identificacao"]."</td>
<td height='25' align='left' scope='col'>
<a href='/admin/revenda-configurar-streaming/".$porta_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_alterar_config."'><i class='fa fa-pencil f-16 text-blue'></i></a>&nbsp;
<a href='javascript:acessar_painel_streaming_revenda(\"".$porta_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_acessar_painel_streaming."'><i class='fa fa-home f-16 text-green'></i></a>&nbsp;
<a href='javascript:mover_streaming_revenda_subrevenda(\"".$porta_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_adm_mover."'><i class='fa fa-arrows f-16 text-pink'></i></a>&nbsp;
<a href='javascript:bloquear_streaming(\"".$porta_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_adm_bloquear."'><i class='fa fa-ban f-16 text-red'></i></a>&nbsp;
<a href='javascript:desbloquear_streaming(\"".$porta_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_adm_desbloquear."'><i class='fa fa-check-circle f-16 text-green'></i></a>&nbsp;
<a href='javascript:remover_streaming(\"".$porta_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_acao_stm_adm_remover."'><i class='fa fa-trash-o f-16 text-red'></i></a>&nbsp;
</td>
</td>
</tr>";

unset($cor_status);
}

$array_streamings = rtrim($array_streamings, "|");
$array_autodjs = rtrim($array_autodjs, "|");


?>
                                                </tbody>
                                            </table>
                                            <input id="lista_streamings" type="hidden" value="<?php echo $array_streamings; ?>" /><input id="lista_autodjs" type="hidden" value="<?php echo $array_autodjs; ?>" />
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/revenda-streamings/resultado/porta/"+document.getElementById("busca_chave").value;
    }
  });     
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });
  </script>
</body>
</html>