<?php
require_once("inc/protecao-revenda.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Revenda <?php echo $dados_revenda["id"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <?php if($dados_revenda["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/admin/inc/ajax-revenda.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda-configuracoes"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda-configuracoes"><span>Painel Revenda</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/admin/revenda-configuracoes"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo lang_info_pagina_informacoes_revenda_tab_avisos; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_revenda($conexao); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu-revenda.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_info_pagina_busca_avancada_tab_titulo; ?></header>
                  </div>
                <div class="card-body">
                    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="150" height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_busca_avancada_palavra_chave; ?></strong></td>
                                            <td align="left"><input name="chave" type="text" class="form-control" id="chave" style="width:100%;" value="" /></td>
                                          </tr>
                                          <tr>
                                            <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_busca_avancada_local; ?></strong></td>
                                            <td align="left">
                                            <select name="local" class="form-control" id="local" style="width:100%;">
                                            <optgroup label="<?php echo lang_info_pagina_busca_avancada_local_grupo_streaming; ?>">
                                            <option value="porta"><?php echo lang_info_pagina_busca_avancada_local_porta; ?></option>
                                            <option value="porta_dj"><?php echo lang_info_pagina_busca_avancada_local_porta_dj; ?></option>
                                            <option value="ouvintes"><?php echo lang_info_pagina_busca_avancada_local_ouvintes; ?></option>
                                            <option value="bitrate"><?php echo lang_info_pagina_busca_avancada_local_bitrate; ?></option>
                                            <option value="encoder"><?php echo lang_info_pagina_busca_avancada_local_encoder; ?></option>
                                            <option value="identificacao"><?php echo lang_info_pagina_busca_avancada_local_identificacao; ?></option>
                                            <option value="data_cadastro"><?php echo lang_info_pagina_busca_avancada_local_data_cadastro; ?></option>
                                            </optgroup>
                                            <optgroup label="<?php echo lang_info_pagina_busca_avancada_local_grupo_subrevenda; ?>">
                                            <option value="id"><?php echo lang_info_pagina_busca_avancada_local_id; ?></option>
                                            <option value="email"><?php echo lang_info_pagina_busca_avancada_local_email; ?></option>
                                            </optgroup>
                                            </select>
                                            </td>
                                          </tr>
                                          <tr>
                                            <td height="50" colspan="2" align="right"><button type="button" class="btn btn-info" onClick="busca_avancada();"><?php echo lang_info_pagina_enviar_email_botao_buscar; ?></button></td>
                                          </tr>
                                        </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/revenda-streamings/resultado/porta/"+document.getElementById("busca_chave").value;
    }
  }); 
  </script>
</body>
</html>