<?php
ini_set("memory_limit", "4096M");
ini_set("max_execution_time", 0);
set_time_limit(0);

require_once("/home/streaming/web/thumb.php");

$inicio_execucao = tempo_execucao();

/////////////////////////////////////////////
////////////// Funções Gerais ///////////////
/////////////////////////////////////////////

function formatar_nome_arquivo_cache($arquivo) {

$array_caracteres = array("/[ÂÀÁÄÃ]/"=>"a","/[âãàáä]/"=>"a","/[ÊÈÉË]/"=>"e","/[êèéë]/"=>"e","/[ÎÍÌÏ]/"=>"i","/[îíìï]/"=>"i","/[ÔÕÒÓÖ]/"=>"o", "/[ôõòóö]/"=>"o","/[ÛÙÚÜ]/"=>"u","/[ûúùü]/"=>"u","/ç/"=>"c","/Ç/"=> "c","/ /"=> "-","/_/"=> "-");

$formatado = preg_replace(array_keys($array_caracteres), array_values($array_caracteres), $arquivo);

return strtolower($formatado).".xml";
}

function timestampdiff($qw,$saw) {

    $datetime1 = new DateTime($qw);
    $datetime2 = new DateTime($saw);
    $interval = $datetime1->diff($datetime2);
    return $interval->format('%Hh %Im');
}

// Função para calcular tempo de exceussão
function tempo_execucao() {
    $sec = explode(" ",microtime());
    $tempo = $sec[1] + $sec[0];
    return $tempo;
}

/////////////////////////////////////////////
///////////// Variaveis Gerais //////////////
/////////////////////////////////////////////

$path_pasta_cache = "/home/streaming/cache";
$arquivo_locker = $path_pasta_cache."/gerar-cache-pastas.lock";
$local_thumb = '/home/streaming/web/thumb/';

// Verifica se esta sendo executado com a login especificada
if(isset($argv[1]) && is_dir("/home/streaming/".$argv[1])) {

$login = $argv[1];

echo "--------------------------------------------------------------------\n";
echo "Processando manualmente login ".$login."...\n";
echo "--------------------------------------------------------------------\n";

// Busca as pastas do streming
$path_login = "/home/streaming/".$login."";
	
// Pasta raiz/root
$lista_pastas_login[] = "/";
	
$pastas_login = new DirectoryIterator($path_login);

foreach($pastas_login as $pasta_login) {
		
	if(!$pasta_login->isDot() && $pasta_login->isDir()) {		
		$lista_pastas_login[] = $pasta_login->getFilename(); 
	}
			
}
	
// Busca as músicas das pastas 
foreach($lista_pastas_login as $pasta_login) {

	// Cria lock da pasta atual gerando cache.
	@file_put_contents($path_pasta_cache."/".$login.".lock",$login);

	$pasta = ($pasta_login == "/") ? "" : $pasta_login;
	
	$path_pasta = $path_login."/".$pasta;
	$arquivo_xml_cache_pasta = ($pasta_login == "/") ? $login."-root.xml" : $login."-".formatar_nome_arquivo_cache($pasta);
	
	$timestamp_pasta = @filemtime($path_pasta);
	$timestamp_cache = @filemtime($path_pasta_cache."/".$arquivo_xml_cache_pasta);
	
	if(!file_exists($path_pasta_cache."/".$arquivo_xml_cache_pasta)) {
	$timestamp_cache = $timestamp_pasta-1;
	}	

	if($timestamp_cache < $timestamp_pasta) {
	
		$dir = new DirectoryIterator($path_pasta);
		
		foreach($dir as $file) {
		
			if($file->isFile()) {
			
				if(pathinfo($file->getFilename(), PATHINFO_EXTENSION) == "mp4" || pathinfo($file->getFilename(), PATHINFO_EXTENSION) == "MP4") {
		
					$array_videos_pasta[] = $file->getFilename();
					
				}
			}
		}
			asort($array_videos_pasta);
			
		
		$xml = new XMLWriter;
		$xml->openMemory();
		$xml->startDocument('1.0','iso-8859-1');
		
		$xml->startElement("videos");

		foreach($array_videos_pasta as $video) {

			$video_info = json_decode(shell_exec("/usr/local/bin/ffprobe -v quiet -print_format json -show_format -show_streams '".$path_pasta."/".$video."'"));

			$tipo_stream = ($video_info->{'streams'}[0]->{'codec_type'} == "video") ? 0 : 1;

			$codec = $video_info->{'streams'}[$tipo_stream]->{'codec_name'};
			$width = $video_info->{'streams'}[$tipo_stream]->{'width'};
			$height = $video_info->{'streams'}[$tipo_stream]->{'height'};
			$duration = $video_info->{'format'}->{'duration'};
			$bitrate = floor($video_info->{'format'}->{'bit_rate'}/1000);
			$duration = $video_info->{'format'}->{'duration'};
			$framerate1 = strstr($video_info->{'streams'}[$tipo_stream]->{'r_frame_rate'}, '/', true);
			$framerate2 = str_replace("/","",strstr($video_info->{'streams'}[$tipo_stream]->{'r_frame_rate'}, '/'));

			// Verifica se já existe thumb e cria novo caso não exista
			$thumb_path_nome = $local_thumb.$login."_".md5($video).".jpg";

			if(file_exists($thumb_path_nome)) {
			$thumb = $thumb_path_nome;
			} else {
			$thumb = VideoTile::createMovieThumb($path_pasta.'/'.$video, $thumb_path_nome);
			}

			$xml->startElement("video");

			$xml->writeElement("nome", utf8_encode($video));
			$xml->writeElement("codec", $codec);
			$xml->writeElement("width", $width);
			$xml->writeElement("height", $height);
			$xml->writeElement("bitrate", $bitrate);
			$xml->writeElement("duracao", gmdate("H:i:s", $duration));
			$xml->writeElement("duracao_segundos", floor($duration));
			$xml->writeElement("framerate", round($framerate1/$framerate2));
			$xml->writeElement("thumb", $thumb);
				
			$xml->endElement();

				if ($_SERVER['argc'] > 1) {
					echo "Vídeo ".$path_pasta."/".$video."\n";
				}

		}
			
		$xml->endElement();
			
		$xml_cache = $xml->outputMemory();
			
		file_put_contents($path_pasta_cache."/".$arquivo_xml_cache_pasta,$xml_cache);
			
		echo "Cache da pasta ".$arquivo_xml_cache_pasta." criado/atualizado.\n";

		unset($array_videos_pasta);
		unset($duration);
	}
		
}

unlink($path_pasta_cache."/".$login.".lock");

$fim_execucao = tempo_execucao();

$tempo_execucao = gmdate("H:i:s", round($fim_execucao-$inicio_execucao));

echo "\n--------------------------------------------------------------------\n";
echo "Processo finalizado em ".$tempo_execucao."\n";
echo "--------------------------------------------------------------------\n\n";

exit();
}

// Verifica se gerador de cache já esta em execussã0
if(file_exists($arquivo_locker)) {
echo "--------------------------------------------------------------------\n";
echo "O gerador já esta em execussão, aguarde finalizar para iniciar outro.\n";
echo "--------------------------------------------------------------------\n";

if(filemtime($arquivo_locker) < ( time() - ( 1 * 60 * 60 ) ) ) {
unlink($arquivo_locker);
}

exit();
}

// Cria lockers para evitar processos duplicados
file_put_contents($arquivo_locker,time());

// Busca os streamings
$dir_logins = new DirectoryIterator("/home/streaming");

foreach($dir_logins as $dir_login) {

	if(!$dir_login->isDot() && $dir_login->isDir()) {
	
	$login = $dir_login->getFilename();

	if(is_dir("/home/streaming/".$login)) {
	
	echo "--------------------------------------------------------------------\n";
	echo "Processando login ".$login."...\n";
	echo "--------------------------------------------------------------------\n";
	
	// Busca as pastas do streming
	$path_login = "/home/streaming/".$login."";
	
	// Pasta raiz/root
	$lista_pastas_login[] = "/";
	
	$pastas_login = new DirectoryIterator($path_login);

	foreach($pastas_login as $pasta_login) {
		
		if(!$pasta_login->isDot() && $pasta_login->isDir()) {		
			$lista_pastas_login[] = $pasta_login->getFilename(); 
		}
			
	}
	
	// Verifica se existe lock da pasta e pula para proxima pasta
	if(!file_exists($path_pasta_cache."/".$login.".lock")) {

	// Busca as músicas das pastas 
	foreach($lista_pastas_login as $pasta_login) {

		// Cria lock da pasta atual gerando cache.
		file_put_contents($path_pasta_cache."/".$login.".lock",$login);
	
		$pasta = ($pasta_login == "/") ? "" : $pasta_login;
		
		$path_pasta = $path_login."/".$pasta;
		$arquivo_xml_cache_pasta = ($pasta_login == "/") ? $login."-root.xml" : $login."-".formatar_nome_arquivo_cache($pasta);
		
		$timestamp_pasta = @filemtime($path_pasta);
		$timestamp_cache = @filemtime($path_pasta_cache."/".$arquivo_xml_cache_pasta);
		
		if(!file_exists($path_pasta_cache."/".$arquivo_xml_cache_pasta)) {
		$timestamp_cache = $timestamp_pasta-1;
		}	
	
		if($timestamp_cache < $timestamp_pasta) {
		
			$dir = new DirectoryIterator($path_pasta);
			
			foreach($dir as $file) {
			
				if($file->isFile()) {
				
					if(pathinfo($file->getFilename(), PATHINFO_EXTENSION) == "mp4" || pathinfo($file->getFilename(), PATHINFO_EXTENSION) == "MP4") {
			
						$array_videos_pasta[] = $file->getFilename();
						
					}
				}
			}

			asort($array_videos_pasta);

			
			
			$xml = new XMLWriter;
			$xml->openMemory();
			$xml->startDocument('1.0','iso-8859-1');
			
			$xml->startElement("videos");

			foreach($array_videos_pasta as $video) {

				$video_info = json_decode(shell_exec("/usr/local/bin/ffprobe -v quiet -print_format json -show_format -show_streams '".$path_pasta."/".$video."'"));

				$tipo_stream = ($video_info->{'streams'}[0]->{'codec_type'} == "video") ? 0 : 1;

				$codec = $video_info->{'streams'}[$tipo_stream]->{'codec_name'};
				$width = $video_info->{'streams'}[$tipo_stream]->{'width'};
				$height = $video_info->{'streams'}[$tipo_stream]->{'height'};
				$duration = $video_info->{'format'}->{'duration'};
				$bitrate = floor($video_info->{'format'}->{'bit_rate'}/1000);
				$duration = $video_info->{'format'}->{'duration'};
				$framerate1 = strstr($video_info->{'streams'}[$tipo_stream]->{'r_frame_rate'}, '/', true);
				$framerate2 = str_replace("/","",strstr($video_info->{'streams'}[$tipo_stream]->{'r_frame_rate'}, '/'));

				// Verifica se já existe thumb e cria novo caso não exista
				$thumb_path_nome = $local_thumb.$login."_".md5($video).".jpg";

				if(file_exists($thumb_path_nome)) {
					$thumb = $thumb_path_nome;
				} else {
					$thumb = VideoTile::createMovieThumb($path_pasta.'/'.$video, $thumb_path_nome);
				}

				$xml->startElement("video");

				$xml->writeElement("nome", utf8_encode($video));
				$xml->writeElement("codec", $codec);
				$xml->writeElement("width", $width);
				$xml->writeElement("height", $height);
				$xml->writeElement("bitrate", $bitrate);
				$xml->writeElement("duracao", gmdate("H:i:s", $duration));
				$xml->writeElement("duracao_segundos", floor($duration));
				$xml->writeElement("framerate", round($framerate1/$framerate2));
				$xml->writeElement("thumb", $thumb);
						
				$xml->endElement();

				if($argv[1] == "log" || $argv[2] == "log") {
					echo "Vídeo ".$path_pasta."/".$video."\n";
				}

			}
			
			$xml->endElement();
			
			$xml_cache = $xml->outputMemory();
			
			file_put_contents($path_pasta_cache."/".$arquivo_xml_cache_pasta,$xml_cache);
			
			echo "Cache da pasta ".$arquivo_xml_cache_pasta." criado/atualizado.\n";

			unset($array_videos_pasta);
			unset($duration);
		}
		
	}

	unlink($path_pasta_cache."/".$login.".lock");
	
	}
	
	}
	
	}
}

$fim_execucao = tempo_execucao();

$tempo_execucao = gmdate("H:i:s", round($fim_execucao-$inicio_execucao));

unlink($arquivo_locker);

echo "\n--------------------------------------------------------------------\n";
echo "Processo finalizado em ".$tempo_execucao."\n";
echo "--------------------------------------------------------------------\n\n";
?>
